/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.annotation.SuppressLint;
import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.umeng.commonsdk.debug.UMLog;
import com.umeng.message.MessageNotificationQueue;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.NotificationProxyBroadcastReceiver;
import com.umeng.message.PushAgent;
import com.umeng.message.UHandler;
import com.umeng.message.UTrack;
import com.umeng.message.UmengDownloadResourceService;
import com.umeng.message.common.d;
import com.umeng.message.entity.UMessage;
import com.umeng.message.entity.UNotificationItem;
import com.umeng.message.proguard.h;
import com.umeng.message.service.UMJobIntentService;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Random;

public class UmengMessageHandler
implements UHandler {
    private static int a = 64;
    private static final String b = UmengMessageHandler.class.getName();
    private static Date c;
    private static String d;
    private UMessage e = null;
    private int f;
    public static boolean isChannelSet;
    public static final String PRIMARY_CHANNEL = "upush_default";
    public static final String DEFAULT_NOTIFICATION_CHANNEL_NAME = "Default";
    private static final String g = "umeng_push_notification_default_large_icon";
    private static final String h = "umeng_push_notification_default_small_icon";
    private static final String i = "umeng_push_notification_default_sound";

    public void setPrevMessage(UMessage uMessage) {
        this.e = uMessage;
    }

    @Override
    public void handleMessage(Context context, UMessage uMessage) {
        if ("notification".equals(uMessage.display_type)) {
            this.dealWithNotificationMessage(context, uMessage);
        } else if ("custom".equals(uMessage.display_type)) {
            UTrack.getInstance(context).setClearPrevMessage(false);
            if (!TextUtils.isEmpty((CharSequence)uMessage.recall)) {
                this.a(context, uMessage);
            } else {
                this.dealWithCustomMessage(context, uMessage);
            }
        }
    }

    public void dealWithNotificationMessage(Context context, UMessage uMessage) {
        PendingIntent pendingIntent;
        Notification.Builder builder;
        boolean bl;
        UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"notify: " + uMessage.getRaw().toString()});
        String string = null;
        String string2 = null;
        if (uMessage.hasResourceFromInternet() && !MessageSharedPrefs.getInstance(context).hasMessageResourceDownloaded(uMessage.msg_id) && (bl = this.startDownloadResourceService(context, uMessage))) {
            return;
        }
        String string3 = MessageSharedPrefs.getInstance(context).getLastMessageMsgID();
        string = "".equals(string3) ? "" : string3.substring(7, 20);
        if (uMessage.msg_id != null && 22 == uMessage.msg_id.length() && uMessage.msg_id.startsWith("u")) {
            MessageSharedPrefs.getInstance(context).setLastMessageMsgID(uMessage.msg_id);
            string2 = uMessage.msg_id.substring(7, 20);
        } else {
            string2 = d;
        }
        boolean bl2 = "".equals(string) ? true : string2.compareToIgnoreCase(string) >= 0;
        MessageSharedPrefs.getInstance(context).removeMessageResouceRecord(uMessage.msg_id);
        Notification notification = this.getNotification(context, uMessage);
        if (notification == null || notification.icon == 0) {
            // empty if block
        }
        if (notification == null) {
            int n;
            NotificationManager notificationManager;
            builder = null;
            if (Build.VERSION.SDK_INT >= 26) {
                if (!isChannelSet) {
                    isChannelSet = true;
                    NotificationChannel notificationChannel = new NotificationChannel(PRIMARY_CHANNEL, (CharSequence)this.a(context), 3);
                    notificationManager = (NotificationManager)context.getSystemService("notification");
                    if (notificationManager != null) {
                        notificationManager.createNotificationChannel(notificationChannel);
                    }
                }
                builder = new Notification.Builder(context, PRIMARY_CHANNEL);
            } else {
                builder = new Notification.Builder(context);
            }
            if (!TextUtils.isEmpty((CharSequence)uMessage.expand_image) && Build.VERSION.SDK_INT >= 16) {
                builder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(this.getExpandImage(context, uMessage)));
            }
            if (!TextUtils.isEmpty((CharSequence)uMessage.bar_image)) {
                n = this.getSmallIconId(context, uMessage);
                if (n < 0) {
                    return;
                }
                notificationManager = new RemoteViews(context.getPackageName(), com.umeng.message.common.d.a(context).e("upush_bar_image_notification"));
                notificationManager.setImageViewBitmap(com.umeng.message.common.d.a(context).b("notification_bar_image"), this.getBarImage(context, uMessage));
                builder.setContent((RemoteViews)notificationManager).setSmallIcon(n).setTicker((CharSequence)uMessage.ticker).setAutoCancel(true);
            } else {
                n = this.a(context, builder, uMessage) ? 1 : 0;
                if (n == 0) {
                    return;
                }
                builder.setContentTitle((CharSequence)uMessage.title).setContentText((CharSequence)uMessage.text).setTicker((CharSequence)uMessage.ticker).setAutoCancel(true);
            }
            notification = builder.getNotification();
        }
        this.f = new Random(System.nanoTime()).nextInt();
        builder = this.getClickPendingIntent(context, uMessage);
        notification.deleteIntent = pendingIntent = this.getDismissPendingIntent(context, uMessage);
        notification.contentIntent = builder;
        int n = this.getNotificationDefaults(context, uMessage);
        if ((n & 1) != 0) {
            Uri uri = this.getSound(context, uMessage);
            if (uri != null) {
                notification.sound = this.getSound(context, uMessage);
            }
            if (uri != null) {
                n ^= 1;
            }
        }
        notification.defaults = n;
        this.a(context, notification, bl2, uMessage);
    }

    private String a(Context context) {
        String string = PushAgent.getInstance(context).getNotificationChannelName();
        if (TextUtils.isEmpty((CharSequence)string)) {
            return DEFAULT_NOTIFICATION_CHANNEL_NAME;
        }
        return string;
    }

    private void a(Context context, Notification notification, boolean bl, UMessage uMessage) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            int n = this.f;
            boolean bl2 = PushAgent.getInstance(context).getNotificationOnForeground();
            if (!bl2 && com.umeng.message.proguard.h.c(context) && com.umeng.message.proguard.h.b(context)) {
                UTrack.getInstance(context).setClearPrevMessage(false);
                UTrack.getInstance(context).trackMsgDismissed(uMessage);
                return;
            }
            int n2 = MessageSharedPrefs.getInstance(context).getDisplayNotificationNumber();
            if (n2 == 1 && !bl) {
                UTrack.getInstance(context).setClearPrevMessage(false);
                UTrack.getInstance(context).trackMsgDismissed(uMessage);
                return;
            }
            MessageNotificationQueue messageNotificationQueue = MessageNotificationQueue.getInstance();
            if (n2 > 0) {
                while (messageNotificationQueue.size() >= n2) {
                    UNotificationItem uNotificationItem = messageNotificationQueue.pollFirst();
                    if (notificationManager != null) {
                        try {
                            notificationManager.cancel(uNotificationItem.id);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    UTrack.getInstance(context).setClearPrevMessage(false);
                    UTrack.getInstance(context).trackMsgDismissed(uNotificationItem.message);
                }
            }
            messageNotificationQueue.addLast(new UNotificationItem(n, uMessage));
            if (notificationManager != null) {
                notificationManager.notify(n, notification);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    @SuppressLint(value={"NewApi", "Wakelock"})
    private void b(Context context) {
        try {
            final PowerManager powerManager = (PowerManager)context.getSystemService("power");
            boolean bl = false;
            if (Build.VERSION.SDK_INT >= 7) {
                bl = new Object(){

                    boolean a() {
                        return powerManager.isScreenOn();
                    }
                }.a();
            } else {
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"android os version < 7, skip checking screen on status"});
            }
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"\u5c4f\u5e55\u5f00\u542f\u72b6\u6001\uff1a" + bl});
            if (!bl) {
                PowerManager.WakeLock wakeLock = powerManager.newWakeLock(0x30000006, "MyLock");
                wakeLock.acquire(10000L);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void dealWithCustomMessage(Context context, UMessage uMessage) {
    }

    public PendingIntent getClickPendingIntent(Context context, UMessage uMessage) {
        Intent intent = new Intent();
        intent.setClass(context, NotificationProxyBroadcastReceiver.class);
        intent.putExtra("MSG", uMessage.getRaw().toString());
        intent.putExtra("ACTION", 10);
        intent.putExtra("MESSAGE_ID", uMessage.message_id);
        intent.putExtra("NOTIFICATION_ID", this.f);
        intent.putExtra("TASK_ID", uMessage.task_id);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)((int)System.currentTimeMillis()), (Intent)intent, (int)0x10000000);
        return pendingIntent;
    }

    public PendingIntent getDismissPendingIntent(Context context, UMessage uMessage) {
        Intent intent = new Intent();
        intent.setClass(context, NotificationProxyBroadcastReceiver.class);
        intent.putExtra("MSG", uMessage.getRaw().toString());
        intent.putExtra("ACTION", 11);
        intent.putExtra("MESSAGE_ID", uMessage.message_id);
        intent.putExtra("NOTIFICATION_ID", this.f);
        intent.putExtra("TASK_ID", uMessage.task_id);
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)((int)(System.currentTimeMillis() + 1L)), (Intent)intent, (int)0x10000000);
        return pendingIntent;
    }

    public boolean isInNoDisturbTime(Context context) {
        boolean bl;
        int n;
        int n2 = Calendar.getInstance().get(11);
        boolean bl2 = n2 * 60 + (n = Calendar.getInstance().get(12)) >= PushAgent.getInstance(context).getNoDisturbStartHour() * 60 + PushAgent.getInstance(context).getNoDisturbStartMinute();
        boolean bl3 = n2 * 60 + n <= PushAgent.getInstance(context).getNoDisturbEndHour() * 60 + PushAgent.getInstance(context).getNoDisturbEndMinute();
        boolean bl4 = bl = PushAgent.getInstance(context).getNoDisturbEndHour() * 60 + PushAgent.getInstance(context).getNoDisturbEndMinute() >= PushAgent.getInstance(context).getNoDisturbStartHour() * 60 + PushAgent.getInstance(context).getNoDisturbStartMinute();
        boolean bl5 = bl ? bl2 && bl3 : bl2 || bl3;
        return bl5;
    }

    public int getNotificationDefaults(Context context, UMessage uMessage) {
        int n = 0;
        boolean bl = this.isInNoDisturbTime(context);
        int n2 = MessageSharedPrefs.getInstance(context).getMuteDuration();
        long l2 = 1L * (long)n2 * 1000L;
        if (bl) {
            n = 0;
        } else if (c != null && Calendar.getInstance().getTimeInMillis() - c.getTime() < l2) {
            n = 0;
        } else {
            int n3 = MessageSharedPrefs.getInstance(context).getNotificationPlayVibrate();
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"playVibrate:" + n3});
            if (n3 == 1) {
                n |= 2;
            } else if (n3 != 2 && uMessage.play_vibrate) {
                n |= 2;
            }
            int n4 = MessageSharedPrefs.getInstance(context).getNotificationPlayLights();
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"playLights:" + n4});
            if (n4 == 1) {
                n |= 4;
            } else if (n4 != 2 && uMessage.play_lights) {
                n |= 4;
            }
            int n5 = MessageSharedPrefs.getInstance(context).getNotificationPlaySound();
            UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"playSound:" + n5});
            if (n5 == 1) {
                n |= 1;
            } else if (n5 != 2 && uMessage.play_sound) {
                n |= 1;
            }
            c = Calendar.getInstance().getTime();
            if (uMessage.screen_on) {
                this.b(context);
            }
        }
        return n;
    }

    public boolean startDownloadResourceService(Context context, UMessage uMessage) {
        try {
            Intent intent = new Intent(context, UmengDownloadResourceService.class);
            intent.putExtra("body", uMessage.getRaw().toString());
            intent.putExtra("id", uMessage.message_id);
            intent.putExtra("task_id", uMessage.task_id);
            UMJobIntentService.enqueueWork(context, UmengDownloadResourceService.class, intent);
            return true;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    private boolean a(Context context, Notification.Builder builder, UMessage uMessage) {
        int n = this.getSmallIconId(context, uMessage);
        Bitmap bitmap = this.getLargeIcon(context, uMessage);
        if (n < 0) {
            return false;
        }
        builder.setSmallIcon(n);
        builder.setLargeIcon(bitmap);
        return true;
    }

    public int getSmallIconId(Context context, UMessage uMessage) {
        int n = -1;
        try {
            if (!TextUtils.isEmpty((CharSequence)uMessage.icon)) {
                n = com.umeng.message.common.d.a(context).d(uMessage.icon);
            }
            if (n < 0) {
                n = com.umeng.message.common.d.a(context).d(h);
            }
            if (n < 0) {
                UMLog.mutlInfo((String)b, (int)2, (String[])new String[]{"\u6ca1\u6709\u81ea\u5b9a\u4e49\u901a\u77e5\u56fe\u6807\uff0c\u6539\u7528\u5e94\u7528\u56fe\u6807"});
                n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).applicationInfo.icon;
            }
            if (n < 0) {
                UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"\u627e\u4e0d\u5230\u9002\u5f53\u7684\u901a\u77e5\u56fe\u6807\uff0c\u8bf7\u786e\u4fdd\u60a8\u4e3a\u6b64\u901a\u77e5\u6307\u5b9a\u4e86\u4e00\u4e2a\u56fe\u6807\uff0c\u6216\u8005\u5e94\u7528\u5df2\u7ecf\u5b9a\u4e49\u4e86\u4e00\u4e2a\u56fe\u6807"});
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return n;
    }

    public Bitmap getLargeIcon(Context context, UMessage uMessage) {
        Bitmap bitmap = null;
        try {
            if (uMessage.isLargeIconFromInternet()) {
                String string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage) + uMessage.img.hashCode();
                bitmap = BitmapFactory.decodeFile((String)string);
            }
            if (bitmap == null) {
                int n = -1;
                if (!TextUtils.isEmpty((CharSequence)uMessage.largeIcon)) {
                    n = com.umeng.message.common.d.a(context).d(uMessage.largeIcon);
                }
                if (n < 0) {
                    n = com.umeng.message.common.d.a(context).d(g);
                }
                if (n > 0) {
                    bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n);
                }
            }
            return bitmap;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public Bitmap getBarImage(Context context, UMessage uMessage) {
        String string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage) + uMessage.bar_image.hashCode();
        return BitmapFactory.decodeFile((String)string);
    }

    public Bitmap getExpandImage(Context context, UMessage uMessage) {
        String string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage) + uMessage.expand_image.hashCode();
        return BitmapFactory.decodeFile((String)string);
    }

    public Uri getSound(Context context, UMessage uMessage) {
        String string = null;
        try {
            if (uMessage.isSoundFromInternet() && !new File(string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage) + uMessage.sound.hashCode()).exists()) {
                string = null;
            }
            if (string == null) {
                int n = -1;
                if (!TextUtils.isEmpty((CharSequence)uMessage.sound)) {
                    n = com.umeng.message.common.d.a(context).j(uMessage.sound);
                }
                if (n < 0) {
                    n = com.umeng.message.common.d.a(context).j(i);
                }
                if (n > 0) {
                    string = "android.resource://" + context.getPackageName() + "/" + n;
                }
            }
            if (string != null) {
                Uri uri = Uri.parse(string);
                return uri;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Notification getNotification(Context context, UMessage uMessage) {
        return null;
    }

    private void a(Context context, UMessage uMessage) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager == null) {
                return;
            }
            LinkedList<UNotificationItem> linkedList = MessageNotificationQueue.getInstance().getQueue();
            for (UNotificationItem uNotificationItem : linkedList) {
                if (!uMessage.recall.equals(uNotificationItem.message.msg_id)) continue;
                notificationManager.cancel(uNotificationItem.id);
                MessageNotificationQueue.getInstance().remove(uNotificationItem);
                UTrack.getInstance(context).a(uMessage);
                return;
            }
            UTrack.getInstance(context).b(uMessage);
        }
        catch (Exception exception) {
            UMLog.mutlInfo((String)b, (int)0, (String[])new String[]{"\u901a\u77e5\u53ec\u56de\u5f02\u5e38"});
        }
    }

    static {
        d = "9999999999999";
        isChannelSet = false;
    }
}

