/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common.impl.json;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.commonsdk.debug.UMLog;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.MsgConstant;
import com.umeng.message.common.UmengMessageDeviceConfig;
import com.umeng.message.common.impl.json.JUtrack;
import com.umeng.message.common.inter.ITagManager;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class JTagManager
implements ITagManager {
    private static final String a = JTagManager.class.getSimpleName();
    private Context b;

    public JTagManager(Context context) {
        this.b = context;
    }

    @Override
    public ITagManager.Result addTags(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.TAG_ENDPOINT + "/add";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                UMLog.mutlInfo((String)a, (int)2, (String)"\u6dfb\u52a0tag UnknownHostException");
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok")) {
            MessageSharedPrefs.getInstance(this.b).addTags(stringArray);
            MessageSharedPrefs.getInstance(this.b).setTagRemain(result.remain);
            MessageSharedPrefs.getInstance(this.b).add_addTagsInterval(result.toString());
        }
        return result;
    }

    @Override
    public ITagManager.Result addWeightedTags(JSONObject jSONObject, Hashtable<String, Integer> hashtable) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.WEIGHTED_TAG_ENDPOINT + "/incr";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                UMLog.mutlInfo((String)a, (int)2, (String)"\u6dfb\u52a0\u52a0\u6743\u6807\u7b7e UnknownHostException");
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        UMLog.mutlInfo((String)a, (int)2, (String)jSONObject2.toString());
        ITagManager.Result result = new ITagManager.Result(jSONObject2, true);
        MessageSharedPrefs.getInstance(this.b).setAddWeightedTagsInterval(result.toString());
        return result;
    }

    @Override
    public ITagManager.Result update(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.TAG_ENDPOINT + "/update";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok")) {
            MessageSharedPrefs.getInstance(this.b).resetTags();
            MessageSharedPrefs.getInstance(this.b).addTags(stringArray);
            MessageSharedPrefs.getInstance(this.b).setTagRemain(result.remain);
        }
        return result;
    }

    @Override
    public ITagManager.Result deleteTags(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.TAG_ENDPOINT + "/delete";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok")) {
            MessageSharedPrefs.getInstance(this.b).removeTags(stringArray);
            MessageSharedPrefs.getInstance(this.b).setTagRemain(result.remain);
            MessageSharedPrefs.getInstance(this.b).add_deleteTagsInterval(result.toString());
        }
        return result;
    }

    @Override
    public ITagManager.Result deleteWeightedTags(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.WEIGHTED_TAG_ENDPOINT + "/delete";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, true);
        MessageSharedPrefs.getInstance(this.b).setDeleteWeightedTagsInterval(result.toString());
        return result;
    }

    @Override
    public ITagManager.Result reset(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.TAG_ENDPOINT + "/reset";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok")) {
            MessageSharedPrefs.getInstance(this.b).resetTags();
        }
        return result;
    }

    @Override
    public List<String> getTags(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.TAG_ENDPOINT + "/get";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok") && jSONObject2.getString("tags") != null) {
            UMLog.mutlInfo((String)a, (int)2, (String)jSONObject2.getString("tags"));
            MessageSharedPrefs.getInstance(this.b).add_getTagsInteral(result.toString());
            return Arrays.asList(jSONObject2.getString("tags").split(","));
        }
        return null;
    }

    @Override
    public Hashtable<String, Integer> getWeightedTags(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2 = null;
        String string = MsgConstant.WEIGHTED_TAG_ENDPOINT + "/list";
        try {
            jSONObject2 = JUtrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception != null && exception.getMessage() != null && exception.getMessage().contains("java.net.UnknownHostException") && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUtrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, true);
        MessageSharedPrefs.getInstance(this.b).setListWeightedTagsInterval(result.toString());
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        JSONObject jSONObject3 = jSONObject2.optJSONObject("data").optJSONObject("tags");
        if (jSONObject3 != null) {
            Iterator iterator = jSONObject3.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n = jSONObject3.getInt(string2);
                hashtable.put(string2, n);
            }
        }
        return hashtable;
    }
}

