/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.app.Notification;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.umeng.message.MessageNotificationQueue;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.PushAgent;
import com.umeng.message.UTrack;
import com.umeng.message.UmengDownloadResourceService;
import com.umeng.message.UmengNotificationReceiver;
import com.umeng.message.api.UPushMessageHandler;
import com.umeng.message.common.UPLog;
import com.umeng.message.common.UPushNotificationChannel;
import com.umeng.message.entity.UMessage;
import com.umeng.message.entity.UNotificationItem;
import com.umeng.message.proguard.aj;
import com.umeng.message.proguard.an;
import com.umeng.message.proguard.x;
import com.umeng.message.service.UMJobIntentService;
import java.io.File;
import java.util.Calendar;
import java.util.Date;
import java.util.LinkedList;
import java.util.Random;

public class UmengMessageHandler
implements UPushMessageHandler {
    private static final String a = "UmengMessageHandler";
    private static Date b;
    private static final String c = "9999999999999";
    private int d;
    public static boolean isChannelSet;
    private static final String e = "umeng_push_notification_default_large_icon";
    private static final String f = "umeng_push_notification_default_small_icon";
    private static final String g = "umeng_push_notification_default_sound";

    @Override
    public void handleMessage(Context context, UMessage uMessage) {
        if ("notification".equals(uMessage.display_type)) {
            this.dealWithNotificationMessage(context, uMessage);
        } else if ("custom".equals(uMessage.display_type)) {
            if (!TextUtils.isEmpty((CharSequence)uMessage.recall)) {
                this.a(context, uMessage);
            } else {
                this.dealWithCustomMessage(context, uMessage);
            }
        }
    }

    public void dealWithNotificationMessage(Context context, UMessage uMessage) {
        PendingIntent pendingIntent;
        RemoteViews remoteViews;
        Notification.Builder builder;
        String string;
        boolean bl;
        UPLog.i(a, "notify: " + uMessage.getRaw().toString());
        MessageSharedPrefs messageSharedPrefs = MessageSharedPrefs.getInstance(context);
        if (uMessage.hasResourceFromInternet() && messageSharedPrefs.shouldDownloadResource(uMessage.msg_id) && (bl = this.startDownloadResourceService(context, uMessage))) {
            return;
        }
        String string2 = messageSharedPrefs.getLastMessageMsgID();
        String string3 = "".equals(string2) || 22 != string2.length() ? "" : string2.substring(7, 20);
        if (uMessage.msg_id != null && 22 == uMessage.msg_id.length() && uMessage.msg_id.startsWith("u")) {
            messageSharedPrefs.setLastMessageMsgID(uMessage.msg_id);
            string = uMessage.msg_id.substring(7, 20);
        } else {
            string = c;
        }
        boolean bl2 = "".equals(string3) ? true : string.compareToIgnoreCase(string3) >= 0;
        messageSharedPrefs.removeMessageResourceRecord(uMessage.msg_id);
        Notification notification = this.getNotification(context, uMessage);
        int n2 = this.getNotificationDefaults(context, uMessage);
        if (notification == null) {
            int n3;
            if (Build.VERSION.SDK_INT >= 26) {
                NotificationChannel notificationChannel = this.isInNoDisturbTime(context) ? UPushNotificationChannel.getSilenceMode(context) : UPushNotificationChannel.getDefaultMode(context);
                if (notificationChannel == null) {
                    return;
                }
                builder = new Notification.Builder(context, notificationChannel.getId());
            } else {
                builder = new Notification.Builder(context);
            }
            if (!TextUtils.isEmpty((CharSequence)uMessage.expand_image) && Build.VERSION.SDK_INT >= 16) {
                builder.setStyle((Notification.Style)new Notification.BigPictureStyle().bigPicture(this.getExpandImage(context, uMessage)));
            }
            if (!TextUtils.isEmpty((CharSequence)uMessage.bar_image)) {
                n3 = this.getSmallIconId(context, uMessage);
                if (n3 < 0) {
                    return;
                }
                remoteViews = new RemoteViews(context.getPackageName(), x.a("upush_bar_image_notification"));
                remoteViews.setImageViewBitmap(x.b("notification_bar_image"), this.getBarImage(context, uMessage));
                builder.setContent(remoteViews).setSmallIcon(n3).setTicker((CharSequence)uMessage.ticker).setAutoCancel(true);
            } else {
                n3 = this.a(context, builder, uMessage) ? 1 : 0;
                if (n3 == 0) {
                    return;
                }
                builder.setContentTitle((CharSequence)uMessage.title).setContentText((CharSequence)uMessage.text).setTicker((CharSequence)uMessage.ticker).setAutoCancel(true);
            }
            notification = builder.getNotification();
        }
        this.d = new Random(System.nanoTime()).nextInt();
        builder = this.getClickPendingIntent(context, uMessage);
        notification.deleteIntent = pendingIntent = this.getDismissPendingIntent(context, uMessage);
        notification.contentIntent = builder;
        if ((n2 & 1) != 0) {
            remoteViews = this.getSound(context, uMessage);
            if (remoteViews != null) {
                notification.sound = this.getSound(context, uMessage);
            }
            if (remoteViews != null) {
                n2 ^= 1;
            }
        }
        notification.defaults = n2;
        this.a(context, notification, bl2, uMessage);
    }

    private void a(Context context, Notification notification, boolean bl, UMessage uMessage) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            int n2 = this.d;
            boolean bl2 = PushAgent.getInstance(context).getNotificationOnForeground();
            if (!bl2 && aj.a().b()) {
                UTrack.getInstance().trackMsgDismissed(uMessage);
                return;
            }
            int n3 = MessageSharedPrefs.getInstance(context).getDisplayNotificationNumber();
            if (n3 == 1 && !bl) {
                UTrack.getInstance().trackMsgDismissed(uMessage);
                return;
            }
            MessageNotificationQueue messageNotificationQueue = MessageNotificationQueue.getInstance();
            if (n3 > 0) {
                while (messageNotificationQueue.size() >= n3) {
                    UNotificationItem uNotificationItem = messageNotificationQueue.pollFirst();
                    if (notificationManager != null) {
                        notificationManager.cancel(uNotificationItem.id);
                    }
                    UTrack.getInstance().trackMsgDismissed(uNotificationItem.message);
                }
            }
            messageNotificationQueue.addLast(new UNotificationItem(n2, uMessage));
            if (notificationManager != null) {
                notificationManager.notify(n2, notification);
                UTrack.getInstance().trackMsgShow(uMessage, notification);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void a(Context context) {
        try {
            PowerManager powerManager = (PowerManager)context.getSystemService("power");
            boolean bl = powerManager.isScreenOn();
            UPLog.i(a, "screen on:" + bl);
            if (!bl) {
                PowerManager.WakeLock wakeLock = powerManager.newWakeLock(0x30000006, "MyLock");
                wakeLock.acquire(10000L);
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public void dealWithCustomMessage(Context context, UMessage uMessage) {
    }

    public PendingIntent getClickPendingIntent(Context context, UMessage uMessage) {
        Intent intent = new Intent();
        intent.setClass(context, UmengNotificationReceiver.class);
        intent.putExtra("MSG", uMessage.getRaw().toString());
        intent.putExtra("ACTION", 10);
        intent.putExtra("MESSAGE_ID", uMessage.message_id);
        intent.putExtra("NOTIFICATION_ID", this.d);
        intent.putExtra("TASK_ID", uMessage.task_id);
        int n2 = 0x10000000;
        if (Build.VERSION.SDK_INT >= 23) {
            n2 |= 0x4000000;
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)((int)System.currentTimeMillis()), (Intent)intent, (int)n2);
        return pendingIntent;
    }

    public PendingIntent getDismissPendingIntent(Context context, UMessage uMessage) {
        Intent intent = new Intent();
        intent.setClass(context, UmengNotificationReceiver.class);
        intent.putExtra("MSG", uMessage.getRaw().toString());
        intent.putExtra("ACTION", 11);
        intent.putExtra("MESSAGE_ID", uMessage.message_id);
        intent.putExtra("NOTIFICATION_ID", this.d);
        intent.putExtra("TASK_ID", uMessage.task_id);
        int n2 = 0x10000000;
        if (Build.VERSION.SDK_INT >= 23) {
            n2 |= 0x4000000;
        }
        PendingIntent pendingIntent = PendingIntent.getBroadcast((Context)context, (int)((int)(System.currentTimeMillis() + 1L)), (Intent)intent, (int)n2);
        return pendingIntent;
    }

    public boolean isInNoDisturbTime(Context context) {
        boolean bl;
        int n2;
        Calendar calendar = Calendar.getInstance();
        int n3 = calendar.get(11);
        boolean bl2 = n3 * 60 + (n2 = calendar.get(12)) >= PushAgent.getInstance(context).getNoDisturbStartHour() * 60 + PushAgent.getInstance(context).getNoDisturbStartMinute();
        boolean bl3 = n3 * 60 + n2 <= PushAgent.getInstance(context).getNoDisturbEndHour() * 60 + PushAgent.getInstance(context).getNoDisturbEndMinute();
        boolean bl4 = bl = PushAgent.getInstance(context).getNoDisturbEndHour() * 60 + PushAgent.getInstance(context).getNoDisturbEndMinute() >= PushAgent.getInstance(context).getNoDisturbStartHour() * 60 + PushAgent.getInstance(context).getNoDisturbStartMinute();
        boolean bl5 = bl ? bl2 && bl3 : bl2 || bl3;
        return bl5;
    }

    public int getNotificationDefaults(Context context, UMessage uMessage) {
        int n2 = 0;
        Calendar calendar = Calendar.getInstance();
        boolean bl = this.isInNoDisturbTime(context);
        MessageSharedPrefs messageSharedPrefs = MessageSharedPrefs.getInstance(context);
        int n3 = messageSharedPrefs.getMuteDuration();
        long l2 = (long)n3 * 1000L;
        if (bl) {
            n2 = 0;
        } else if (b != null && calendar.getTimeInMillis() - b.getTime() < l2) {
            n2 = 0;
        } else {
            int n4 = messageSharedPrefs.getNotificationPlayVibrate();
            UPLog.i(a, "playVibrate:" + n4);
            if (n4 == 1) {
                n2 |= 2;
            } else if (n4 != 2 && uMessage.play_vibrate) {
                n2 |= 2;
            }
            int n5 = messageSharedPrefs.getNotificationPlayLights();
            UPLog.i(a, "playLights:" + n5);
            if (n5 == 1) {
                n2 |= 4;
            } else if (n5 != 2 && uMessage.play_lights) {
                n2 |= 4;
            }
            int n6 = messageSharedPrefs.getNotificationPlaySound();
            UPLog.i(a, "playSound:" + n6);
            if (n6 == 1) {
                n2 |= 1;
            } else if (n6 != 2 && uMessage.play_sound) {
                n2 |= 1;
            }
            b = calendar.getTime();
            if (uMessage.screen_on) {
                this.a(context);
            }
        }
        return n2;
    }

    public boolean startDownloadResourceService(Context context, UMessage uMessage) {
        try {
            Intent intent = new Intent(context, UmengDownloadResourceService.class);
            intent.putExtra("body", uMessage.getRaw().toString());
            intent.putExtra("id", uMessage.message_id);
            intent.putExtra("task_id", uMessage.task_id);
            UMJobIntentService.enqueueWork(context, UmengDownloadResourceService.class, intent);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    private boolean a(Context context, Notification.Builder builder, UMessage uMessage) {
        int n2 = this.getSmallIconId(context, uMessage);
        Bitmap bitmap = this.getLargeIcon(context, uMessage);
        if (n2 < 0) {
            return false;
        }
        builder.setSmallIcon(n2);
        builder.setLargeIcon(bitmap);
        return true;
    }

    public int getSmallIconId(Context context, UMessage uMessage) {
        int n2 = -1;
        try {
            if (!TextUtils.isEmpty((CharSequence)uMessage.icon)) {
                n2 = x.c(uMessage.icon);
            }
            if (n2 < 0) {
                n2 = x.c(f);
            }
            if (n2 < 0) {
                UPLog.i(a, "no custom notification small icon! change to use app icon");
                n2 = context.getApplicationInfo().icon;
            }
            if (n2 < 0) {
                UPLog.e(a, "can't find notification small icon");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    public Bitmap getLargeIcon(Context context, UMessage uMessage) {
        Bitmap bitmap = null;
        try {
            if (uMessage.isLargeIconFromInternet()) {
                String string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage);
                String string2 = string + uMessage.img.hashCode();
                bitmap = BitmapFactory.decodeFile((String)string2);
            }
            if (bitmap == null) {
                int n2 = -1;
                if (!TextUtils.isEmpty((CharSequence)uMessage.largeIcon)) {
                    n2 = x.c(uMessage.largeIcon);
                }
                if (n2 < 0) {
                    n2 = x.c(e);
                }
                if (n2 > 0) {
                    bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
                }
            }
            return bitmap;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Bitmap getBarImage(Context context, UMessage uMessage) {
        try {
            String string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage);
            String string2 = string + uMessage.bar_image.hashCode();
            return BitmapFactory.decodeFile((String)string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Bitmap getExpandImage(Context context, UMessage uMessage) {
        try {
            String string = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage);
            String string2 = string + uMessage.expand_image.hashCode();
            return BitmapFactory.decodeFile((String)string2);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Uri getSound(Context context, UMessage uMessage) {
        String string = null;
        try {
            String string2;
            if (uMessage.isSoundFromInternet() && !new File(string = (string2 = UmengDownloadResourceService.getMessageResourceFolder(context, uMessage)) + uMessage.sound.hashCode()).exists()) {
                string = null;
            }
            if (string == null) {
                int n2 = -1;
                if (!TextUtils.isEmpty((CharSequence)uMessage.sound)) {
                    n2 = x.d(uMessage.sound);
                }
                if (n2 < 0) {
                    n2 = x.d(g);
                }
                if (n2 > 0) {
                    string = "android.resource://" + context.getPackageName() + "/" + n2;
                }
            }
            if (string != null) {
                return Uri.parse(string);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public Notification getNotification(Context context, UMessage uMessage) {
        return null;
    }

    private void a(Context context, UMessage uMessage) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (notificationManager == null) {
                return;
            }
            LinkedList<UNotificationItem> linkedList = MessageNotificationQueue.getInstance().getQueue();
            for (UNotificationItem uNotificationItem : linkedList) {
                if (!uMessage.recall.equals(uNotificationItem.message.msg_id)) continue;
                notificationManager.cancel(uNotificationItem.id);
                MessageNotificationQueue.getInstance().remove(uNotificationItem);
                an.a().a(uMessage);
                return;
            }
            an.a().b(uMessage);
        }
        catch (Throwable throwable) {
            UPLog.e(a, "notification recall exception:" + throwable.getMessage());
        }
    }

    static {
        isChannelSet = false;
    }
}

