/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.umeng.message.api.UPushMessageHandler;
import com.umeng.message.common.UPLog;
import com.umeng.message.entity.UMessage;
import java.util.Map;

public class UmengNotificationClickHandler
implements UPushMessageHandler {
    private static final String a = "UmengNotificationClickHandler";

    public void dismissNotification(Context context, UMessage uMessage) {
    }

    public void dealWithCustomAction(Context context, UMessage uMessage) {
    }

    @Override
    public void handleMessage(Context context, UMessage uMessage) {
        try {
            if (uMessage.dismiss) {
                this.dismissNotification(context, uMessage);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)uMessage.after_open)) {
                if (TextUtils.equals((CharSequence)"go_url", (CharSequence)uMessage.after_open)) {
                    this.openUrl(context, uMessage);
                    return;
                }
                if (TextUtils.equals((CharSequence)"go_activity", (CharSequence)uMessage.after_open)) {
                    this.openActivity(context, uMessage);
                    return;
                }
                if (TextUtils.equals((CharSequence)"go_custom", (CharSequence)uMessage.after_open)) {
                    this.dealWithCustomAction(context, uMessage);
                    return;
                }
                if (TextUtils.equals((CharSequence)"go_app", (CharSequence)uMessage.after_open)) {
                    this.launchApp(context, uMessage);
                    return;
                }
            }
            if (uMessage.url != null && !TextUtils.isEmpty((CharSequence)uMessage.url.trim())) {
                this.openUrl(context, uMessage);
            } else if (uMessage.activity != null && !TextUtils.isEmpty((CharSequence)uMessage.activity.trim())) {
                this.openActivity(context, uMessage);
            } else if (uMessage.custom != null && !TextUtils.isEmpty((CharSequence)uMessage.custom.trim())) {
                this.dealWithCustomAction(context, uMessage);
            } else {
                this.launchApp(context, uMessage);
            }
        }
        catch (Throwable throwable) {
            UPLog.e(a, "handleMessage error:", throwable.getMessage());
        }
    }

    public void openUrl(Context context, UMessage uMessage) {
        try {
            if (uMessage.url == null || TextUtils.isEmpty((CharSequence)uMessage.url.trim())) {
                return;
            }
            UPLog.i(a, "open url:" + uMessage.url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uMessage.url));
            this.a(intent, uMessage);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            UPLog.e(a, "openUrl error:", throwable.getMessage());
        }
    }

    public void openActivity(Context context, UMessage uMessage) {
        try {
            if (uMessage.activity == null || TextUtils.isEmpty((CharSequence)uMessage.activity.trim())) {
                return;
            }
            Intent intent = new Intent();
            this.a(intent, uMessage);
            intent.setClassName(context, uMessage.activity);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
        }
        catch (Throwable throwable) {
            UPLog.e(a, "openActivity error:", throwable.getMessage());
        }
    }

    public void launchApp(Context context, UMessage uMessage) {
        try {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (intent == null) {
                UPLog.e(a, "can't find app launch:" + context.getPackageName());
                return;
            }
            intent.setPackage(null);
            intent.addFlags(0x10000000);
            this.a(intent, uMessage);
            context.startActivity(intent);
            UPLog.d(a, "start app: " + context.getPackageName());
        }
        catch (Throwable throwable) {
            UPLog.e(a, "start app error:", throwable.getMessage());
        }
    }

    private void a(Intent intent, UMessage uMessage) {
        if (intent == null || uMessage == null || uMessage.extra == null) {
            return;
        }
        for (Map.Entry<String, String> entry : uMessage.extra.entrySet()) {
            String string = entry.getKey();
            String string2 = entry.getValue();
            if (string == null) continue;
            intent.putExtra(string, string2);
        }
    }
}

