/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.text.TextUtils;
import com.umeng.message.MessageNotificationQueue;
import com.umeng.message.PushAgent;
import com.umeng.message.UTrack;
import com.umeng.message.api.UPushMessageHandler;
import com.umeng.message.common.UPLog;
import com.umeng.message.entity.UMessage;
import com.umeng.message.entity.UNotificationItem;
import com.umeng.message.proguard.y;
import java.util.Locale;
import org.json.JSONObject;

public final class UmengNotificationReceiver
extends BroadcastReceiver {
    private static final String a = "NotificationProxy";
    public static final String EXTRA_KEY_ACTION = "ACTION";
    public static final String EXTRA_KEY_MSG = "MSG";
    public static final String EXTRA_KEY_MESSAGE_ID = "MESSAGE_ID";
    public static final String EXTRA_KEY_NOTIFICATION_ID = "NOTIFICATION_ID";
    public static final String EXTRA_KEY_TASK_ID = "TASK_ID";
    public static final int EXTRA_ACTION_CLICK = 10;
    public static final int EXTRA_ACTION_DISMISS = 11;
    public static final int EXTRA_ACTION_NOT_EXIST = -1;
    public static final int LOCAL_ACTION_CLICK = 12;

    public void onReceive(final Context context, final Intent intent) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    if (intent == null) {
                        return;
                    }
                    String string = intent.getStringExtra(UmengNotificationReceiver.EXTRA_KEY_MSG);
                    int n2 = intent.getIntExtra(UmengNotificationReceiver.EXTRA_KEY_ACTION, -1);
                    UPLog.i(UmengNotificationReceiver.a, String.format(Locale.getDefault(), "onReceive[msg=%s, action=%d]", string, n2));
                    if (n2 == 12) {
                        UmengNotificationReceiver.this.a(context);
                        return;
                    }
                    UMessage uMessage = new UMessage(new JSONObject(string));
                    int n3 = intent.getIntExtra(UmengNotificationReceiver.EXTRA_KEY_NOTIFICATION_ID, -1);
                    uMessage.message_id = intent.getStringExtra(UmengNotificationReceiver.EXTRA_KEY_MESSAGE_ID);
                    uMessage.task_id = intent.getStringExtra(UmengNotificationReceiver.EXTRA_KEY_TASK_ID);
                    switch (n2) {
                        case 11: {
                            UPLog.i(UmengNotificationReceiver.a, "notification ignored");
                            if (!TextUtils.isEmpty((CharSequence)uMessage.msg_id)) {
                                UTrack.getInstance().trackMsgDismissed(uMessage);
                            }
                            uMessage.dismiss = true;
                            UPushMessageHandler uPushMessageHandler = PushAgent.getInstance(context).getNotificationClickHandler();
                            if (uPushMessageHandler == null) break;
                            uPushMessageHandler.handleMessage(context, uMessage);
                            break;
                        }
                        case 10: {
                            UPLog.i(UmengNotificationReceiver.a, "notification clicked");
                            if (!TextUtils.isEmpty((CharSequence)uMessage.msg_id)) {
                                UTrack.getInstance().trackMsgClick(uMessage);
                            }
                            uMessage.clicked = true;
                            UPushMessageHandler uPushMessageHandler = PushAgent.getInstance(context).getNotificationClickHandler();
                            if (uPushMessageHandler == null) break;
                            uPushMessageHandler.handleMessage(context, uMessage);
                            break;
                        }
                    }
                    MessageNotificationQueue.getInstance().remove(new UNotificationItem(n3, uMessage));
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        };
        y.b(runnable);
    }

    private void a(Context context) {
        try {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (intent == null) {
                UPLog.e(a, "not find app: ", context.getPackageName());
                return;
            }
            intent.setPackage(null);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            UPLog.i(a, "open app success: ", context.getPackageName());
        }
        catch (Exception exception) {
            UPLog.i(a, "open app failed: ", context.getPackageName());
        }
    }
}

