/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common;

import android.app.AppOpsManager;
import android.app.NotificationChannel;
import android.app.NotificationManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Configuration;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.umeng.commonsdk.statistics.common.DeviceConfig;
import com.umeng.commonsdk.utils.UMUtils;
import com.umeng.message.PushAgent;
import com.umeng.message.common.UPLog;
import com.umeng.message.proguard.ad;
import com.umeng.message.proguard.ah;
import com.ut.device.UTDevice;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Locale;

public class UmengMessageDeviceConfig {
    private static final String a = "DeviceConfig";
    public static final int DEFAULT_TIMEZONE = 8;
    private static String b;
    private static Boolean c;
    private static Boolean d;
    private static String e;

    public static String getAppVersionCode(Context context) {
        return UMUtils.getAppVersionCode((Context)context);
    }

    public static String getAppVersionName(Context context) {
        return UMUtils.getAppVersionName((Context)context);
    }

    public static String getCPU() {
        return UMUtils.getCPU();
    }

    public static String getDeviceId(Context context) {
        if (!TextUtils.isEmpty((CharSequence)b)) {
            return b;
        }
        b = UmengMessageDeviceConfig.a(context);
        if (!TextUtils.isEmpty((CharSequence)b)) {
            return b;
        }
        b = UmengMessageDeviceConfig.getAndroidId(context);
        if (!TextUtils.isEmpty((CharSequence)b)) {
            return b;
        }
        b = UmengMessageDeviceConfig.getSerial();
        if (TextUtils.isEmpty((CharSequence)b)) {
            b = "";
        }
        return b;
    }

    private static String a(Context context) {
        return DeviceConfig.getImeiNew((Context)context);
    }

    public static String getImeiMd5(Context context) {
        String string = UmengMessageDeviceConfig.a(context);
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        return ah.a(string);
    }

    public static String getImeiAes(Context context) {
        String string = "";
        try {
            string = UmengMessageDeviceConfig.a(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return "";
            }
            String string2 = PushAgent.getInstance(context).getMessageAppkey();
            string = string2 != null && 24 == string2.length() ? ad.a(string, string2.substring(0, 16)) : ad.a(string, "");
        }
        catch (Exception exception) {
            UPLog.i(a, "getDINAes:" + exception.getMessage());
        }
        return string;
    }

    public static String getDeviceIDAes(Context context) {
        String string = "";
        try {
            string = UmengMessageDeviceConfig.getDeviceId(context);
            if (TextUtils.isEmpty((CharSequence)string)) {
                return "";
            }
            String string2 = PushAgent.getInstance(context).getMessageAppkey();
            string = string2 != null && 24 == string2.length() ? ad.a(string, string2.substring(0, 16)) : ad.a(string, "");
        }
        catch (Exception exception) {
            UPLog.i(a, "getDeviceIDAes:" + exception.getMessage());
        }
        return string;
    }

    public static String getAndroidId(Context context) {
        return DeviceConfig.getAndroidId((Context)context);
    }

    public static String getSerial() {
        return DeviceConfig.getSerial();
    }

    public static String getDeviceIdMD5(Context context) {
        return ah.a(UmengMessageDeviceConfig.getDeviceId(context));
    }

    public static String[] getNetworkAccessMode(Context context) {
        return UMUtils.getNetworkAccessMode((Context)context);
    }

    public static boolean isOnline(Context context) {
        try {
            ConnectivityManager connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
            NetworkInfo networkInfo = connectivityManager.getActiveNetworkInfo();
            if (networkInfo != null) {
                return networkInfo.isConnectedOrConnecting();
            }
            return false;
        }
        catch (Throwable throwable) {
            return true;
        }
    }

    public static int getTimeZone(Context context) {
        try {
            Locale locale = UmengMessageDeviceConfig.b(context);
            Calendar calendar = Calendar.getInstance(locale);
            return calendar.getTimeZone().getRawOffset() / 3600000;
        }
        catch (Exception exception) {
            UPLog.i(a, "error in getTimeZone", exception.getMessage());
            return 8;
        }
    }

    public static String[] getLocaleInfo(Context context) {
        String[] stringArray = new String[2];
        try {
            Locale locale = UmengMessageDeviceConfig.b(context);
            stringArray[0] = locale.getCountry();
            stringArray[1] = locale.getLanguage();
            if (TextUtils.isEmpty((CharSequence)stringArray[0])) {
                stringArray[0] = "Unknown";
            }
            if (TextUtils.isEmpty((CharSequence)stringArray[1])) {
                stringArray[1] = "Unknown";
            }
            return stringArray;
        }
        catch (Exception exception) {
            UPLog.i(a, "error in getLocaleInfo", exception.getMessage());
            return stringArray;
        }
    }

    private static Locale b(Context context) {
        Locale locale = null;
        try {
            Configuration configuration = new Configuration();
            Settings.System.getConfiguration((ContentResolver)context.getContentResolver(), (Configuration)configuration);
            locale = configuration.locale;
        }
        catch (Exception exception) {
            UPLog.e(a, "fail to read user config locale");
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        return locale;
    }

    public static String getMetaData(Context context, String string) {
        try {
            String string2;
            PackageManager packageManager = context.getPackageManager();
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(context.getPackageName(), 128);
            if (applicationInfo != null && (string2 = applicationInfo.metaData.getString(string)) != null) {
                return string2.trim();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        UPLog.e(a, String.format("Could not read meta-data %s from AndroidManifest.xml.", string));
        return null;
    }

    public static String getDummyId() {
        return "02:00:00:00:00:00";
    }

    public static String getUmid(Context context) {
        String string = UMUtils.getUMId((Context)context);
        if (string == null) {
            string = "";
        }
        return string;
    }

    public static String getResolution(Context context) {
        try {
            DisplayMetrics displayMetrics = new DisplayMetrics();
            WindowManager windowManager = (WindowManager)context.getSystemService("window");
            windowManager.getDefaultDisplay().getMetrics(displayMetrics);
            int n2 = -1;
            int n3 = -1;
            if ((context.getApplicationInfo().flags & 0x2000) == 0) {
                n2 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatWidthPixels");
                n3 = UmengMessageDeviceConfig.a(displayMetrics, "noncompatHeightPixels");
            }
            if (n2 == -1 || n3 == -1) {
                n2 = displayMetrics.widthPixels;
                n3 = displayMetrics.heightPixels;
            }
            return n2 + "*" + n3;
        }
        catch (Exception exception) {
            UPLog.w(a, "read resolution fail", exception.getMessage());
            return "Unknown";
        }
    }

    private static int a(Object object, String string) {
        try {
            Field field = DisplayMetrics.class.getDeclaredField(string);
            field.setAccessible(true);
            return field.getInt(object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return -1;
        }
    }

    public static String getOperator(Context context) {
        try {
            return UMUtils.getOperator((Context)context);
        }
        catch (Throwable throwable) {
            return "Unknown";
        }
    }

    public static String getChannel(Context context) {
        String string = UMUtils.getChannelByXML((Context)context);
        if (!TextUtils.isEmpty((CharSequence)string)) {
            return string;
        }
        return "Unknown";
    }

    public static String getUtdid(Context context) {
        try {
            return UTDevice.getUtdid((Context)context);
        }
        catch (Throwable throwable) {
            UPLog.e(a, "utdid failed:" + throwable.getMessage());
            return "";
        }
    }

    public static boolean isMi8() {
        if (c != null) {
            return c;
        }
        try {
            String string;
            String string2 = string = TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.MANUFACTURER : Build.BRAND;
            if (!"xiaomi".equalsIgnoreCase(string)) {
                c = false;
                return false;
            }
            String string3 = UmengMessageDeviceConfig.a("ro.miui.ui.version.name");
            if (string3 != null && string3.contains("8")) {
                c = true;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        c = false;
        return false;
    }

    private static String a(String string) {
        try {
            Class<?> clazz = Class.forName("android.os.SystemProperties");
            return (String)clazz.getDeclaredMethod("get", String.class).invoke(clazz, string);
        }
        catch (Throwable throwable) {
            return "";
        }
    }

    public static String getUiOs() {
        if (e != null) {
            return e;
        }
        try {
            String string;
            String string2 = string = TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.MANUFACTURER : Build.BRAND;
            if (!"vivo".equalsIgnoreCase(string)) {
                e = "";
                return e;
            }
            e = UmengMessageDeviceConfig.a("ro.vivo.os.build.display.id");
            if (!TextUtils.isEmpty((CharSequence)e)) {
                return e;
            }
            e = UmengMessageDeviceConfig.a("ro.iqoo.os.build.display.id");
            if (!TextUtils.isEmpty((CharSequence)e)) {
                return e;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        e = "";
        return e;
    }

    public static boolean isVivo() {
        if (d != null) {
            return d;
        }
        try {
            String string;
            String string2 = string = TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.MANUFACTURER : Build.BRAND;
            if ("vivo".equalsIgnoreCase(string)) {
                d = true;
                return true;
            }
            String string3 = UmengMessageDeviceConfig.getUiOs();
            if (TextUtils.isEmpty((CharSequence)string3)) {
                d = false;
                return false;
            }
            if (string3.startsWith("OriginOS") || string3.startsWith("Funtouch")) {
                d = true;
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        d = false;
        return false;
    }

    public static String isNotificationEnabled(Context context, String string) {
        try {
            if (Build.VERSION.SDK_INT < 26) {
                return UmengMessageDeviceConfig.isNotificationEnabled(context);
            }
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            boolean bl = notificationManager.areNotificationsEnabled();
            if (!bl) {
                return String.valueOf(false);
            }
            if (TextUtils.isEmpty((CharSequence)string)) {
                return String.valueOf(true);
            }
            NotificationChannel notificationChannel = notificationManager.getNotificationChannel(string);
            if (notificationChannel != null) {
                return String.valueOf(notificationChannel.getImportance() != 0);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return "unknown";
    }

    public static String isNotificationEnabled(Context context) {
        String string = "unknown";
        if (Build.VERSION.SDK_INT >= 24) {
            try {
                NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
                boolean bl = notificationManager.areNotificationsEnabled();
                string = String.valueOf(bl);
            }
            catch (Throwable throwable) {}
        } else if (Build.VERSION.SDK_INT >= 19) {
            try {
                AppOpsManager appOpsManager = (AppOpsManager)context.getSystemService("appops");
                ApplicationInfo applicationInfo = context.getApplicationInfo();
                String string2 = context.getApplicationContext().getPackageName();
                int n2 = applicationInfo.uid;
                Class<?> clazz = Class.forName(AppOpsManager.class.getName());
                Method method = clazz.getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Field field = clazz.getDeclaredField("OP_POST_NOTIFICATION");
                int n3 = (Integer)field.get(appOpsManager);
                int n4 = (Integer)method.invoke((Object)appOpsManager, n3, n2, string2);
                string = String.valueOf(n4 == 0);
            }
            catch (Exception exception) {
                UPLog.e(a, "\u68c0\u6d4b\u901a\u77e5\u5f00\u5173\u662f\u5426\u6253\u5f00\u5f02\u5e38");
            }
        }
        return string;
    }
}

