/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common.impl;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.MsgConstant;
import com.umeng.message.common.UPLog;
import com.umeng.message.common.UmengMessageDeviceConfig;
import com.umeng.message.common.impl.JUTrack;
import com.umeng.message.common.inter.ITagManager;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import org.json.JSONObject;

public class JTagManager
implements ITagManager {
    private static final String a = "JTagManager";
    private final Context b;

    public JTagManager(Context context) {
        this.b = context;
    }

    @Override
    public ITagManager.Result addTags(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2;
        String string = MsgConstant.TAG_ENDPOINT + "/add";
        try {
            jSONObject2 = JUTrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException && UmengMessageDeviceConfig.isOnline(this.b)) {
                UPLog.d(a, "addTags:", exception);
                jSONObject2 = JUTrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok")) {
            MessageSharedPrefs.getInstance(this.b).addTags(stringArray);
            MessageSharedPrefs.getInstance(this.b).setTagRemain(result.remain);
            MessageSharedPrefs.getInstance(this.b).setAddTagsInterval(result.toString());
        }
        return result;
    }

    @Override
    public ITagManager.Result addWeightedTags(JSONObject jSONObject, Hashtable<String, Integer> hashtable) throws Exception {
        JSONObject jSONObject2;
        String string = MsgConstant.WEIGHTED_TAG_ENDPOINT + "/incr";
        try {
            jSONObject2 = JUTrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException && UmengMessageDeviceConfig.isOnline(this.b)) {
                UPLog.d(a, "addWeightedTags:", exception);
                jSONObject2 = JUTrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, true);
        MessageSharedPrefs.getInstance(this.b).setAddWeightedTagsInterval(result.toString());
        return result;
    }

    @Override
    public ITagManager.Result deleteTags(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2;
        String string = MsgConstant.TAG_ENDPOINT + "/delete";
        try {
            jSONObject2 = JUTrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUTrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok")) {
            MessageSharedPrefs.getInstance(this.b).removeTags(stringArray);
            MessageSharedPrefs.getInstance(this.b).setTagRemain(result.remain);
            MessageSharedPrefs.getInstance(this.b).setDeleteTagsInterval(result.toString());
        }
        return result;
    }

    @Override
    public ITagManager.Result deleteWeightedTags(JSONObject jSONObject, String ... stringArray) throws Exception {
        JSONObject jSONObject2;
        String string = MsgConstant.WEIGHTED_TAG_ENDPOINT + "/delete";
        try {
            jSONObject2 = JUTrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUTrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, true);
        MessageSharedPrefs.getInstance(this.b).setDeleteWeightedTagsInterval(result.toString());
        return result;
    }

    @Override
    public List<String> getTags(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        String string = MsgConstant.TAG_ENDPOINT + "/get";
        try {
            jSONObject2 = JUTrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject2 = JUTrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject2, false);
        if (TextUtils.equals((CharSequence)result.status, (CharSequence)"ok") && jSONObject2 != null) {
            String string2 = jSONObject2.optString("tags");
            MessageSharedPrefs.getInstance(this.b).setGetTagsInterval(result.toString());
            return Arrays.asList(string2.split(","));
        }
        return null;
    }

    @Override
    public Hashtable<String, Integer> getWeightedTags(JSONObject jSONObject) throws Exception {
        JSONObject jSONObject2;
        JSONObject jSONObject3;
        JSONObject jSONObject4;
        String string = MsgConstant.WEIGHTED_TAG_ENDPOINT + "/list";
        try {
            jSONObject4 = JUTrack.sendRequest(jSONObject, string);
        }
        catch (Exception exception) {
            if (exception instanceof UnknownHostException && UmengMessageDeviceConfig.isOnline(this.b)) {
                jSONObject4 = JUTrack.sendRequest(this.b, jSONObject, string);
            }
            throw new Exception(exception);
        }
        ITagManager.Result result = new ITagManager.Result(jSONObject4, true);
        MessageSharedPrefs.getInstance(this.b).setListWeightedTagsInterval(result.toString());
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        if (jSONObject4 != null && (jSONObject3 = jSONObject4.optJSONObject("data")) != null && (jSONObject2 = jSONObject3.optJSONObject("tags")) != null) {
            Iterator iterator = jSONObject2.keys();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                int n2 = jSONObject2.getInt(string2);
                hashtable.put(string2, n2);
            }
        }
        return hashtable;
    }
}

