/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.common.inter;

import com.umeng.message.common.UPLog;
import java.util.Hashtable;
import java.util.List;
import org.json.JSONObject;

public interface ITagManager {
    public static final String SUCCESS = "ok";
    public static final String FAIL = "fail";
    public static final String STATUS_TRUE = "true";
    public static final String STATUS_FALSE = "false";

    public Result addTags(JSONObject var1, String ... var2) throws Exception;

    public Result addWeightedTags(JSONObject var1, Hashtable<String, Integer> var2) throws Exception;

    public Result deleteTags(JSONObject var1, String ... var2) throws Exception;

    public Result deleteWeightedTags(JSONObject var1, String ... var2) throws Exception;

    public List<String> getTags(JSONObject var1) throws Exception;

    public Hashtable<String, Integer> getWeightedTags(JSONObject var1) throws Exception;

    public static class Result {
        public String status = "fail";
        private int a = 0;
        public String msg = "";
        public int remain = 0;
        public long interval = 0L;
        public String errors = "";
        public long last_requestTime = 0L;
        public String jsonString = "";

        public void setStatus(String string) {
            this.status = string;
        }

        public void setRemain(int n2) {
            this.remain = n2;
        }

        public void setInterval(long l2) {
            this.interval = l2;
        }

        public void setErrors(String string) {
            this.errors = string;
        }

        public void setLast_requestTime(long l2) {
            this.last_requestTime = l2;
        }

        public Result() {
        }

        public Result(JSONObject jSONObject, boolean bl) {
            try {
                if (!bl) {
                    this.status = jSONObject.optString("success", ITagManager.FAIL);
                    this.remain = jSONObject.optInt("remain", 0);
                    this.interval = jSONObject.optLong("interval", 0L);
                    this.errors = jSONObject.optString("errors");
                    if (!jSONObject.has("last_requestTime")) {
                        jSONObject.put("last_requestTime", System.currentTimeMillis());
                    } else {
                        this.last_requestTime = jSONObject.optLong("last_requestTime", 0L);
                    }
                } else {
                    this.a = jSONObject.optInt("code");
                    this.msg = jSONObject.optString("msg", "");
                    this.status = jSONObject.optString("status", ITagManager.STATUS_FALSE);
                    this.interval = jSONObject.optLong("interval", 0L);
                    this.last_requestTime = jSONObject.optLong("timestamp", System.currentTimeMillis());
                    JSONObject jSONObject2 = jSONObject.optJSONObject("data");
                    if (null != jSONObject2) {
                        this.remain = jSONObject2.optInt("remain", 0);
                    }
                }
                this.jsonString = jSONObject.toString();
            }
            catch (Exception exception) {
                UPLog.e("ITagManager.Result", "Json error.");
            }
        }

        public String toString() {
            return this.jsonString;
        }
    }
}

