/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message.tag;

import android.content.Context;
import android.text.TextUtils;
import com.umeng.commonsdk.debug.UMLog;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.PushAgent;
import com.umeng.message.api.UPushTagCallback;
import com.umeng.message.common.UPLog;
import com.umeng.message.common.UmengMessageDeviceConfig;
import com.umeng.message.common.impl.JTagManager;
import com.umeng.message.common.inter.ITagManager;
import com.umeng.message.proguard.aa;
import com.umeng.message.proguard.am;
import com.umeng.message.proguard.bd;
import com.umeng.message.proguard.y;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.json.JSONException;
import org.json.JSONObject;

public class TagManager {
    private static final String a = "TagManager";
    private static final String b = "ok";
    private static final String c = "fail";
    private final ITagManager d;
    private static volatile TagManager e;

    private TagManager(Context context) {
        this.d = new JTagManager(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TagManager getInstance(Context context) {
        if (e != null) return e;
        Class<TagManager> clazz = TagManager.class;
        synchronized (TagManager.class) {
            if (e != null) return e;
            e = new TagManager(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return e;
        }
    }

    public void addTags(final UPushTagCallback<ITagManager.Result> uPushTagCallback, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                boolean bl = false;
                try {
                    if (stringArray == null || stringArray.length == 0) {
                        String string = "No tags";
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    if (!TagManager.this.b()) {
                        String string = "No utdid or device_token";
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    if (TagManager.this.c()) {
                        String string = "Tag api is disabled by the server";
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    Context context = am.b();
                    String string = TagManager.this.a(MessageSharedPrefs.getInstance(context).getAddTagsInterval(), stringArray);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        UMLog.mutlInfo((String)TagManager.a, (int)0, (String[])new String[]{string});
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    for (String string2 : stringArray) {
                        boolean bl2 = MessageSharedPrefs.getInstance(context).isTagSet(string2);
                        if (bl2 || arrayList.contains(string2)) continue;
                        byte[] byArray = null;
                        try {
                            byArray = string2.getBytes("UTF-8");
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            unsupportedEncodingException.printStackTrace();
                        }
                        if (byArray == null || byArray.length > 128 || byArray.length <= 0) continue;
                        arrayList.add(string2);
                    }
                    if (arrayList.size() == 0) {
                        result = TagManager.this.d();
                        bl = true;
                        return;
                    }
                    try {
                        JSONObject jSONObject = TagManager.this.a();
                        jSONObject.put("tags", (Object)bd.a(arrayList));
                        result = TagManager.this.d.addTags(jSONObject, stringArray);
                        bl = true;
                        return;
                    }
                    catch (Exception exception) {
                        UPLog.e(TagManager.a, "add tag error!");
                        return;
                    }
                }
                catch (Throwable throwable) {
                    UPLog.e(TagManager.a, "addTags error:", throwable);
                    return;
                }
                finally {
                    try {
                        uPushTagCallback.onMessage(bl, result);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        y.a(runnable);
    }

    public void addWeightedTags(final UPushTagCallback<ITagManager.Result> uPushTagCallback, final Hashtable<String, Integer> hashtable) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                boolean bl = false;
                try {
                    if (!TagManager.this.b()) {
                        String string = "No utdid or device token";
                        result.setErrors(string);
                        UPLog.e(TagManager.a, string);
                        bl = false;
                        return;
                    }
                    if (hashtable == null || hashtable.size() == 0) {
                        String string = "No weighted tags";
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    if (hashtable.size() > 64) {
                        String string = "The maximum number of adding weighted tags per request is 64";
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    Context context = am.b();
                    String string = TagManager.this.a(MessageSharedPrefs.getInstance(context).getAddWeightedTagsInterval(), hashtable);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    try {
                        JSONObject jSONObject = new JSONObject();
                        JSONObject jSONObject2 = hashtable.keySet().iterator();
                        while (true) {
                            if (!jSONObject2.hasNext()) {
                                jSONObject2 = TagManager.this.a();
                                jSONObject2.put("tags", (Object)jSONObject);
                                result = TagManager.this.d.addWeightedTags(jSONObject2, hashtable);
                                bl = true;
                                return;
                            }
                            String string2 = (String)jSONObject2.next();
                            Integer n2 = (Integer)hashtable.get(string2);
                            if (n2 == null) continue;
                            jSONObject.put(string2, n2.intValue());
                        }
                    }
                    catch (Exception exception) {
                        UPLog.e(TagManager.a, "addWeightedTags error:", exception);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    UPLog.e(TagManager.a, "addWeightedTags error:", throwable);
                    return;
                }
                finally {
                    try {
                        uPushTagCallback.onMessage(bl, result);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        y.a(runnable);
    }

    public void deleteTags(final UPushTagCallback<ITagManager.Result> uPushTagCallback, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                boolean bl = false;
                try {
                    Context context = am.b();
                    String string = TagManager.this.a(MessageSharedPrefs.getInstance(context).getDeleteTagsInterval(), stringArray);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    if (TagManager.this.c()) {
                        result.setErrors("tag server disable.");
                        bl = false;
                        return;
                    }
                    if (!TagManager.this.b()) {
                        result.setErrors("check request failed.");
                        bl = false;
                        return;
                    }
                    if (stringArray == null || stringArray.length == 0) {
                        UPLog.e(TagManager.a, "No tags.");
                        result.setErrors("No tags.");
                        bl = true;
                        return;
                    }
                    try {
                        JSONObject jSONObject = TagManager.this.a();
                        jSONObject.put("tags", (Object)bd.a(stringArray));
                        result = TagManager.this.d.deleteTags(jSONObject, stringArray);
                        bl = true;
                        return;
                    }
                    catch (Exception exception) {
                        UPLog.e(TagManager.a, "deleteTags error:", exception);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    UPLog.e(TagManager.a, "deleteTags error:", throwable);
                    return;
                }
                finally {
                    try {
                        uPushTagCallback.onMessage(bl, result);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        y.a(runnable);
    }

    public void deleteWeightedTags(final UPushTagCallback<ITagManager.Result> uPushTagCallback, final String ... stringArray) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                ITagManager.Result result = new ITagManager.Result();
                boolean bl = false;
                try {
                    if (!TagManager.this.b()) {
                        String string = "check request failed.";
                        result.setErrors(string);
                        UPLog.e(TagManager.a, string);
                        bl = false;
                        return;
                    }
                    if (stringArray == null || stringArray.length == 0) {
                        String string = "No tags.";
                        result.setErrors(string);
                        UPLog.e(TagManager.a, string);
                        bl = false;
                        return;
                    }
                    if (stringArray.length > 64) {
                        String string = "tags count must be <= 64";
                        result.setErrors(string);
                        UPLog.e(TagManager.a, string);
                        bl = false;
                        return;
                    }
                    Context context = am.b();
                    String string = TagManager.this.b(MessageSharedPrefs.getInstance(context).getDeleteWeightedTagsInterval(), stringArray);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        UPLog.e(TagManager.a, string);
                        result.setErrors(string);
                        bl = false;
                        return;
                    }
                    try {
                        JSONObject jSONObject = TagManager.this.a();
                        jSONObject.put("tags", (Object)bd.a(stringArray));
                        result = TagManager.this.d.deleteWeightedTags(jSONObject, stringArray);
                        bl = true;
                        return;
                    }
                    catch (Exception exception) {
                        UPLog.e(TagManager.a, "deleteWeightedTags failed:", exception);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    UPLog.e(TagManager.a, "deleteWeightedTags:", throwable);
                    return;
                }
                finally {
                    try {
                        uPushTagCallback.onMessage(bl, result);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        y.a(runnable);
    }

    public void getTags(final UPushTagCallback<List<String>> uPushTagCallback) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                boolean bl = false;
                ArrayList<String> arrayList = new ArrayList<String>();
                try {
                    Context context = am.b();
                    String string = TagManager.this.a(MessageSharedPrefs.getInstance(context).getGetTagsInterval(), false);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        return;
                    }
                    if (TagManager.this.c()) {
                        return;
                    }
                    if (!TagManager.this.b()) {
                        return;
                    }
                    try {
                        JSONObject jSONObject = TagManager.this.a();
                        List<String> list = TagManager.this.d.getTags(jSONObject);
                        if (list != null) {
                            arrayList.addAll(list);
                        }
                        bl = true;
                        return;
                    }
                    catch (Exception exception) {
                        UPLog.e(TagManager.a, "getTags error:", exception);
                        return;
                    }
                }
                catch (Throwable throwable) {
                    UPLog.e(TagManager.a, "getTags:", throwable);
                    return;
                }
                finally {
                    try {
                        uPushTagCallback.onMessage(bl, arrayList);
                    }
                    catch (Throwable throwable) {}
                }
            }
        };
        y.a(runnable);
    }

    public void getWeightedTags(final UPushTagCallback<Hashtable<String, Integer>> uPushTagCallback) {
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block13: {
                    boolean bl = false;
                    Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
                    if (!TagManager.this.b()) {
                        return;
                    }
                    Context context = am.b();
                    String string = TagManager.this.a(MessageSharedPrefs.getInstance(context).getListWeightedTagsInterval(), true);
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        return;
                    }
                    JSONObject jSONObject = TagManager.this.a();
                    Hashtable<String, Integer> hashtable2 = TagManager.this.d.getWeightedTags(jSONObject);
                    if (hashtable2 != null) {
                        hashtable.putAll(hashtable2);
                    }
                    bl = true;
                    try {
                        uPushTagCallback.onMessage(bl, hashtable);
                    }
                    catch (Throwable throwable) {
                        UPLog.e(TagManager.a, "getWeightedTags:", throwable);
                    }
                    break block13;
                    catch (Exception exception) {
                        try {
                            UPLog.e(TagManager.a, "getWeightedTags failed:", exception);
                        }
                        catch (Throwable throwable) {
                            try {
                                uPushTagCallback.onMessage(bl, hashtable);
                            }
                            catch (Throwable throwable2) {
                                UPLog.e(TagManager.a, "getWeightedTags:", throwable2);
                            }
                            throw throwable;
                        }
                        try {
                            uPushTagCallback.onMessage(bl, hashtable);
                        }
                        catch (Throwable throwable) {
                            UPLog.e(TagManager.a, "getWeightedTags:", throwable);
                        }
                    }
                }
            }
        };
        y.a(runnable);
    }

    private JSONObject a() throws JSONException {
        Context context = am.b();
        JSONObject jSONObject = new JSONObject();
        jSONObject.put("header", (Object)aa.a());
        String string = UmengMessageDeviceConfig.getUtdid(context);
        jSONObject.put("utdid", (Object)string);
        jSONObject.put("device_token", (Object)MessageSharedPrefs.getInstance(context).getDeviceToken());
        jSONObject.put("ts", System.currentTimeMillis());
        return jSONObject;
    }

    private boolean b() {
        if (TextUtils.isEmpty((CharSequence)UmengMessageDeviceConfig.getUtdid(am.b()))) {
            UPLog.e(a, "utdid empty.");
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)PushAgent.getInstance(am.b()).getRegistrationId())) {
            UPLog.e(a, "deviceToken empty.");
            return false;
        }
        return true;
    }

    private boolean c() {
        boolean bl;
        int n2 = MessageSharedPrefs.getInstance(am.b()).getTagSendPolicy();
        boolean bl2 = bl = n2 == 1;
        if (bl) {
            UPLog.d(a, "tag server disable!");
        }
        return bl;
    }

    private ITagManager.Result d() {
        ITagManager.Result result = new ITagManager.Result(new JSONObject(), false);
        result.remain = MessageSharedPrefs.getInstance(am.b()).getTagRemain();
        result.status = b;
        result.jsonString = "status:" + result.status + ", remain:" + result.remain + ",description:" + result.status;
        return result;
    }

    private String a(String string, String ... stringArray) {
        String string2 = "";
        Context context = am.b();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null && stringArray.length > 0) {
            for (String string3 : stringArray) {
                boolean bl = MessageSharedPrefs.getInstance(context).isTagSet(string3);
                if (bl || arrayList.contains(string3)) continue;
                byte[] byArray = null;
                try {
                    byArray = string3.getBytes("UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    unsupportedEncodingException.printStackTrace();
                }
                if (byArray != null && byArray.length <= 128 && byArray.length > 0) {
                    arrayList.add(string3);
                    continue;
                }
                string2 = "tag length must be 1~128 byte";
                return string2;
            }
        }
        if (string == null) {
            return string2;
        }
        try {
            ITagManager.Result exception = new ITagManager.Result(new JSONObject(string), false);
            long l2 = System.currentTimeMillis();
            if (arrayList.size() > 0) {
                if (exception.remain >= 0 && arrayList.size() <= exception.remain) {
                    if (exception.interval != 0L && (l2 - exception.last_requestTime) / 1000L <= exception.interval) {
                        string2 = "interval limit";
                    }
                } else {
                    string2 = "tags count > 1024";
                }
            }
        }
        catch (Exception exception) {
            UPLog.e(a, "checkTags error:", exception);
        }
        return string2;
    }

    private String a(String string, Hashtable<String, Integer> hashtable) {
        String string2 = null;
        for (String string3 : hashtable.keySet()) {
            Object object;
            try {
                object = string3.getBytes("UTF-8");
                if (object == null || ((byte[])object).length > 128 || ((byte[])object).length == 0) {
                    return "pls check tag limit";
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UPLog.e(a, "checkWeightedTags:", unsupportedEncodingException);
                return "pls check tag limit";
            }
            object = hashtable.get(string3);
            if (object != null && (Integer)object >= -10 && (Integer)object <= 10) continue;
            return "pls check tag weight, weight must be >= -10 && <=10";
        }
        if (string == null) {
            return null;
        }
        try {
            ITagManager.Result result = new ITagManager.Result(new JSONObject(string), true);
            long l2 = System.currentTimeMillis();
            string2 = result.interval == 0L || (l2 - result.last_requestTime) / 1000L > result.interval ? null : "interval limit";
        }
        catch (Exception exception) {
            UPLog.e(a, "checkWeightedTags error:", exception);
        }
        return string2;
    }

    private String b(String string, String ... stringArray) {
        String string2 = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string3 : stringArray) {
            try {
                byte[] byArray = string3.getBytes("UTF-8");
                if (byArray == null || byArray.length > 128 || byArray.length <= 0) {
                    string2 = "pls check tag length limit. must be 1 ~ 128";
                    return string2;
                }
                arrayList.add(string3);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                UPLog.e(a, "checkWeightedTags:", unsupportedEncodingException);
                return "pls check tag length limit. must be 1 ~ 128";
            }
        }
        if (string == null) {
            return null;
        }
        try {
            ITagManager.Result exception = new ITagManager.Result(new JSONObject(string), true);
            long l2 = System.currentTimeMillis();
            if (arrayList.size() > 0) {
                string2 = exception.interval == 0L || (l2 - exception.last_requestTime) / 1000L > exception.interval ? null : "interval limit";
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return string2;
    }

    private String a(String string, boolean bl) {
        if (string == null) {
            return null;
        }
        String string2 = null;
        try {
            ITagManager.Result result = new ITagManager.Result(new JSONObject(string), bl);
            long l2 = System.currentTimeMillis();
            string2 = result.interval == 0L || (l2 - result.last_requestTime) / 1000L > result.interval ? null : "interval limit";
        }
        catch (Exception exception) {
            UPLog.e(a, "checkTagsInterval error:", exception);
        }
        return string2;
    }

    @Deprecated
    public static interface WeightedTagListCallBack
    extends UPushTagCallback<Hashtable<String, Integer>> {
    }

    @Deprecated
    public static interface TagListCallBack
    extends UPushTagCallback<List<String>> {
    }

    @Deprecated
    public static interface TCallBack
    extends UPushTagCallback<ITagManager.Result> {
    }
}

