/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.union.widget;

import android.content.Context;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.umeng.message.common.UPLog;
import java.util.concurrent.atomic.AtomicLong;

public class UMNativeLayout
extends FrameLayout {
    private OnStatusListener mListener;
    private Boolean isAttached;

    public UMNativeLayout(Context context) {
        super(context);
    }

    public UMNativeLayout(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    public UMNativeLayout(Context context, AttributeSet attributeSet, int n2) {
        super(context, attributeSet, n2);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.isAttached = true;
        OnStatusListener onStatusListener = this.mListener;
        if (onStatusListener != null) {
            onStatusListener.onAttached();
            onStatusListener.onVisibleChanged(true);
        }
    }

    protected void onDetachedFromWindow() {
        OnStatusListener onStatusListener;
        super.onDetachedFromWindow();
        if (this.isAttached.booleanValue() && (onStatusListener = this.mListener) != null) {
            onStatusListener.onVisibleChanged(false);
            onStatusListener.onDetached();
        }
        this.isAttached = false;
    }

    protected void onVisibilityChanged(View view, int n2) {
        super.onVisibilityChanged(view, n2);
        OnStatusListener onStatusListener = this.mListener;
        if (onStatusListener != null) {
            onStatusListener.onVisibleChanged(n2 == 0);
        }
    }

    protected void onWindowVisibilityChanged(int n2) {
        super.onWindowVisibilityChanged(n2);
        OnStatusListener onStatusListener = this.mListener;
        if (onStatusListener != null) {
            onStatusListener.onVisibleChanged(n2 == 0);
        }
    }

    public void setOnStatusListener(OnStatusListener onStatusListener) {
        this.mListener = onStatusListener;
        if (onStatusListener == null || this.isAttached == null) {
            return;
        }
        if (this.isAttached.booleanValue()) {
            onStatusListener.onAttached();
            onStatusListener.onVisibleChanged(true);
        } else {
            onStatusListener.onVisibleChanged(false);
            onStatusListener.onDetached();
        }
    }

    protected OnStatusListener getOnStatusListener() {
        return this.mListener;
    }

    public static abstract class OnStatusListener {
        private final AtomicLong start = new AtomicLong(-1L);
        private final AtomicLong duration = new AtomicLong(0L);
        private boolean visible = false;

        protected abstract void onAttached();

        protected abstract void onDetached();

        protected final void onVisibleChanged(boolean bl) {
            if (this.visible == bl) {
                return;
            }
            this.visible = bl;
            if (bl) {
                if (this.start.get() == -1L) {
                    this.start.set(SystemClock.elapsedRealtime());
                }
            } else {
                if (this.start.get() != -1L) {
                    this.duration.set(this.duration.get() + SystemClock.elapsedRealtime() - this.start.get());
                }
                this.start.set(-1L);
            }
        }

        public final long getDuration() {
            long l2 = this.duration.get();
            if (this.start.get() != -1L) {
                l2 += SystemClock.elapsedRealtime() - this.start.get();
            }
            UPLog.d("Ads", "display duration:", l2);
            return l2;
        }
    }
}

