/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.app.Notification;
import android.app.NotificationManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.os.Build;
import android.os.PowerManager;
import android.os.SystemClock;
import android.text.TextUtils;
import android.widget.RemoteViews;
import com.umeng.message.MessageSharedPrefs;
import com.umeng.message.PushAgent;
import com.umeng.message.UTrack;
import com.umeng.message.api.UPushMessageHandler;
import com.umeng.message.common.UPLog;
import com.umeng.message.common.UPushNotificationChannel;
import com.umeng.message.component.UmengMessageHandlerService;
import com.umeng.message.component.UmengNotificationClickActivity;
import com.umeng.message.component.UmengNotificationReceiver;
import com.umeng.message.entity.UMessage;
import com.umeng.message.proguard.a;
import com.umeng.message.proguard.aa;
import com.umeng.message.proguard.b;
import com.umeng.message.proguard.l;
import com.umeng.message.proguard.q;
import com.umeng.message.proguard.s;
import com.umeng.message.proguard.w;
import com.umeng.message.push.R;
import java.io.File;
import java.util.Calendar;
import java.util.Date;

public class UmengMessageHandler
implements UPushMessageHandler {
    private static Date a;
    private int b;

    @Override
    public void handleMessage(Context context, UMessage uMessage) {
        if ("notification".equals(uMessage.display_type)) {
            this.dealWithNotificationMessage(context, uMessage);
            return;
        }
        if ("custom".equals(uMessage.display_type)) {
            if (!TextUtils.isEmpty((CharSequence)uMessage.recall)) {
                try {
                    context = (NotificationManager)context.getSystemService("notification");
                    if (context == null) {
                        return;
                    }
                    for (aa aa2 : com.umeng.message.proguard.a.a().a) {
                        if (!uMessage.recall.equals(aa2.b.msg_id)) continue;
                        context.cancel("um", aa2.a);
                        com.umeng.message.proguard.a.a().a(aa2);
                        w.a().a(uMessage.recall, 4);
                        return;
                    }
                    w.a().a(uMessage.recall, 5);
                    return;
                }
                catch (Throwable throwable) {
                    UPLog.e("UmengMessageHandler", "notification recall exception:" + throwable.getMessage());
                    return;
                }
            }
            this.dealWithCustomMessage(context, uMessage);
        }
    }

    public void dealWithNotificationMessage(Context context, UMessage uMessage) {
        boolean bl;
        Object object;
        String string;
        UPLog.i("UmengMessageHandler", "notification: " + uMessage.getRaw().toString());
        MessageSharedPrefs messageSharedPrefs = MessageSharedPrefs.getInstance(context);
        if (uMessage.hasResourceFromInternet() && !messageSharedPrefs.b.b("msg_download_prefix".concat(String.valueOf(string = uMessage.msg_id)), false) && this.startDownloadResourceService(context, uMessage)) {
            return;
        }
        if (22 == uMessage.msg_id.length() && uMessage.msg_id.startsWith("u")) {
            string = uMessage.msg_id;
            messageSharedPrefs.b.a("last_msg_id", string);
            string = uMessage.msg_id.substring(7, 20);
            String string2 = messageSharedPrefs.b.b("last_msg_id", "");
            bl = "".equals(string2) || 22 != string2.length() ? true : string.compareToIgnoreCase((String)(object = string2.substring(7, 20))) >= 0;
        } else {
            bl = true;
        }
        string = uMessage.msg_id;
        messageSharedPrefs.b.a("msg_download_prefix".concat(String.valueOf(string)));
        string = this.getNotification(context, uMessage);
        int n2 = this.getNotificationDefaults(context, uMessage);
        if (string == null) {
            if (Build.VERSION.SDK_INT >= 26) {
                messageSharedPrefs = this.isInNoDisturbTime(context) ? UPushNotificationChannel.getSilenceMode(context) : UPushNotificationChannel.getDefaultMode(context);
                if (messageSharedPrefs == null) {
                    return;
                }
                object = new Notification.Builder(context, messageSharedPrefs.getId());
            } else {
                object = new Notification.Builder(context);
            }
            int n3 = this.getSmallIconId(context, uMessage);
            if (n3 < 0) {
                UPLog.e("UmengMessageHandler", "small icon error!");
                return;
            }
            string = this.getLargeIcon(context, uMessage);
            Bitmap bitmap = this.getExpandImage(context, uMessage);
            String string3 = uMessage.getTitle();
            String string4 = uMessage.getContent();
            String string5 = uMessage.getBigBody();
            object.setSmallIcon(n3);
            object.setTicker((CharSequence)uMessage.getTicker());
            object.setAutoCancel(true);
            if (!TextUtils.isEmpty((CharSequence)uMessage.bar_image)) {
                RemoteViews remoteViews = new RemoteViews(context.getPackageName(), R.layout.upush_notification_banner_layout);
                remoteViews.setImageViewBitmap(R.id.upush_notification_banner, this.getBarImage(context, uMessage));
                object.setContent(remoteViews);
            } else {
                object.setSmallIcon(n3);
                object.setLargeIcon((Bitmap)string);
                object.setContentTitle((CharSequence)string3);
                object.setContentText((CharSequence)string4);
            }
            if (bitmap != null && Build.VERSION.SDK_INT >= 16) {
                Notification.BigPictureStyle bigPictureStyle = new Notification.BigPictureStyle();
                bigPictureStyle.bigPicture(bitmap);
                bigPictureStyle.bigLargeIcon((Bitmap)string);
                object.setStyle((Notification.Style)bigPictureStyle);
            } else if (!TextUtils.isEmpty((CharSequence)string5) && Build.VERSION.SDK_INT >= 16) {
                Notification.BigTextStyle bigTextStyle = new Notification.BigTextStyle();
                string = uMessage.getBigTitle();
                if (string == null || string.length() == 0) {
                    string = string3;
                }
                bigTextStyle.setBigContentTitle((CharSequence)string);
                bigTextStyle.bigText((CharSequence)string5);
                object.setStyle((Notification.Style)bigTextStyle);
            }
            string = object.getNotification();
        }
        this.b = this.b == 0 ? (int)SystemClock.elapsedRealtime() : ++this.b;
        ((Notification)string).deleteIntent = this.getDismissPendingIntent(context, uMessage);
        ((Notification)string).contentIntent = this.getClickPendingIntent(context, uMessage);
        if ((n2 & 1) != 0) {
            object = this.getSound(context, uMessage);
            if (object != null) {
                ((Notification)string).sound = this.getSound(context, uMessage);
            }
            if (object != null) {
                n2 ^= 1;
            }
        }
        ((Notification)string).defaults = n2;
        UmengMessageHandler.a(context, this.b, (Notification)string, bl, uMessage);
    }

    private static void a(Context context, int n2, Notification notification, boolean bl, UMessage uMessage) {
        try {
            NotificationManager notificationManager = (NotificationManager)context.getSystemService("notification");
            if (!PushAgent.getInstance(context).getNotificationOnForeground() && s.a().a) {
                UTrack.getInstance().trackMsgDismissed(uMessage);
                return;
            }
            int n3 = MessageSharedPrefs.getInstance(context).b();
            if (n3 == 1 && !bl) {
                UTrack.getInstance().trackMsgDismissed(uMessage);
                return;
            }
            a a2 = com.umeng.message.proguard.a.a();
            if (n3 > 0) {
                while (a2.a.size() >= n3) {
                    aa aa2 = a2.a.pollFirst();
                    if (notificationManager != null) {
                        notificationManager.cancel("um", aa2.a);
                    }
                    UTrack.getInstance().trackMsgDismissed(aa2.b);
                }
            }
            aa aa3 = new aa(n2, uMessage);
            a2.a.addLast(aa3);
            if (notificationManager != null) {
                notificationManager.notify("um", n2, notification);
                UTrack.getInstance().trackMsgShow(uMessage, notification);
            }
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    public void dealWithCustomMessage(Context context, UMessage uMessage) {
    }

    public PendingIntent getClickPendingIntent(Context context, UMessage uMessage) {
        Intent intent = new Intent();
        intent.setFlags(0x10000000);
        intent.setClass(context, UmengNotificationClickActivity.class);
        intent.putExtra("MSG", uMessage.getRaw().toString());
        intent.putExtra("NOTIFICATION_ID", this.b);
        int n2 = 0x10000000;
        if (Build.VERSION.SDK_INT >= 23) {
            n2 = 0x14000000;
        }
        int n3 = (int)System.currentTimeMillis();
        return PendingIntent.getActivity((Context)context, (int)n3, (Intent)intent, (int)n2);
    }

    public PendingIntent getDismissPendingIntent(Context context, UMessage uMessage) {
        Intent intent = new Intent();
        intent.setClass(context, UmengNotificationReceiver.class);
        intent.putExtra("MSG", uMessage.getRaw().toString());
        intent.putExtra("ACTION", 11);
        intent.putExtra("NOTIFICATION_ID", this.b);
        int n2 = 0x10000000;
        if (Build.VERSION.SDK_INT >= 23) {
            n2 = 0x14000000;
        }
        int n3 = (int)(System.currentTimeMillis() + 1L);
        return PendingIntent.getBroadcast((Context)context, (int)n3, (Intent)intent, (int)n2);
    }

    public boolean isInNoDisturbTime(Context context) {
        int n2;
        Calendar calendar = Calendar.getInstance();
        int n3 = calendar.get(11);
        boolean bl = n3 * 60 + (n2 = calendar.get(12)) >= PushAgent.getInstance(context).getNoDisturbStartHour() * 60 + PushAgent.getInstance(context).getNoDisturbStartMinute();
        n2 = n3 * 60 + n2 <= PushAgent.getInstance(context).getNoDisturbEndHour() * 60 + PushAgent.getInstance(context).getNoDisturbEndMinute() ? 1 : 0;
        if (PushAgent.getInstance(context).getNoDisturbEndHour() * 60 + PushAgent.getInstance(context).getNoDisturbEndMinute() >= PushAgent.getInstance(context).getNoDisturbStartHour() * 60 + PushAgent.getInstance(context).getNoDisturbStartMinute()) {
            return bl && n2 != 0;
        }
        return bl || n2 != 0;
    }

    public int getNotificationDefaults(Context context, UMessage uMessage) {
        Calendar calendar = Calendar.getInstance();
        if (this.isInNoDisturbTime(context)) {
            return 0;
        }
        MessageSharedPrefs messageSharedPrefs = MessageSharedPrefs.getInstance(context);
        long l2 = (long)messageSharedPrefs.e() * 1000L;
        if (a != null && calendar.getTimeInMillis() - a.getTime() < l2) {
            return 0;
        }
        int n2 = 0;
        int n3 = messageSharedPrefs.f();
        UPLog.i("UmengMessageHandler", "playVibrate:".concat(String.valueOf(n3)));
        if (n3 == 1) {
            n2 = 2;
        } else if (n3 != 2 && uMessage.play_vibrate) {
            n2 = 2;
        }
        n3 = messageSharedPrefs.g();
        UPLog.i("UmengMessageHandler", "playLights:".concat(String.valueOf(n3)));
        if (n3 == 1) {
            n2 |= 4;
        } else if (n3 != 2 && uMessage.play_lights) {
            n2 |= 4;
        }
        int n4 = messageSharedPrefs.h();
        UPLog.i("UmengMessageHandler", "playSound:".concat(String.valueOf(n4)));
        if (n4 == 1) {
            n2 |= 1;
        } else if (n4 != 2 && uMessage.play_sound) {
            n2 |= 1;
        }
        a = calendar.getTime();
        if (uMessage.screen_on) {
            try {
                context = (PowerManager)context.getSystemService("power");
                boolean bl = context.isScreenOn();
                UPLog.i("UmengMessageHandler", "screen on:".concat(String.valueOf(bl)));
                if (!bl) {
                    context.newWakeLock(0x30000006, "MyLock").acquire(10000L);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
        return n2;
    }

    public boolean startDownloadResourceService(Context context, UMessage uMessage) {
        try {
            Intent intent = new Intent("com.umeng.message.action");
            intent.setPackage(context.getPackageName());
            intent.setClass(context, UmengMessageHandlerService.class);
            intent.putExtra("um_command", "download");
            intent.putExtra("body", uMessage.getRaw().toString());
            q.enqueueWork(context, UmengMessageHandlerService.class, intent);
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public int getSmallIconId(Context context, UMessage uMessage) {
        int n2 = -1;
        try {
            try {
                if (!TextUtils.isEmpty((CharSequence)uMessage.getSmallIconDrawableName())) {
                    n2 = com.umeng.message.proguard.b.b(uMessage.getSmallIconDrawableName());
                }
                if (n2 < 0) {
                    n2 = com.umeng.message.proguard.b.b("umeng_push_notification_default_small_icon");
                }
            }
            catch (Exception exception) {}
            if (n2 < 0) {
                UPLog.i("UmengMessageHandler", "no custom notification small icon! change to use app icon");
                n2 = context.getApplicationInfo().icon;
            }
            if (n2 < 0) {
                UPLog.e("UmengMessageHandler", "can't find notification small icon");
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return n2;
    }

    public Bitmap getLargeIcon(Context context, UMessage uMessage) {
        Bitmap bitmap = null;
        try {
            if (uMessage.isLargeIconFromInternet()) {
                String string = l.a(context, uMessage);
                bitmap = BitmapFactory.decodeFile((String)(string + uMessage.getLargeIconUrl().hashCode()));
            }
            if (bitmap == null) {
                int n2 = -1;
                try {
                    if (!TextUtils.isEmpty((CharSequence)uMessage.getLargeIconDrawableName())) {
                        n2 = com.umeng.message.proguard.b.b(uMessage.getLargeIconDrawableName());
                    }
                    if (n2 < 0) {
                        n2 = com.umeng.message.proguard.b.b("umeng_push_notification_default_large_icon");
                    }
                }
                catch (Exception exception) {}
                if (n2 > 0) {
                    bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)n2);
                }
            }
            return bitmap;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Bitmap getBarImage(Context object, UMessage uMessage) {
        try {
            object = l.a(object, uMessage);
            return BitmapFactory.decodeFile((String)((String)object + uMessage.bar_image.hashCode()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Bitmap getExpandImage(Context context, UMessage uMessage) {
        if (TextUtils.isEmpty((CharSequence)uMessage.getBigImage())) {
            return null;
        }
        try {
            return BitmapFactory.decodeFile((String)(l.a(context, uMessage) + uMessage.getBigImage().hashCode()));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Uri getSound(Context context, UMessage uMessage) {
        String string = null;
        try {
            String string2;
            if (uMessage.isSoundFromInternet() && !new File(string = (string2 = l.a(context, uMessage)) + uMessage.sound.hashCode()).exists()) {
                string = null;
            }
            if (string == null) {
                int n2 = -1;
                if (!TextUtils.isEmpty((CharSequence)uMessage.sound)) {
                    n2 = com.umeng.message.proguard.b.c(uMessage.sound);
                }
                if (n2 < 0) {
                    n2 = com.umeng.message.proguard.b.c("umeng_push_notification_default_sound");
                }
                if (n2 > 0) {
                    string = "android.resource://" + context.getPackageName() + "/" + n2;
                }
            }
            if (string != null) {
                return Uri.parse(string);
            }
        }
        catch (Throwable throwable) {}
        return null;
    }

    public Notification getNotification(Context context, UMessage uMessage) {
        return null;
    }
}

