/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.message;

import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.text.TextUtils;
import com.umeng.message.api.UPushMessageHandler;
import com.umeng.message.common.UPLog;
import com.umeng.message.entity.UMessage;
import java.util.Map;

public class UmengNotificationClickHandler
implements UPushMessageHandler {
    public void dismissNotification(Context context, UMessage uMessage) {
    }

    public void dealWithCustomAction(Context context, UMessage uMessage) {
    }

    @Override
    public void handleMessage(Context context, UMessage uMessage) {
        try {
            if (uMessage.dismiss) {
                this.dismissNotification(context, uMessage);
                return;
            }
            if (!TextUtils.isEmpty((CharSequence)uMessage.after_open)) {
                if (TextUtils.equals((CharSequence)"go_url", (CharSequence)uMessage.after_open)) {
                    this.openUrl(context, uMessage);
                    return;
                }
                if (TextUtils.equals((CharSequence)"go_activity", (CharSequence)uMessage.after_open)) {
                    this.openActivity(context, uMessage);
                    return;
                }
                if (TextUtils.equals((CharSequence)"go_custom", (CharSequence)uMessage.after_open)) {
                    this.dealWithCustomAction(context, uMessage);
                    return;
                }
                if (TextUtils.equals((CharSequence)"go_app", (CharSequence)uMessage.after_open)) {
                    this.launchApp(context, uMessage);
                    return;
                }
            }
            if (uMessage.url != null && !TextUtils.isEmpty((CharSequence)uMessage.url.trim())) {
                this.openUrl(context, uMessage);
                return;
            }
            if (uMessage.activity != null && !TextUtils.isEmpty((CharSequence)uMessage.activity.trim())) {
                this.openActivity(context, uMessage);
                return;
            }
            if (uMessage.custom != null && !TextUtils.isEmpty((CharSequence)uMessage.custom.trim())) {
                this.dealWithCustomAction(context, uMessage);
                return;
            }
            this.launchApp(context, uMessage);
            return;
        }
        catch (Throwable throwable) {
            UPLog.e("UmengNotificationClickHandler", "handleMessage error:", throwable.getMessage());
            return;
        }
    }

    public void openUrl(Context context, UMessage uMessage) {
        try {
            if (uMessage.url == null || TextUtils.isEmpty((CharSequence)uMessage.url.trim())) {
                return;
            }
            UPLog.d("UmengNotificationClickHandler", "open url:" + uMessage.url);
            Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uMessage.url));
            UmengNotificationClickHandler.a(intent, uMessage);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            UPLog.e("UmengNotificationClickHandler", "open url fail:", throwable.getMessage());
            return;
        }
    }

    public void openActivity(Context context, UMessage uMessage) {
        try {
            if (uMessage.activity == null || TextUtils.isEmpty((CharSequence)uMessage.activity.trim())) {
                return;
            }
            UPLog.d("UmengNotificationClickHandler", "open activity:" + uMessage.activity);
            Intent intent = new Intent();
            UmengNotificationClickHandler.a(intent, uMessage);
            intent.setClassName(context, uMessage.activity);
            intent.addFlags(0x10000000);
            context.startActivity(intent);
            return;
        }
        catch (Throwable throwable) {
            UPLog.e("UmengNotificationClickHandler", "open activity fail:", throwable.getMessage());
            return;
        }
    }

    public void launchApp(Context context, UMessage uMessage) {
        try {
            Intent intent = context.getPackageManager().getLaunchIntentForPackage(context.getPackageName());
            if (intent == null) {
                UPLog.e("UmengNotificationClickHandler", "can't find LaunchIntent:" + context.getPackageName());
                return;
            }
            intent.addFlags(0x10000000);
            UmengNotificationClickHandler.a(intent, uMessage);
            context.startActivity(intent);
            UPLog.d("UmengNotificationClickHandler", "start app: " + context.getPackageName());
            return;
        }
        catch (Throwable throwable) {
            UPLog.e("UmengNotificationClickHandler", "start app fail:", throwable.getMessage());
            return;
        }
    }

    private static void a(Intent intent, UMessage object) {
        if (intent == null || object == null || ((UMessage)((Object)object)).getExtra() == null) {
            return;
        }
        for (Map.Entry<String, String> entry : ((UMessage)((Object)object)).getExtra().entrySet()) {
            String string = entry.getKey();
            String object2 = entry.getValue();
            if (string == null) continue;
            intent.putExtra(string, object2);
        }
    }
}

