/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.QZoneShareContent;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import org.json.JSONObject;

public class QZoneSsoHandler
extends UMTencentSSOHandler {
    private QZoneShareContent mShareContent;
    private QQPreferences qqPreferences;
    private static final String TAG = "QZoneSsoHandler";

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        this.qqPreferences = new QQPreferences(context, SHARE_MEDIA.QQ.toString());
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        if (listener != null) {
            this.mShareListener = listener;
        }
        if (this.mTencent == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    QZoneSsoHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QZONE, new Throwable(UmengErrorCode.ShareFailed.getMessage() + UmengText.tencentEmpty((boolean)Config.isUmengQQ)));
                }
            });
            return false;
        }
        if (!this.isInstall(this.getConfig())) {
            if (Config.isJumptoAppStore) {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)"http://log.umsns.com/link/qq/download/"));
                ((Activity)this.mWeakAct.get()).startActivity(intent);
            }
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    QZoneSsoHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.NotInstall.getMessage()));
                }
            });
            return false;
        }
        this.mShareContent = new QZoneShareContent(content);
        if (this.mShareConfig != null) {
            this.mShareContent.setCompressListener(this.mShareConfig.getCompressListener());
        }
        this.shareToQZone();
        return false;
    }

    private void shareToQZone() {
        Bundle bundle = this.mShareContent.buildParamsQzone();
        bundle.putString("appName", this.getShareConfig().getAppName());
        if (this.mShareContent.getisPublish()) {
            this.doPublishToQzone(bundle);
        } else {
            this.defaultQZoneShare(bundle);
        }
    }

    public void deleteAuth(final UMAuthListener listener) {
        this.mTencent.logout(this.getContext());
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                QZoneSsoHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QZONE, 1, null);
            }
        });
    }

    private boolean isInstall(PlatformConfig.Platform p) {
        return this.mWeakAct.get() == null || ((Activity)this.mWeakAct.get()).isFinishing() || this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    public boolean isSupportAuth() {
        return true;
    }

    public void authorize(UMAuthListener authListener) {
        if (!this.isInstall(this.getConfig())) {
            return;
        }
        this.mAuthListener = authListener;
        this.loginDeal();
    }

    private void loginDeal() {
        if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
            this.mTencent.login((Activity)this.mWeakAct.get(), "all", this.getAuthlistener(this.mAuthListener));
        }
    }

    private IUiListener getAuthlistener(UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                QZoneSsoHandler.this.getAuthListener(QZoneSsoHandler.this.mAuthListener).onError(SHARE_MEDIA.QQ, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + " ==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            public void onCancel() {
                QZoneSsoHandler.this.getAuthListener(QZoneSsoHandler.this.mAuthListener).onCancel(SHARE_MEDIA.QQ, 0);
            }

            public void onComplete(Object response) {
                String status;
                SocializeUtils.safeCloseDialog((Dialog)QZoneSsoHandler.this.mProgressDialog);
                Bundle values = QZoneSsoHandler.this.parseOauthData(response);
                QZoneSsoHandler.this.qqPreferences.setAuthData(values).commit();
                QZoneSsoHandler.this.initOpenidAndToken((JSONObject)response);
                if (QZoneSsoHandler.this.mAuthListener != null) {
                    QZoneSsoHandler.this.mAuthListener.onComplete(SHARE_MEDIA.QQ, 0, SocializeUtils.bundleTomap((Bundle)values));
                }
                if (values != null && TextUtils.isEmpty((CharSequence)(status = values.getString("ret")))) {
                    return;
                }
            }

            public void onWarning(int i) {
            }
        };
    }

    private void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception e) {
            SLog.error((String)UmengText.QQ.OPENIDANDTOKEN, (Throwable)e);
        }
    }

    public int getRequestCode() {
        return 10104;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10104) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getmShareListener(this.mShareListener));
        }
        if (requestCode == 11101) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.getAuthlistener(this.mAuthListener));
        }
    }

    private IUiListener getmShareListener(final UMShareListener mShareListener) {
        return new IUiListener(){

            public void onComplete(Object o) {
                QZoneSsoHandler.this.getShareListener(mShareListener).onResult(SHARE_MEDIA.QZONE);
            }

            public void onError(UiError uiError) {
                QZoneSsoHandler.this.getShareListener(mShareListener).onError(SHARE_MEDIA.QZONE, new Throwable(UmengErrorCode.ShareFailed.getMessage() + uiError.errorMessage));
            }

            public void onCancel() {
                QZoneSsoHandler.this.getShareListener(mShareListener).onCancel(SHARE_MEDIA.QZONE);
            }

            public void onWarning(int i) {
            }
        };
    }

    private void doPublishToQzone(final Bundle bundle) {
        if (bundle != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (QZoneSsoHandler.this.mWeakAct.get() != null && !((Activity)QZoneSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        QZoneSsoHandler.this.mTencent.publishToQzone((Activity)QZoneSsoHandler.this.mWeakAct.get(), bundle, QZoneSsoHandler.this.getmShareListener(QZoneSsoHandler.this.mShareListener));
                    }
                }
            });
        }
    }

    private void defaultQZoneShare(final Bundle bundle) {
        if (bundle != null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (QZoneSsoHandler.this.mWeakAct.get() != null && !((Activity)QZoneSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        QZoneSsoHandler.this.mTencent.shareToQzone((Activity)QZoneSsoHandler.this.mWeakAct.get(), bundle, QZoneSsoHandler.this.getmShareListener(QZoneSsoHandler.this.mShareListener));
                    }
                }
            });
        }
    }
}

