/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.handler;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import com.tencent.connect.UserInfo;
import com.tencent.tauth.IUiListener;
import com.tencent.tauth.Tencent;
import com.tencent.tauth.UiError;
import com.umeng.socialize.Config;
import com.umeng.socialize.PlatformConfig;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.UMAuthListener;
import com.umeng.socialize.UMShareListener;
import com.umeng.socialize.bean.SHARE_MEDIA;
import com.umeng.socialize.bean.UmengErrorCode;
import com.umeng.socialize.common.QueuedWork;
import com.umeng.socialize.handler.QQPreferences;
import com.umeng.socialize.handler.UMTencentSSOHandler;
import com.umeng.socialize.media.QQShareContent;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.SocializeUtils;
import com.umeng.socialize.utils.UmengText;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.json.JSONException;
import org.json.JSONObject;

public class UMQQSsoHandler
extends UMTencentSSOHandler {
    private static final String TAG = "UMQQSsoHandler";
    private IUiListener mShareListener;
    private QQPreferences qqPreferences;
    private final String UNIONID_REQUEST_URL = "https://graph.qq.com/oauth2.0/me?access_token=";
    private final String UNIONID_PARAM = "&unionid=1";
    private IUiListener holder = null;

    @Override
    public void onCreate(Context context, PlatformConfig.Platform p) {
        super.onCreate(context, p);
        if (context != null) {
            this.qqPreferences = new QQPreferences(context, SHARE_MEDIA.QQ.toString());
        }
    }

    public boolean share(ShareContent content, final UMShareListener listener) {
        if (this.mTencent == null) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMQQSsoHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.ShareFailed.getMessage() + UmengText.tencentEmpty((boolean)Config.isUmengQQ)));
                }
            });
            return false;
        }
        if (!this.isInstall()) {
            this.onNotInstall(listener);
            return false;
        }
        Bundle shareParams = this.buildShareContent(content);
        String errorInfo = shareParams.getString("error");
        if (!TextUtils.isEmpty((CharSequence)errorInfo)) {
            this.onShareParamsError(listener, errorInfo);
            return false;
        }
        this.mShareListener = this.getQQSharelistener(listener);
        this.shareToQQ(shareParams);
        return false;
    }

    private void onNotInstall(final UMShareListener listener) {
        if (Config.isJumptoAppStore) {
            Intent intent = new Intent("android.intent.action.VIEW");
            intent.setData(Uri.parse((String)"https://log.umsns.com/link/qq/download/"));
            ((Activity)this.mWeakAct.get()).startActivity(intent);
        }
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UMQQSsoHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.NotInstall.getMessage()));
            }
        });
    }

    private void onShareParamsError(final UMShareListener listener, final String error) {
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UMQQSsoHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.ShareDataTypeIllegal.getMessage() + error));
            }
        });
    }

    private Bundle buildShareContent(ShareContent content) {
        QQShareContent shareContent = new QQShareContent(content);
        if (this.mShareConfig != null) {
            shareContent.setCompressListener(this.mShareConfig.getCompressListener());
        }
        Bundle shareParams = shareContent.buildParams(this.getShareConfig().isHideQzoneOnQQFriendList(), this.getShareConfig().getAppName());
        shareParams.putString("appName", this.getShareConfig().getAppName());
        return shareParams;
    }

    private IUiListener getQQSharelistener(final UMShareListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                String errorMsg = e == null ? "" : e.errorMessage;
                UMQQSsoHandler.this.getShareListener(listener).onError(SHARE_MEDIA.QQ, new Throwable(UmengErrorCode.ShareFailed.getMessage() + errorMsg));
            }

            public void onCancel() {
                UMQQSsoHandler.this.getShareListener(listener).onCancel(SHARE_MEDIA.QQ);
            }

            public void onComplete(Object response) {
                UMQQSsoHandler.this.getShareListener(listener).onResult(SHARE_MEDIA.QQ);
            }

            public void onWarning(int i) {
            }
        };
    }

    public boolean isAuthorize() {
        if (this.qqPreferences != null) {
            return this.qqPreferences.isAuthValid();
        }
        return false;
    }

    public void authorize(UMAuthListener listener) {
        this.mAuthListener = listener;
        this.loginDeal();
    }

    public void setAuthListener(UMAuthListener listener) {
        super.setAuthListener(listener);
        this.mAuthListener = listener;
    }

    public boolean isHasAuthListener() {
        return this.mAuthListener != null;
    }

    protected IUiListener getQQAuthlistener(final UMAuthListener listener) {
        return new IUiListener(){

            public void onError(UiError e) {
                UMQQSsoHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 0, new Throwable(UmengErrorCode.AuthorizeFailed.getMessage() + "==> errorCode = " + e.errorCode + ", errorMsg = " + e.errorMessage + ", detail = " + e.errorDetail));
            }

            public void onCancel() {
                UMQQSsoHandler.this.getAuthListener(listener).onCancel(SHARE_MEDIA.QQ, 0);
            }

            public void onComplete(final Object response) {
                SocializeUtils.safeCloseDialog((Dialog)UMQQSsoHandler.this.mProgressDialog);
                final Bundle values = UMQQSsoHandler.this.parseOauthData(response);
                if (UMQQSsoHandler.this.qqPreferences == null && UMQQSsoHandler.this.getContext() != null) {
                    UMQQSsoHandler.this.qqPreferences = new QQPreferences(UMQQSsoHandler.this.getContext(), SHARE_MEDIA.QQ.toString());
                }
                if (UMQQSsoHandler.this.qqPreferences != null) {
                    UMQQSsoHandler.this.qqPreferences.setAuthData(values).commit();
                }
                QueuedWork.runInBack((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("https://graph.qq.com/oauth2.0/me?access_token=").append(UMQQSsoHandler.this.getAccessToken(UMQQSsoHandler.this.qqPreferences)).append("&unionid=1");
                        String result = UMQQSsoHandler.this.getUnionIdRequest(stringBuilder.toString());
                        if (!TextUtils.isEmpty((CharSequence)result)) {
                            try {
                                String errormessage;
                                JSONObject jsonObject = new JSONObject(result.replace("callback", "").replace("(", "").replace(")", ""));
                                String unionid = jsonObject.optString("unionid");
                                String openid = jsonObject.optString("openid");
                                UMQQSsoHandler.this.setmOpenid(openid);
                                UMQQSsoHandler.this.setUnionid(unionid);
                                if (UMQQSsoHandler.this.qqPreferences != null) {
                                    UMQQSsoHandler.this.qqPreferences.commit();
                                }
                                if (!TextUtils.isEmpty((CharSequence)(errormessage = jsonObject.optString("error_description")))) {
                                    SLog.E((String)(UmengText.QQ.ERRORINFO + errormessage));
                                }
                            }
                            catch (JSONException e) {
                                SLog.error((Throwable)e);
                            }
                        }
                        UMQQSsoHandler.this.initOpenidAndToken((JSONObject)response);
                        final Map map = SocializeUtils.bundleTomap((Bundle)values);
                        map.put("unionid", UMQQSsoHandler.this.getUnionid(UMQQSsoHandler.this.qqPreferences));
                        QueuedWork.runInMain((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                UMQQSsoHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QQ, 0, map);
                            }
                        });
                        if (UMQQSsoHandler.this.config != null) {
                            map.put("aid", UMQQSsoHandler.this.config.appId);
                            map.put("as", UMQQSsoHandler.this.config.appkey);
                        }
                    }
                }, (boolean)true);
            }

            public void onWarning(int i) {
            }
        };
    }

    private void qqPreferencesDelete() {
        if (this.qqPreferences != null) {
            this.qqPreferences.delete();
        }
    }

    private void setUnionid(String unionid) {
        if (this.qqPreferences != null) {
            this.qqPreferences.setUnionid(unionid);
        }
    }

    private void setmOpenid(String openid) {
        if (this.qqPreferences != null) {
            this.qqPreferences.setmOpenid(openid);
        }
    }

    public boolean isInstall() {
        return this.mTencent != null && this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    public void release() {
        super.release();
        if (this.holder != null) {
            this.holder = null;
        }
    }

    public String getSDKVersion() {
        return "3.1.0";
    }

    public boolean isSupport() {
        return this.mTencent != null && this.mTencent.isSupportSSOLogin((Activity)this.mWeakAct.get());
    }

    public void deleteAuth(final UMAuthListener listener) {
        if (this.mTencent != null) {
            this.mTencent.logout(this.getContext());
        }
        this.qqPreferencesDelete();
        QueuedWork.runInMain((Runnable)new Runnable(){

            @Override
            public void run() {
                UMQQSsoHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QQ, 1, null);
                if (UMQQSsoHandler.this.holder != null) {
                    UMQQSsoHandler.this.holder = null;
                }
            }
        });
    }

    public boolean isSupportAuth() {
        return true;
    }

    private void loginDeal() {
        if (this.isInstall()) {
            if (this.mWeakAct.get() != null && !((Activity)this.mWeakAct.get()).isFinishing()) {
                if (this.holder == null) {
                    this.holder = this.getQQAuthlistener(this.mAuthListener);
                }
                if (this.mTencent != null) {
                    this.mTencent.login((Activity)this.mWeakAct.get(), "all", this.holder);
                }
            }
        } else {
            if (this.holder == null) {
                this.holder = this.getQQAuthlistener(this.mAuthListener);
            }
            if (this.mTencent != null) {
                this.mTencent.loginServerSide((Activity)this.mWeakAct.get(), "all", this.holder);
            }
        }
    }

    private void initOpenidAndToken(JSONObject jsonObject) {
        try {
            String token = jsonObject.getString("access_token");
            String expires = jsonObject.getString("expires_in");
            String openId = jsonObject.getString("openid");
            if (!(this.mTencent == null || TextUtils.isEmpty((CharSequence)token) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                this.mTencent.setAccessToken(token, expires);
                this.mTencent.setOpenId(openId);
            }
        }
        catch (Exception e) {
            SLog.error((String)UmengText.QQ.OPENIDANDTOKEN, (Throwable)e);
        }
    }

    private void shareToQQ(final Bundle shareParams) {
        if (this.validTencent()) {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    if (UMQQSsoHandler.this.mTencent != null && UMQQSsoHandler.this.mWeakAct.get() != null && !((Activity)UMQQSsoHandler.this.mWeakAct.get()).isFinishing()) {
                        UMQQSsoHandler.this.mTencent.shareToQQ((Activity)UMQQSsoHandler.this.mWeakAct.get(), shareParams, UMQQSsoHandler.this.mShareListener);
                    }
                }
            });
        } else {
            this.mShareListener.onError(new UiError(-1, UmengText.QQ.QQ_ERROR, UmengText.QQ.QQ_ERROR));
        }
    }

    private String getUnionIdRequest(String urlStr) {
        String emptyStr = "";
        try {
            URL url = new URL(urlStr);
            URLConnection conn = url.openConnection();
            if (conn == null) {
                return emptyStr;
            }
            conn.connect();
            InputStream inputStream = conn.getInputStream();
            if (inputStream == null) {
                return emptyStr;
            }
            return UMQQSsoHandler.convertStreamToString(inputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
            return emptyStr;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String convertStreamToString(InputStream is) {
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        StringBuilder sb = new StringBuilder();
        String line = null;
        try {
            while ((line = reader.readLine()) != null) {
                sb.append(line + "/n");
            }
        }
        catch (IOException e) {
            SLog.error((Throwable)e);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                SLog.error((Throwable)e);
            }
        }
        return sb.toString();
    }

    public int getRequestCode() {
        return 10103;
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 10103) {
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.mShareListener);
        }
        if (requestCode == 11101) {
            if (this.holder == null) {
                this.holder = this.getQQAuthlistener(this.mAuthListener);
            }
            Tencent.onActivityResultData((int)requestCode, (int)resultCode, (Intent)data, (IUiListener)this.holder);
        }
    }

    private void fetchUserInfo(final UMAuthListener listener) {
        String accessToken = this.getAccessToken(this.qqPreferences);
        if (this.mTencent != null && this.isValidAccessToken(accessToken)) {
            try {
                String expires = this.getExpiresIn(this.qqPreferences);
                String openId = this.getOpenId(this.qqPreferences);
                if (!(TextUtils.isEmpty((CharSequence)accessToken) || TextUtils.isEmpty((CharSequence)expires) || TextUtils.isEmpty((CharSequence)openId))) {
                    this.mTencent.setAccessToken(accessToken, expires);
                    this.mTencent.setOpenId(openId);
                }
                IUiListener fetchUserInfoListener = this.getFetchUserInfoListener(listener);
                UserInfo userInfo = new UserInfo(this.getContext(), this.mTencent.getQQToken());
                userInfo.getUserInfo(fetchUserInfoListener);
            }
            catch (Exception e) {
                QueuedWork.runInMain((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        UMQQSsoHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + e.getMessage()));
                    }
                });
            }
        } else {
            QueuedWork.runInMain((Runnable)new Runnable(){

                @Override
                public void run() {
                    UMQQSsoHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + "token is invalid"));
                }
            });
        }
    }

    private IUiListener getFetchUserInfoListener(final UMAuthListener listener) {
        return new IUiListener(){

            public void onComplete(Object arg) {
                if (listener == null) {
                    return;
                }
                try {
                    Map userInfo = UMQQSsoHandler.this.parseUserInfo(arg.toString());
                    UMQQSsoHandler.this.appendTokenToUserInfo(userInfo);
                    if (!TextUtils.isEmpty((CharSequence)((CharSequence)userInfo.get("ret"))) && ((String)userInfo.get("ret")).equals("100030")) {
                        UMQQSsoHandler.this.qqPreferencesDelete();
                        UMQQSsoHandler.this.authAndFetchUserInfo(listener);
                    } else {
                        UMQQSsoHandler.this.getAuthListener(listener).onComplete(SHARE_MEDIA.QQ, 2, userInfo);
                    }
                }
                catch (JSONException e) {
                    UMQQSsoHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + "parse json error"));
                }
            }

            public void onError(UiError uiError) {
                UMQQSsoHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, new Throwable(UmengErrorCode.RequestForUserProfileFailed.getMessage() + uiError.errorMessage));
            }

            public void onCancel() {
                UMQQSsoHandler.this.getAuthListener(listener).onCancel(SHARE_MEDIA.QQ, 2);
            }

            public void onWarning(int i) {
            }
        };
    }

    private void appendTokenToUserInfo(Map<String, String> userInfo) {
        if (userInfo == null) {
            return;
        }
        String accessToken = this.getAccessToken(this.qqPreferences);
        String openId = this.getOpenId(this.qqPreferences);
        String expiresIn = this.getExpiresIn(this.qqPreferences);
        String unionid = this.getUnionid(this.qqPreferences);
        userInfo.put("openid", openId);
        userInfo.put("uid", openId);
        userInfo.put("access_token", accessToken);
        userInfo.put("expires_in", expiresIn);
        userInfo.put("accessToken", accessToken);
        userInfo.put("expiration", expiresIn);
        userInfo.put("unionid", unionid);
    }

    private Map<String, String> parseUserInfo(String userInfo) throws JSONException {
        JSONObject jsonObject = new JSONObject(userInfo);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("screen_name", jsonObject.optString("nickname"));
        result.put("name", jsonObject.optString("nickname"));
        result.put("gender", this.getGender(jsonObject.optString("gender")));
        result.put("profile_image_url", jsonObject.optString("figureurl_qq_2"));
        result.put("iconurl", jsonObject.optString("figureurl_qq_2"));
        result.put("is_yellow_year_vip", jsonObject.optString("is_yellow_year_vip"));
        result.put("yellow_vip_level", jsonObject.optString("yellow_vip_level"));
        result.put("msg", jsonObject.optString("msg"));
        result.put("city", jsonObject.optString("city"));
        result.put("vip", jsonObject.optString("vip"));
        result.put("ret", jsonObject.optString("ret"));
        result.put("level", jsonObject.optString("level"));
        result.put("province", jsonObject.optString("province"));
        result.put("is_yellow_vip", jsonObject.optString("is_yellow_vip"));
        return result;
    }

    private boolean isValidAccessToken(String accessToken) {
        return !TextUtils.isEmpty((CharSequence)accessToken);
    }

    private String getAccessToken(QQPreferences preferences) {
        if (preferences != null) {
            return preferences.getmAccessToken();
        }
        return null;
    }

    private String getUnionid(QQPreferences preferences) {
        if (preferences != null) {
            return preferences.getUnionid();
        }
        return null;
    }

    private String getOpenId(QQPreferences preferences) {
        if (preferences != null) {
            return preferences.getmUID();
        }
        return null;
    }

    private String getExpiresIn(QQPreferences preferences) {
        if (preferences != null) {
            return preferences.getExpiresIn() + "";
        }
        return null;
    }

    public void getPlatformInfo(UMAuthListener listener) {
        if (this.isAuthorize() && !this.getShareConfig().isNeedAuthOnGetUserInfo()) {
            this.fetchUserInfo(listener);
        } else {
            this.authAndFetchUserInfo(listener);
        }
    }

    private void authAndFetchUserInfo(final UMAuthListener listener) {
        UMAuthListener umAuthListener = new UMAuthListener(){

            public void onStart(SHARE_MEDIA platform) {
            }

            public void onComplete(SHARE_MEDIA platform, int action, Map<String, String> data) {
                UMQQSsoHandler.this.fetchUserInfo(listener);
            }

            public void onError(SHARE_MEDIA platform, int action, Throwable throwable) {
                UMQQSsoHandler.this.getAuthListener(listener).onError(SHARE_MEDIA.QQ, 2, throwable);
            }

            public void onCancel(SHARE_MEDIA platform, int action) {
                UMQQSsoHandler.this.getAuthListener(listener).onCancel(SHARE_MEDIA.QQ, 2);
            }
        };
        this.authorize(umAuthListener);
    }
}

