/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.os.Bundle;
import android.text.TextUtils;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.media.UMQQMini;
import com.umeng.socialize.media.UMVideo;
import com.umeng.socialize.media.UMWeb;
import com.umeng.socialize.media.UMusic;
import com.umeng.socialize.utils.UmengText;
import java.io.File;

public class QQShareContent
extends SimpleShareContent {
    public int mShareType = 1;

    public QQShareContent(ShareContent shareContent) {
        super(shareContent);
        if (shareContent.mMedia instanceof UMusic) {
            this.setMusic((UMusic)shareContent.mMedia);
        } else if (shareContent.mMedia instanceof UMVideo) {
            this.setVideo((UMVideo)shareContent.mMedia);
        }
    }

    public Bundle buildParams(boolean isHideQzone, String appName) {
        int style = this.getmStyle();
        Bundle bundle = new Bundle();
        if (style == 2 || style == 3) {
            this.mShareType = 5;
            this.buildImageParams(bundle);
        } else if (style == 4 && this.getMusic() != null) {
            this.mShareType = 2;
            this.buildAudioParams(bundle);
        } else if (style == 16) {
            this.buildWebParams(bundle);
        } else if (style == 8) {
            this.buildVideoParams(bundle);
        } else if (style == 256) {
            this.buildMiniApp(bundle);
        } else {
            bundle.putString("error", UmengText.supportStyle((boolean)false, (String)"text"));
        }
        bundle.putInt("req_type", this.mShareType);
        if (isHideQzone) {
            bundle.putInt("cflag", 2);
        } else {
            bundle.putInt("cflag", 1);
        }
        if (!TextUtils.isEmpty((CharSequence)appName)) {
            bundle.putString("appName", appName);
        }
        return bundle;
    }

    private void buildImageParams(Bundle bundle) {
        UMImage image = this.getImage();
        if (image == null) {
            return;
        }
        File file = image.asFileImage();
        if (file == null) {
            bundle.putString("error", UmengText.QQ.QQ_PERMISSION);
            return;
        }
        bundle.putString("imageLocalUrl", file.getPath());
    }

    private void buildVideoParams(Bundle bundle) {
        UMVideo video = this.getVideo();
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)video));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)video));
        bundle.putString("targetUrl", video.toUrl());
        UMImage thumb = video.getThumbImage();
        if (thumb == null) {
            return;
        }
        if (thumb.isUrlMedia()) {
            bundle.putString("imageUrl", thumb.toUrl());
            return;
        }
        File file = thumb.asFileImage();
        if (file == null) {
            bundle.putString("error", UmengText.QQ.QQ_PERMISSION);
            return;
        }
        bundle.putString("imageUrl", file.getPath());
    }

    private void buildWebParams(Bundle bundle) {
        UMWeb web = this.getUmWeb();
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)web));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)web));
        if (TextUtils.isEmpty((CharSequence)web.toUrl())) {
            bundle.putString("error", UmengText.SHARE.EMPTY_WEB_URL);
        } else {
            bundle.putString("targetUrl", web.toUrl());
        }
        UMImage thumb = web.getThumbImage();
        if (thumb == null) {
            return;
        }
        if (thumb.isUrlMedia()) {
            bundle.putString("imageUrl", thumb.toUrl());
            return;
        }
        File file = thumb.asFileImage();
        if (file == null) {
            bundle.putString("error", UmengText.QQ.QQ_PERMISSION);
            return;
        }
        bundle.putString("imageUrl", file.getPath());
    }

    private void buildAudioParams(Bundle bundle) {
        UMusic music = this.getMusic();
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)music));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)music));
        bundle.putString("audio_url", music.toUrl());
        if (!TextUtils.isEmpty((CharSequence)music.getmTargetUrl())) {
            bundle.putString("targetUrl", music.getmTargetUrl());
        } else {
            bundle.putString("targetUrl", music.toUrl());
        }
        UMImage thumb = music.getThumbImage();
        if (thumb == null) {
            return;
        }
        if (thumb.isUrlMedia()) {
            bundle.putString("imageUrl", thumb.toUrl());
            return;
        }
        File file = thumb.asFileImage();
        if (file == null) {
            bundle.putString("error", UmengText.QQ.QQ_PERMISSION);
            return;
        }
        bundle.putString("imageUrl", file.getPath());
    }

    private void buildMiniApp(Bundle bundle) {
        String miniAppId;
        UMQQMini qqMini = this.getQQMini();
        String url = qqMini.toUrl();
        if (!TextUtils.isEmpty((CharSequence)url)) {
            bundle.putString("targetUrl", qqMini.toUrl());
        }
        if (!TextUtils.isEmpty((CharSequence)(miniAppId = qqMini.getMiniAppId()))) {
            String type;
            bundle.putString("mini_program_appid", miniAppId);
            String path = qqMini.getPath();
            if (!TextUtils.isEmpty((CharSequence)path)) {
                bundle.putString("mini_program_path", path);
            }
            if (!TextUtils.isEmpty((CharSequence)(type = qqMini.getType()))) {
                bundle.putString("mini_program_type", type);
            }
        }
        bundle.putString("title", this.objectSetTitle((BaseMediaObject)qqMini));
        bundle.putString("summary", this.objectSetDescription((BaseMediaObject)qqMini));
        UMImage thumb = qqMini.getThumbImage();
        if (thumb == null) {
            return;
        }
        if (thumb.isUrlMedia()) {
            bundle.putString("imageUrl", thumb.toUrl());
            return;
        }
        File file = thumb.asFileImage();
        if (file == null) {
            bundle.putString("error", UmengText.QQ.QQ_PERMISSION);
            return;
        }
        bundle.putString("imageUrl", file.getPath());
    }
}

