/*
 * Decompiled with CFR 0.152.
 */
package com.umeng.socialize.media;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.support.v4.content.FileProvider;
import android.text.TextUtils;
import com.sina.weibo.sdk.api.ImageObject;
import com.sina.weibo.sdk.api.MultiImageObject;
import com.sina.weibo.sdk.api.TextObject;
import com.sina.weibo.sdk.api.WebpageObject;
import com.sina.weibo.sdk.api.WeiboMultiMessage;
import com.umeng.socialize.ShareContent;
import com.umeng.socialize.media.BaseMediaObject;
import com.umeng.socialize.media.SimpleShareContent;
import com.umeng.socialize.media.UMImage;
import com.umeng.socialize.net.LinkCardResponse;
import com.umeng.socialize.net.LinkcardRequest;
import com.umeng.socialize.net.RestAPI;
import com.umeng.socialize.utils.ContextUtil;
import com.umeng.socialize.utils.SLog;
import com.umeng.socialize.utils.UmengText;
import java.io.File;
import java.util.ArrayList;
import java.util.UUID;

public class SinaShareContent
extends SimpleShareContent {
    private boolean isSupport = false;

    public SinaShareContent(ShareContent shareContent) {
        super(shareContent);
    }

    public void setSupport(boolean support) {
        this.isSupport = support;
    }

    public Uri getFileUri(Context context, File file, String fileProvider) {
        if (file == null || !file.exists()) {
            return null;
        }
        Uri contentUri = FileProvider.getUriForFile((Context)context, (String)fileProvider, (File)file);
        context.grantUriPermission("com.sina.weibo", contentUri, 1);
        return contentUri;
    }

    public WeiboMultiMessage getMessage(Context context, boolean useFileProvider, String fileProvider) {
        WeiboMultiMessage weiboMessage = new WeiboMultiMessage();
        if (this.getmStyle() == 2 || this.getmStyle() == 3) {
            if (this.getmImages() != null && this.getmImages().length > 0 && this.isSupport) {
                weiboMessage.multiImageObject = useFileProvider ? this.getMutiImageObjectWithFileProvider(context, fileProvider) : this.getMutiImageObject();
                weiboMessage.textObject = !TextUtils.isEmpty((CharSequence)this.getText()) ? this.getTextObj() : this.getTextObjMul();
            } else {
                weiboMessage.imageObject = useFileProvider ? this.getImageObjWithBitmap() : this.getImageObj();
                if (!TextUtils.isEmpty((CharSequence)this.getText())) {
                    weiboMessage.textObject = this.getTextObj();
                }
            }
        } else if (this.getmStyle() == 16) {
            weiboMessage.mediaObject = this.getWebpageObj();
            this.addText(weiboMessage);
        } else if (this.getmStyle() == 4) {
            weiboMessage.mediaObject = this.getMusicObj();
            this.addText(weiboMessage);
        } else if (this.getmStyle() == 8) {
            weiboMessage.mediaObject = this.getVideoObj();
            this.addText(weiboMessage);
        } else {
            weiboMessage.textObject = this.getTextObj();
        }
        return weiboMessage;
    }

    private WeiboMultiMessage addText(WeiboMultiMessage message) {
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            message.textObject = this.getTextObj();
        } else {
            TextObject textObject = new TextObject();
            if (this.getBaseMediaObject() != null && !TextUtils.isEmpty((CharSequence)this.getBaseMediaObject().getDescription())) {
                textObject.text = this.getBaseMediaObject().getDescription();
            }
            message.textObject = textObject;
        }
        return message;
    }

    private TextObject getTextObj() {
        TextObject textObject = new TextObject();
        textObject.text = this.getText();
        return textObject;
    }

    private TextObject getTextObjMul() {
        TextObject textObject = new TextObject();
        textObject.text = "default text";
        SLog.E((String)UmengText.SINA.SINA_MUL_IMAGE);
        return textObject;
    }

    private ImageObject getImageObj() {
        ImageObject imageObject = new ImageObject();
        if (this.canFileValid(this.getImage())) {
            imageObject.imagePath = this.getImage().asFileImage().toString();
        } else {
            imageObject.imageData = this.getImageData(this.getImage());
        }
        imageObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getImage());
        imageObject.description = this.getText();
        return imageObject;
    }

    private ImageObject getImageObjWithBitmap() {
        Bitmap bmp;
        ImageObject imageObject = new ImageObject();
        if (this.canFileValid(this.getImage()) && (bmp = this.getImage().asBitmap()) != null) {
            imageObject.setImageData(bmp);
        }
        return imageObject;
    }

    private MultiImageObject getMutiImageObject() {
        MultiImageObject multiImageObject = new MultiImageObject();
        UMImage[] images = this.getmImages();
        ArrayList<Uri> pathList = new ArrayList<Uri>();
        for (int i = 0; i < images.length; ++i) {
            File f;
            if (images[i] == null || (f = images[i].asFileImage()) == null) continue;
            SLog.E((String)(i + ":" + Uri.fromFile((File)f)));
            pathList.add(Uri.fromFile((File)f));
        }
        multiImageObject.imageList = pathList;
        return multiImageObject;
    }

    private MultiImageObject getMutiImageObjectWithFileProvider(Context context, String fileProvider) {
        MultiImageObject multiImageObject = new MultiImageObject();
        UMImage[] images = this.getmImages();
        Uri fileUri = null;
        ArrayList<Uri> pathList = new ArrayList<Uri>();
        for (int i = 0; i < images.length; ++i) {
            File f;
            if (images[i] == null || (f = images[i].asFileImage()) == null) continue;
            SLog.E((String)(i + ":" + Uri.fromFile((File)f)));
            fileUri = this.getFileUri(context, f, fileProvider);
            if (fileUri == null) continue;
            pathList.add(fileUri);
        }
        multiImageObject.imageList = pathList;
        return multiImageObject;
    }

    private WebpageObject getWebpageObj() {
        LinkcardRequest request = new LinkcardRequest(ContextUtil.getContext());
        request.setMedia((BaseMediaObject)this.getUmWeb());
        LinkCardResponse response = RestAPI.convertLinkCard((LinkcardRequest)request);
        WebpageObject mediaObject = new WebpageObject();
        mediaObject.identify = UUID.randomUUID().toString();
        mediaObject.title = this.objectSetTitle((BaseMediaObject)this.getUmWeb());
        mediaObject.description = this.objectSetDescription((BaseMediaObject)this.getUmWeb());
        if (this.getUmWeb().getThumbImage() != null) {
            mediaObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getUmWeb());
        } else {
            SLog.E((String)UmengText.SINA.SINA_THUMB_ERROR);
        }
        mediaObject.actionUrl = response != null && !TextUtils.isEmpty((CharSequence)response.url) ? response.url : this.getUmWeb().toUrl();
        mediaObject.defaultText = this.getText();
        return mediaObject;
    }

    private WebpageObject getMusicObj() {
        WebpageObject musicObject = new WebpageObject();
        musicObject.identify = UUID.randomUUID().toString();
        musicObject.title = this.objectSetTitle((BaseMediaObject)this.getMusic());
        musicObject.description = this.objectSetDescription((BaseMediaObject)this.getMusic());
        if (this.getMusic().getThumbImage() != null) {
            musicObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getMusic());
        } else {
            SLog.E((String)UmengText.SINA.SINA_THUMB_ERROR);
        }
        musicObject.actionUrl = this.getMusic().getmTargetUrl();
        if (!TextUtils.isEmpty((CharSequence)this.getText())) {
            musicObject.defaultText = this.getText();
        }
        return musicObject;
    }

    private WebpageObject getVideoObj() {
        WebpageObject videoObject = new WebpageObject();
        videoObject.identify = UUID.randomUUID().toString();
        videoObject.title = this.objectSetTitle((BaseMediaObject)this.getVideo());
        videoObject.description = this.objectSetDescription((BaseMediaObject)this.getVideo());
        if (this.getVideo().getThumbImage() != null) {
            videoObject.thumbData = this.objectSetThumb((BaseMediaObject)this.getVideo());
        } else {
            SLog.E((String)UmengText.SINA.SINA_THUMB_ERROR);
        }
        videoObject.actionUrl = this.getVideo().toUrl();
        if (!TextUtils.isEmpty((CharSequence)this.getVideo().getDescription())) {
            videoObject.description = this.getVideo().getDescription();
        }
        videoObject.defaultText = this.getText();
        return videoObject;
    }
}

