/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.logger;

import android.content.Context;
import com.nirvana.tools.logger.cache.ACMMonitorCacheManager;
import com.nirvana.tools.logger.cache.db.DbException;
import com.nirvana.tools.logger.env.ACMComponent;
import com.nirvana.tools.logger.env.ACMComponentImpl;
import com.nirvana.tools.logger.executor.ReentrantSingleThreadExecutor;
import com.nirvana.tools.logger.model.ACMLimitConfig;
import com.nirvana.tools.logger.model.ACMMonitorRecord;
import com.nirvana.tools.logger.upload.ACMMonitorUploadManager;
import com.nirvana.tools.logger.upload.ACMUpload;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.json.JSONObject;

public class ACMMonitor
implements ACMComponent {
    public static final int UPLOAD_TYPE_MANUAL = 1;
    public static final int UPLOAD_TYPE_TIMER = 2;
    private static final AtomicInteger MONITOR_COUNT = new AtomicInteger();
    private ACMMonitorCacheManager mCacheManager;
    private ACMMonitorUploadManager mUploadManager;
    private ACMComponentImpl mEnv;

    /*
     * WARNING - void declaration
     */
    public ACMMonitor(Context context, ACMUpload<ACMMonitorRecord> acmUpLoad) {
        this((Context)var1_1, (ACMUpload<ACMMonitorRecord>)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ACMMonitor(Context context, ACMUpload<ACMMonitorRecord> acmUpLoad, String prdName) {
        void var2_2;
        void var1_1;
        void var3_3;
        ReentrantSingleThreadExecutor reentrantSingleThreadExecutor = new ReentrantSingleThreadExecutor("ACMMonitor" + MONITOR_COUNT.getAndAdd(1));
        String string = prdName == null ? "alitx_monitor" : prdName + "_alitx_monitor";
        this.mCacheManager = new ACMMonitorCacheManager(context.getApplicationContext(), reentrantSingleThreadExecutor, string, (String)var3_3);
        this.mUploadManager = new ACMMonitorUploadManager(var1_1.getApplicationContext(), this.mCacheManager, (ACMUpload<ACMMonitorRecord>)var2_2, reentrantSingleThreadExecutor);
        this.mEnv = new ACMComponentImpl(this.mUploadManager);
    }

    /*
     * WARNING - void declaration
     */
    public void monitor(Map<String, String> map, int urgency) {
        void var2_2;
        void var1_1;
        this.cacheMonitor(new JSONObject((Map)var1_1).toString(), (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void monitor(String content, int urgency) {
        void var2_2;
        void var1_1;
        this.cacheMonitor((String)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void monitorRecords(List<ACMMonitorRecord> records) {
        void var1_1;
        this.cacheMonitorRecords((List<ACMMonitorRecord>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void cacheMonitor(String content, int urgency) {
        DbException dbException;
        void var2_2;
        ACMMonitorRecord aCMMonitorRecord = new ACMMonitorRecord((int)var2_2);
        aCMMonitorRecord.setContent((String)((Object)dbException));
        try {
            this.mCacheManager.cacheRecord(aCMMonitorRecord);
            return;
        }
        catch (DbException dbException2) {
            dbException = dbException2;
            dbException2.printStackTrace();
            return;
        }
    }

    private void cacheMonitorRecords(List<ACMMonitorRecord> records) {
        DbException dbException;
        try {
            this.mCacheManager.cacheRecords(dbException);
            return;
        }
        catch (DbException dbException2) {
            dbException = dbException2;
            dbException2.printStackTrace();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUploadType(int uploadType) {
        void var1_1;
        if (uploadType != 1 && uploadType != 2) {
            return;
        }
        this.mUploadManager.setUploadType((int)var1_1);
    }

    public void uploadManual() {
        this.mUploadManager.uploadManual();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setLimitConfig(ACMLimitConfig config) {
        void var1_1;
        this.mEnv.setLimitConfig((ACMLimitConfig)var1_1);
    }

    @Override
    public void clearLimitConfig() {
        this.mEnv.clearLimitConfig();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setUploadEnabled(boolean enabled) {
        void var1_1;
        this.mEnv.setUploadEnabled((boolean)var1_1);
    }

    @Override
    public void uploadFailed() {
        this.mEnv.uploadFailed();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxUploadSize(int maxUploadSize) {
        void var1_1;
        this.mUploadManager.setMaxUploadSize((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxUploadRetry(long maxUploadRetry) {
        void var1_1;
        this.mUploadManager.setMaxUploadRetry((long)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setRetryCount(int retryCount) {
        void var1_1;
        this.mUploadManager.setRetryCount((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void deleteRecordsByFlag(int deleteFlag) {
        void var1_1;
        this.mUploadManager.deleteRecordsByFlag((int)var1_1);
    }
}

