/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.logger.cache.db;

import android.annotation.SuppressLint;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteDatabase;
import android.util.Log;
import com.nirvana.tools.logger.cache.db.DBHelper;
import com.nirvana.tools.logger.cache.db.DbException;
import com.nirvana.tools.logger.model.ACMRecord;
import com.nirvana.tools.logger.utils.ConsoleLogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Semaphore;

public abstract class AbstractDatabase<T extends ACMRecord> {
    public static final int DEFAULT_LIMIT = 0x500000;
    private static final String TAG = AbstractDatabase.class.getName();
    private DBHelper mDbHelper;
    private SQLiteDatabase mDatabase;
    protected String mTableName;
    private Semaphore semaphore = new Semaphore(1);

    /*
     * WARNING - void declaration
     */
    public AbstractDatabase(String tableName, DBHelper dbHelper) {
        void var2_2;
        void var1_1;
        this.mTableName = var1_1;
        this.mDbHelper = var2_2;
        this.setMaxSizeLog(0x500000L);
    }

    public synchronized SQLiteDatabase getWriteDatabase() {
        if (this.mDatabase == null) {
            this.mDatabase = this.mDbHelper.getWritableDatabase();
        }
        return this.mDatabase;
    }

    public SQLiteDatabase getReadDatabase() {
        if (this.mDatabase == null) {
            this.mDatabase = this.mDbHelper.getReadableDatabase();
        }
        return this.mDatabase;
    }

    public void close() {
        if (this.mDatabase != null) {
            this.mDatabase.close();
            this.mDatabase = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setMaxSizeLog(long bytes) {
        try {
            void var1_1;
            SQLiteDatabase sQLiteDatabase = this.getWriteDatabase();
            sQLiteDatabase.setMaximumSize((long)var1_1);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
        finally {
            this.close();
        }
    }

    protected int getCount(SQLiteDatabase database) {
        return (int)DatabaseUtils.longForQuery((SQLiteDatabase)database, (String)String.format("SELECT COUNT(%s) FROM %s", "_id", this.mTableName), null);
    }

    public synchronized long getMaxSizeLog() {
        try {
            long l = this.getReadDatabase().getMaximumSize();
            return l;
        }
        catch (Throwable throwable) {
            return -1L;
        }
        finally {
            this.close();
        }
    }

    public synchronized long getCurrentSize() {
        try {
            long l = this.getReadDatabase().getPageSize() * DatabaseUtils.longForQuery((SQLiteDatabase)this.mDatabase, (String)"PRAGMA page_count;", null);
            return l;
        }
        catch (Throwable throwable) {
            return -1L;
        }
        finally {
            this.close();
        }
    }

    protected String contactIds(long idsLength) {
        if (idsLength > 0L) {
            StringBuilder stringBuilder = new StringBuilder("(");
            do {
                stringBuilder.append("?,");
            } while (--idsLength > 0L);
            StringBuilder stringBuilder2 = stringBuilder;
            stringBuilder2.deleteCharAt(stringBuilder2.length() - 1);
            stringBuilder.append(")");
            return stringBuilder.toString();
        }
        return null;
    }

    public synchronized boolean insertList(List<T> records) throws DbException {
        long l;
        block9: {
            l = -1L;
            if (records != null && records.size() != 0) break block9;
            ConsoleLogUtils.logcatV(TAG, "final " + (this.getWriteDatabase() == null));
            this.mDatabase.endTransaction();
            this.semaphore.release();
            this.close();
            return -1L >= 0L;
        }
        try {
            Iterator iterator;
            if (this.getCurrentSize() >= 0x500000L) {
                ConsoleLogUtils.logcatV(TAG, "Table size is limited, clear half of data!");
                AbstractDatabase abstractDatabase = this;
                AbstractDatabase abstractDatabase2 = this;
                abstractDatabase.deleteOldest(abstractDatabase.getWriteDatabase(), abstractDatabase2.getCount(abstractDatabase2.getWriteDatabase()) / 2);
            }
            this.semaphore.acquire();
            ConsoleLogUtils.logcatV(TAG, "beginTransaction");
            this.getWriteDatabase().beginTransaction();
            ConsoleLogUtils.logcatV(TAG, "writedatabase success  " + (this.mDatabase == null));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ACMRecord aCMRecord = (ACMRecord)iterator.next();
                aCMRecord = this.getContentValuesByRecord(aCMRecord);
                ConsoleLogUtils.logcatV(TAG, "ContentValues");
                l = this.getWriteDatabase().insert(this.mTableName, null, (ContentValues)aCMRecord);
                ConsoleLogUtils.logcatV(TAG, "insert");
                if (l < 0L) {
                    AbstractDatabase abstractDatabase = this;
                    if (abstractDatabase.getCount(abstractDatabase.getWriteDatabase()) > 0) {
                        AbstractDatabase abstractDatabase3 = this;
                        AbstractDatabase abstractDatabase4 = this;
                        abstractDatabase3.deleteOldest(abstractDatabase3.getWriteDatabase(), abstractDatabase4.getCount(abstractDatabase4.getWriteDatabase()) / 2);
                        l = this.getWriteDatabase().insert(this.mTableName, null, (ContentValues)aCMRecord);
                    }
                }
                ConsoleLogUtils.logcatV(TAG, "insert: id=" + l);
            }
            this.getWriteDatabase().setTransactionSuccessful();
            ConsoleLogUtils.logcatV(TAG, "final " + (this.getWriteDatabase() == null));
        }
        catch (Exception exception) {
            try {
                throw new DbException("Insert record failed!", exception);
            }
            catch (Throwable throwable) {
                ConsoleLogUtils.logcatV(TAG, "final " + (this.getWriteDatabase() == null));
                this.mDatabase.endTransaction();
                this.semaphore.release();
                this.close();
                return l >= 0L;
            }
        }
        this.mDatabase.endTransaction();
        this.semaphore.release();
        this.close();
        return l >= 0L;
    }

    public synchronized boolean insert(T record) throws DbException {
        long l = -1L;
        if (record == null) {
            this.close();
            return -1L >= 0L;
        }
        try {
            ContentValues contentValues;
            if (this.getCurrentSize() >= 0x500000L) {
                ConsoleLogUtils.logcatV(TAG, "Table size is limited, clear half of data!");
                AbstractDatabase abstractDatabase = this;
                AbstractDatabase abstractDatabase2 = this;
                abstractDatabase.deleteOldest(abstractDatabase.getWriteDatabase(), abstractDatabase2.getCount(abstractDatabase2.getWriteDatabase()) / 2);
            }
            contentValues = this.getContentValuesByRecord(contentValues);
            l = this.getWriteDatabase().insert(this.mTableName, null, contentValues);
            if (l < 0L) {
                AbstractDatabase abstractDatabase = this;
                if (abstractDatabase.getCount(abstractDatabase.getWriteDatabase()) > 0) {
                    AbstractDatabase abstractDatabase3 = this;
                    AbstractDatabase abstractDatabase4 = this;
                    abstractDatabase3.deleteOldest(abstractDatabase3.getWriteDatabase(), abstractDatabase4.getCount(abstractDatabase4.getWriteDatabase()) / 2);
                    l = this.getWriteDatabase().insert(this.mTableName, null, contentValues);
                }
            }
            ConsoleLogUtils.logcatV(TAG, "insert: id=" + l);
            this.close();
            return l >= 0L;
        }
        catch (Exception exception) {
            try {
                throw new DbException("Insert record failed!", exception);
            }
            catch (Throwable throwable) {
                this.close();
                return l >= 0L;
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized List<T> query(int limit, int uploadFlag, String orderBy) {
        try {
            Object object;
            String string = "";
            String string2 = null;
            String[] stringArray = null;
            if (uploadFlag >= 0) {
                void var2_4;
                stringArray = new String[]{String.valueOf((int)var2_4)};
                string2 = "upload_flag = ?";
            }
            ConsoleLogUtils.logcatV(TAG, "query: selection=" + string2);
            if (limit > 0) {
                void var1_1;
                string = String.valueOf((int)var1_1);
            }
            ArrayList<T> arrayList = new ArrayList<T>();
            Cursor cursor = this.getReadDatabase().query(this.mTableName, null, string2, stringArray, null, null, (String)object, string);
            while (cursor.moveToNext()) {
                object = this.parseDataFromCursor(cursor);
                if (object == null) continue;
                arrayList.add(object);
            }
            cursor.close();
            ConsoleLogUtils.logcatV(TAG, "query: result=" + arrayList + ", size=" + arrayList.size());
            object = arrayList;
            return object;
        }
        catch (Throwable throwable) {
            return null;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized List<T> queryFailed(long startId, long maxId, int limit) {
        try {
            String string = "";
            StringBuilder stringBuilder = new StringBuilder();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("1");
            stringBuilder.append("upload_flag = ?");
            if (startId >= 0L && maxId >= 0L && maxId >= startId) {
                arrayList.add(String.valueOf(startId));
                arrayList.add(String.valueOf(maxId));
                stringBuilder.append(" and _id").append(" between ? and ?");
            } else if (startId >= 0L) {
                void var1_1;
                arrayList.add(String.valueOf((long)var1_1));
                stringBuilder.append(" and _id").append(" >= ?");
            } else if (maxId >= 0L) {
                void var3_4;
                arrayList.add(String.valueOf((long)var3_4));
                stringBuilder.append(" and _id").append(" <= ?");
            }
            ConsoleLogUtils.logcatV(TAG, "query: selection=" + stringBuilder);
            if (limit > 0) {
                string = String.valueOf(limit);
            }
            Cursor cursor = new String[arrayList.size()];
            arrayList.toArray((T[])cursor);
            ArrayList<T> arrayList2 = new ArrayList<T>();
            cursor = this.getReadDatabase().query(this.mTableName, null, stringBuilder.toString(), (String[])cursor, null, null, "_id ASC", string);
            while (cursor.moveToNext()) {
                T t = this.parseDataFromCursor(cursor);
                if (t == null) continue;
                arrayList2.add(t);
            }
            cursor.close();
            ConsoleLogUtils.logcatV(TAG, "query: result=" + arrayList2 + ", size=" + arrayList2.size());
            ArrayList<T> arrayList3 = arrayList2;
            return arrayList3;
        }
        catch (Throwable throwable) {
            return null;
        }
        finally {
            this.close();
        }
    }

    public synchronized long queryFailedMaxId() {
        try {
            Cursor cursor = this.getReadDatabase().query(true, this.mTableName, new String[]{"_id"}, "upload_flag=?", new String[]{"1"}, null, null, "_id desc", null);
            cursor.moveToFirst();
            long l = cursor.getLong(0);
            cursor.close();
            return l;
        }
        catch (Throwable throwable) {
            return -1L;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @SuppressLint(value={"Range"})
    private long parseIdFromCursor(Cursor cursor) {
        void var1_1;
        if (cursor == null) {
            return -1L;
        }
        void v0 = var1_1;
        return v0.getLong(v0.getColumnIndex("_id"));
    }

    public synchronized boolean deleteRecords(List<T> records) throws DbException {
        try {
            Iterator iterator;
            if (records == null || records.isEmpty()) {
                return true;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                ACMRecord aCMRecord = (ACMRecord)iterator.next();
                arrayList.add(aCMRecord.getId());
            }
            AbstractDatabase abstractDatabase = this;
            boolean bl = abstractDatabase.deleteRecordsById(abstractDatabase.getWriteDatabase(), arrayList);
            return bl;
        }
        catch (DbException dbException) {
            DbException dbException2 = dbException;
            throw dbException;
        }
        finally {
            this.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public synchronized boolean deleteRecordsById(SQLiteDatabase database, List<Long> records) throws DbException {
        try {
            void var2_3;
            void var1_1;
            if (records == null || records.isEmpty()) {
                return true;
            }
            ConsoleLogUtils.logcatV(TAG, "delete: size=" + records.size());
            StringBuilder stringBuilder = new StringBuilder("_id in ").append(this.contactIds(records.size()));
            ConsoleLogUtils.logcatV(TAG, "delete: selection=" + stringBuilder);
            String[] stringArray = new String[records.size()];
            this.numberList2StringArray(records, stringArray);
            int n = var1_1.delete(this.mTableName, stringBuilder.toString(), stringArray);
            ConsoleLogUtils.logcatV(TAG, "delete: count=" + n);
            return n == var2_3.size();
        }
        catch (Exception exception) {
            throw new DbException("Delete records failed!", exception);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected synchronized boolean deleteOldest(SQLiteDatabase database, int limit) throws DbException {
        try {
            void var2_2;
            long l = System.currentTimeMillis();
            Cursor cursor = database.query(this.mTableName, new String[]{"_id"}, null, null, null, null, "timestamp ASC", limit > 0 ? String.valueOf((int)var2_2) : null);
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (cursor.moveToNext()) {
                Long l2 = this.parseIdFromCursor(cursor);
                if (l2 == -1L) continue;
                arrayList.add(l2);
            }
            cursor.close();
            ConsoleLogUtils.logcatV(TAG, "delete oldest: escape=" + (System.currentTimeMillis() - l));
            if (!arrayList.isEmpty()) {
                void var1_1;
                return this.deleteRecordsById((SQLiteDatabase)var1_1, arrayList);
            }
        }
        catch (Exception exception) {
            new DbException("Delete oldest exception!", exception);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void updateUploadCount(List<T> records, long time, int uploadFlag) throws DbException {
        try {
            void var2_3;
            Object[] objectArray;
            Object object;
            if (records == null || records.size() == 0) {
                return;
            }
            ArrayList<Long> arrayList = new ArrayList<Long>();
            object = object.iterator();
            while (object.hasNext()) {
                objectArray = (ACMRecord)object.next();
                arrayList.add(objectArray.getId());
            }
            object = new ArrayList<String>();
            ((ArrayList)object).add(String.valueOf((long)var2_3));
            ((ArrayList)object).add(String.valueOf(uploadFlag));
            ((ArrayList)object).add("1");
            for (Long l : arrayList) {
                ((ArrayList)object).add(String.valueOf(l));
            }
            objectArray = new String[((ArrayList)object).size()];
            String string = String.format("Update %s SET %s=?, %s=?, %s= %s+? where %s in %s", this.mTableName, "timestamp", "upload_flag", "upload_count", "upload_count", "_id", this.contactIds(arrayList.size()));
            ((ArrayList)object).toArray(objectArray);
            this.getWriteDatabase().execSQL(string, objectArray);
            return;
        }
        catch (Throwable throwable) {
            throw new DbException("Update upload count failed!", throwable);
        }
        finally {
            this.close();
        }
    }

    protected abstract T parseDataFromCursor(Cursor var1);

    protected abstract ContentValues getContentValuesByRecord(T var1);

    private <G> void numberList2StringArray(List<G> numberList, String[] results) {
        if (numberList.size() != results.length) {
            Log.e((String)TAG, (String)("NumberList size(" + numberList.size() + ") not equals results length[" + results.length + "]"));
            return;
        }
        for (int i = 0; i < results.length; ++i) {
            results[i] = String.valueOf(numberList.get(i));
        }
    }
}

