/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.logger.upload;

import android.content.Context;
import com.nirvana.tools.logger.cache.ACMMonitorCacheManager;
import com.nirvana.tools.logger.cache.db.DbException;
import com.nirvana.tools.logger.executor.AbstractSafeRunnable;
import com.nirvana.tools.logger.executor.ReentrantSingleThreadExecutor;
import com.nirvana.tools.logger.executor.Timer;
import com.nirvana.tools.logger.model.ACMMonitorRecord;
import com.nirvana.tools.logger.upload.ACMUpload;
import com.nirvana.tools.logger.upload.AbstractACMUploadManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class ACMMonitorUploadManager
extends AbstractACMUploadManager<ACMMonitorRecord> {
    private ACMMonitorCacheManager mCacheManager;
    private static final int MAX_RETRY_COUNT = 2;
    private Timer mNormalLooperTimer;
    private volatile int mUploadType = 1;

    /*
     * WARNING - void declaration
     */
    public ACMMonitorUploadManager(Context context, ACMMonitorCacheManager cacheManager, ACMUpload<ACMMonitorRecord> uploader, ReentrantSingleThreadExecutor executor) {
        super((Context)var1_1, var3_3, cacheManager, executor);
        void var2_2;
        void var3_3;
        void var1_1;
        this.mCacheManager = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public void setUploadType(int uploadType) {
        void var1_1;
        this.mUploadType = var1_1;
    }

    public void startLoop() {
        if (this.mUploadType != 2) {
            return;
        }
        if (this.mNormalLooperTimer != null && this.mNormalLooperTimer.isWorking()) {
            return;
        }
        if (this.mNormalLooperTimer != null) {
            this.mNormalLooperTimer.resume();
            return;
        }
        this.mNormalLooperTimer = new Timer(12000L, new AbstractSafeRunnable(this){
            final /* synthetic */ ACMMonitorUploadManager this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void safeRun() {
                if (this.this$0.isAllowUploading()) {
                    Object object = this.this$0.mCacheManager.getNormalMonitorRecords(this.this$0.maxUploadSize);
                    try {
                        this.this$0.doUploadRecords(object);
                    }
                    catch (DbException dbException) {
                        object = dbException;
                        dbException.printStackTrace();
                        this.this$0.stopLoop();
                    }
                    if (!this.this$0.mCacheManager.hasNormalRecords()) {
                        this.this$0.mNormalLooperTimer.pause();
                    }
                }
            }
        });
    }

    public void stopLoop() {
        if (this.mNormalLooperTimer != null && this.mNormalLooperTimer.isWorking()) {
            this.mNormalLooperTimer.quit();
            this.mNormalLooperTimer = null;
        }
    }

    public void uploadManual() {
        this.stopLoop();
        this.uploadMonitorByPage();
    }

    private void uploadMonitorByPage() {
        AbstractSafeRunnable abstractSafeRunnable = new AbstractSafeRunnable(this){
            final /* synthetic */ ACMMonitorUploadManager this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public void safeRun() {
                Object object;
                int n = 0;
                while (this.this$0.isAllowUploading() && (long)n < this.this$0.maxUploadRetry && (object = this.this$0.mCacheManager.getNormalMonitorRecords(this.this$0.maxUploadSize)) != null && object.size() > 0) {
                    try {
                        this.this$0.doUploadRecords(object);
                    }
                    catch (DbException dbException) {
                        object = dbException;
                        dbException.printStackTrace();
                        return;
                    }
                    ++n;
                }
            }
        };
        this.mExecutor.execute(abstractSafeRunnable);
    }

    @Override
    protected void processUploadingFailed(List<ACMMonitorRecord> records) throws DbException {
        Iterator iterator;
        ArrayList<ACMMonitorRecord> arrayList = new ArrayList<ACMMonitorRecord>();
        ArrayList<ACMMonitorRecord> arrayList2 = new ArrayList<ACMMonitorRecord>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            ACMMonitorRecord aCMMonitorRecord = (ACMMonitorRecord)iterator.next();
            if (aCMMonitorRecord.getUrgency() == 1 || aCMMonitorRecord.getUploadCount() >= 2) {
                arrayList.add(aCMMonitorRecord);
                continue;
            }
            arrayList2.add(aCMMonitorRecord);
        }
        this.mCacheManager.deleteRecords(arrayList);
        this.mCacheManager.addUploadCount(arrayList2);
    }
}

