/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.logger.upload;

import android.content.Context;
import com.nirvana.tools.logger.cache.ACMCacheManager;
import com.nirvana.tools.logger.cache.db.AbstractDatabase;
import com.nirvana.tools.logger.cache.db.DbException;
import com.nirvana.tools.logger.executor.AbstractSafeRunnable;
import com.nirvana.tools.logger.executor.ReentrantSingleThreadExecutor;
import com.nirvana.tools.logger.model.ACMLimitConfig;
import com.nirvana.tools.logger.model.ACMRecord;
import com.nirvana.tools.logger.upload.ACMUpload;
import com.nirvana.tools.logger.upload.inteceptor.BaseInterceptor;
import com.nirvana.tools.logger.upload.inteceptor.EnableInterceptor;
import com.nirvana.tools.logger.upload.inteceptor.LimitInterceptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractACMUploadManager<T extends ACMRecord> {
    protected static final long TIME_INTERVAL = 12000L;
    protected static final long MAX_TURNS_FOR_SINGLE_UPLOAD = 100L;
    private static final int UPLOAD_RETRY_MAX_COUNT = 1;
    protected static final int PAGE_SIZE = 20;
    protected ReentrantSingleThreadExecutor mExecutor;
    protected ACMUpload<T> mUploader;
    protected ACMCacheManager<T, ? extends AbstractDatabase<T>> mCacheManager;
    protected Map<Class, BaseInterceptor> mInterceptors = new HashMap<Class, BaseInterceptor>();
    private EnableInterceptor mEnableInterceptor;
    protected Context mContext;
    private boolean isUploadingFailed;
    private Object mFailedLock = new Object();
    protected int maxUploadSize = 0;
    protected long maxUploadRetry = 0L;
    private int retryCount = 0;

    /*
     * WARNING - void declaration
     */
    public AbstractACMUploadManager(Context context, ACMUpload<T> uploader, ACMCacheManager<T, ? extends AbstractDatabase<T>> cacheManager, ReentrantSingleThreadExecutor executor) {
        void var3_3;
        void var2_2;
        LimitInterceptor limitInterceptor;
        this.mContext = limitInterceptor;
        this.mUploader = var2_2;
        this.mCacheManager = var3_3;
        this.mExecutor = executor;
        limitInterceptor = LimitInterceptor.getInstance(this.mContext);
        this.mInterceptors.put(LimitInterceptor.class, limitInterceptor);
        this.maxUploadSize = 20;
        this.maxUploadRetry = 100L;
        this.retryCount = 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uploadFailed() {
        Object object = this.mFailedLock;
        synchronized (object) {
            if (this.isUploadingFailed) {
                return;
            }
            this.isUploadingFailed = true;
            AbstractSafeRunnable abstractSafeRunnable = new AbstractSafeRunnable(this){
                final /* synthetic */ AbstractACMUploadManager this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                public void safeRun() {
                    if (this.this$0.mCacheManager.hasFailedRecords()) {
                        this.this$0.mExecutor.execute(new AbstractSafeRunnable(this){
                            final /* synthetic */ 1 this$1;
                            {
                                void var1_1;
                                this.this$1 = var1_1;
                            }

                            @Override
                            public void safeRun() {
                                List list;
                                long l = this.this$1.this$0.mCacheManager.getFailedMaxID();
                                long l2 = 0L;
                                int n = 0;
                                while (this.this$1.this$0.isAllowUploading() && (long)n < this.this$1.this$0.maxUploadRetry && (list = this.this$1.this$0.mCacheManager.getFailedRecords(l2, l, this.this$1.this$0.maxUploadSize)) != null && list.size() > 0) {
                                    try {
                                        this.this$1.this$0.doUploadRecords(list);
                                    }
                                    catch (DbException dbException) {
                                        break;
                                    }
                                    List list2 = list;
                                    l2 = ((ACMRecord)list2.get(list2.size() - 1)).getId() + 1L;
                                    ++n;
                                }
                                AbstractACMUploadManager.access$002(this.this$1.this$0, false);
                            }
                        });
                    }
                }
            };
            this.mExecutor.execute(abstractSafeRunnable);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setUploadEnable(boolean enable) {
        void var1_1;
        if (this.mEnableInterceptor == null) {
            this.mEnableInterceptor = new EnableInterceptor();
        }
        this.mEnableInterceptor.setEnabled((boolean)var1_1);
        this.mInterceptors.put(EnableInterceptor.class, this.mEnableInterceptor);
    }

    public boolean isAllowUploading() {
        if (this.mInterceptors == null || this.mInterceptors.size() == 0) {
            return true;
        }
        for (BaseInterceptor baseInterceptor : this.mInterceptors.values()) {
            if (baseInterceptor.isAllowUploading()) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxUploadSize(int maxUploadSize) {
        void var1_1;
        this.maxUploadSize = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxUploadRetry(long maxUploadRetry) {
        void var1_1;
        this.maxUploadRetry = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setRetryCount(int retryCount) {
        void var1_1;
        this.retryCount = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void deleteRecordsByFlag(int deleteFlag) {
        void var1_1;
        List<T> list = deleteFlag == 1 ? this.mCacheManager.getAllFailedRecords() : (var1_1 == 2 ? this.mCacheManager.getUnUploadRecords() : this.mCacheManager.getAllRecords());
        if (list != null && list.size() > 0) {
            try {
                this.mCacheManager.deleteRecords(list);
                return;
            }
            catch (DbException dbException) {
                list = dbException;
                dbException.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected boolean doUploadRecords(List<T> records) throws DbException {
        if (records != null && records.size() > 0) {
            boolean bl = false;
            for (int i = 0; i <= this.retryCount; ++i) {
                if (!this.isAllowUploading()) {
                    return true;
                }
                LimitInterceptor.getInstance(this.mContext).addLimitCount();
                bl = this.mUploader.upload(records);
                if (!bl) continue;
                this.mCacheManager.deleteRecords(records);
                break;
            }
            if (!bl) {
                void var1_1;
                this.processUploadingFailed((List<T>)var1_1);
                return false;
            }
            return true;
        }
        return true;
    }

    protected abstract void processUploadingFailed(List<T> var1) throws DbException;

    /*
     * WARNING - void declaration
     */
    public void setLimitConfig(ACMLimitConfig config) {
        void var1_1;
        LimitInterceptor limitInterceptor = LimitInterceptor.getInstance(this.mContext);
        limitInterceptor.setConfig((ACMLimitConfig)var1_1);
        this.mInterceptors.put(LimitInterceptor.class, limitInterceptor);
    }

    public void clearLimitConfig() {
        LimitInterceptor limitInterceptor = (LimitInterceptor)this.mInterceptors.remove(LimitInterceptor.class);
        if (limitInterceptor != null) {
            limitInterceptor.clearLimitInfo();
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ boolean access$002(AbstractACMUploadManager x0, boolean x1) {
        void var1_1;
        x0.isUploadingFailed = var1_1;
        return x0.isUploadingFailed;
    }
}

