/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.core;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.text.TextUtils;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;

public class AppUtils {
    private static String PACKAGE_NAME = null;
    private static String APP_NAME = null;
    private static String APP_VERSION_NAME = null;
    private static String APP_SIGNATURE = null;
    private static final char[] HEX_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    private static void setupAppInfo(Context context) {
        if (PACKAGE_NAME == null || APP_VERSION_NAME == null) {
            try {
                Context context2;
                context2 = context.getPackageManager().getPackageInfo(context2.getPackageName(), 0);
                APP_VERSION_NAME = context2.versionName;
                PACKAGE_NAME = context2.packageName;
                return;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public static synchronized String getAppName(Context context) {
        if (APP_NAME == null) {
            Context context2;
            ApplicationInfo applicationInfo = context.getApplicationInfo();
            APP_NAME = applicationInfo.labelRes == 0 ? applicationInfo.nonLocalizedLabel.toString() : context2.getResources().getString(applicationInfo.labelRes);
        }
        return APP_NAME;
    }

    public static synchronized String getVersionName(Context context) {
        AppUtils.setupAppInfo(context);
        return APP_VERSION_NAME;
    }

    public static synchronized String getPackageName(Context context) {
        AppUtils.setupAppInfo(context);
        return PACKAGE_NAME;
    }

    public static synchronized String getSign(Context context) {
        try {
            if (APP_SIGNATURE == null) {
                Context context2;
                APP_SIGNATURE = AppUtils.hexdigest(context.getPackageManager().getPackageInfo((String)AppUtils.getPackageName((Context)context2), (int)64).signatures[0].toByteArray());
            }
            return APP_SIGNATURE;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "";
        }
    }

    public static String hexdigest(byte[] paramArrayOfByte) {
        try {
            byte[] byArray;
            Object object = MessageDigest.getInstance("MD5");
            ((MessageDigest)object).update(byArray);
            byArray = ((MessageDigest)object).digest();
            object = new char[32];
            int n = 0;
            int n2 = 0;
            while (true) {
                if (n >= 16) {
                    return new String((char[])object);
                }
                byte by = byArray[n];
                int n3 = n2 + 1;
                object[n2] = HEX_DIGITS[0xF & by >>> 4];
                n2 = n3 + 1;
                object[n3] = HEX_DIGITS[by & 0xF];
                ++n;
            }
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static String getTime() {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        Date date = new Date(System.currentTimeMillis());
        return simpleDateFormat.format(date);
    }

    public static long date2ms(String data) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5 HH:mm:ss");
        try {
            String string;
            return simpleDateFormat.parse(string).getTime();
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int dp2px(Context context, float dipValue) {
        try {
            float f = context.getResources().getDisplayMetrics().density;
            return (int)(dipValue * f + 0.5f);
        }
        catch (Exception exception) {
            void var1_2;
            return (int)var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int sp2px(Context context, float spValue) {
        try {
            float f = context.getResources().getDisplayMetrics().scaledDensity;
            return (int)(spValue * f + 0.5f);
        }
        catch (Exception exception) {
            void var1_2;
            return (int)var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    public static int getResID(Context context, String name, String defType) {
        Context context2;
        void var2_2;
        void var1_1;
        return context.getResources().getIdentifier((String)var1_1, (String)var2_2, context2.getPackageName());
    }

    /*
     * WARNING - void declaration
     */
    public static int getAnimResID(Context context, String name) {
        Context context2;
        void var1_1;
        if (TextUtils.isEmpty((CharSequence)name)) {
            return 0;
        }
        return context.getResources().getIdentifier((String)var1_1, "anim", context2.getPackageName());
    }

    public static String getDeviceName() {
        return Build.BRAND + ":" + Build.MODEL;
    }

    public static String getSystemVersion() {
        return Build.VERSION.RELEASE;
    }

    public static int getSystemAPILevel() {
        return Build.VERSION.SDK_INT;
    }

    public static String getHstype() {
        if (Build.MODEL.length() > 20) {
            return Build.MODEL.substring(0, 20);
        }
        return Build.MODEL;
    }
}

