/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.core;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.NonNull;
import com.nirvana.tools.core.Worker;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class ExecutorManager {
    private static final String TAG = "NIRVANA_EXECUTOR";
    private ScheduledThreadPoolExecutor threadExecutor;
    private Handler mMainHandler;
    private HashMap<String, Worker> mWorkerQueue = new HashMap();
    private static volatile ExecutorManager mInstance;
    private static final int CORE_POOL_SIZE = 4;
    private static final int MAX_POOL_SIZE = 4;

    public ExecutorManager() {
        this.threadExecutor = new ScheduledThreadPoolExecutor(4, new ThreadFactory(this){
            final /* synthetic */ ExecutorManager this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Thread newThread(@NonNull Runnable runnable) {
                void var1_1;
                return new Thread((Runnable)var1_1, "nirvana_base_executor_queue_" + System.currentTimeMillis());
            }
        }, new ThreadPoolExecutor.CallerRunsPolicy());
        this.threadExecutor.setKeepAliveTime(2L, TimeUnit.SECONDS);
        this.threadExecutor.setMaximumPoolSize(4);
        this.threadExecutor.allowCoreThreadTimeOut(true);
        this.mMainHandler = new Handler(Looper.getMainLooper());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ExecutorManager getInstance() {
        if (mInstance != null) return mInstance;
        Class<ThreadPoolExecutor> clazz = ThreadPoolExecutor.class;
        synchronized (ThreadPoolExecutor.class) {
            if (mInstance != null) return mInstance;
            mInstance = new ExecutorManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return mInstance;
        }
    }

    /*
     * WARNING - void declaration
     */
    public RunnableScheduledFuture<?> scheduleFutureDelay(Runnable runnable, long delayed) {
        void var2_2;
        void var1_1;
        if (delayed < 0L) {
            delayed = 0L;
        }
        return (RunnableScheduledFuture)this.threadExecutor.schedule((Runnable)var1_1, (long)var2_2, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public RunnableScheduledFuture<?> scheduleFuture(Runnable runnable) {
        void var1_1;
        return this.scheduleFutureDelay((Runnable)var1_1, 0L);
    }

    /*
     * WARNING - void declaration
     */
    public void postMain(Runnable runnable) {
        void var1_1;
        this.mMainHandler.post((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void postMain(Runnable runnable, long delayed) {
        void var2_2;
        void var1_1;
        this.mMainHandler.postDelayed((Runnable)var1_1, (long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFromMain(Runnable runnable) {
        void var1_1;
        this.mMainHandler.removeCallbacks((Runnable)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void removeFromThread(Runnable runnable) {
        void var1_1;
        this.threadExecutor.remove((Runnable)var1_1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Worker registerWorker(String workerId) {
        HashMap<String, Worker> hashMap = this.mWorkerQueue;
        synchronized (hashMap) {
            void var1_1;
            if (this.mWorkerQueue.containsKey(workerId)) {
                return this.getWorker(workerId);
            }
            Worker worker = new Worker(workerId);
            this.mWorkerQueue.put((String)var1_1, worker);
            return worker;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public Worker getWorker(String workerId) {
        HashMap<String, Worker> hashMap = this.mWorkerQueue;
        synchronized (hashMap) {
            void var1_1;
            return this.mWorkerQueue.get(var1_1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quitWorker(String workerId) {
        HashMap<String, Worker> hashMap = this.mWorkerQueue;
        synchronized (hashMap) {
            Worker worker;
            worker = this.mWorkerQueue.remove(worker);
            if (worker != null) {
                worker.release();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void quitWorker(Worker worker) {
        if (worker != null) {
            void var1_1;
            this.quitWorker(var1_1.getWorkerId());
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        if (mInstance != null) {
            Class<ThreadPoolExecutor> clazz = ThreadPoolExecutor.class;
            synchronized (ThreadPoolExecutor.class) {
                if (mInstance != null) {
                    ExecutorManager.mInstance.threadExecutor.shutdown();
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }

    public static String getErrorInfoFromException(Throwable e) {
        try {
            String string;
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            ((Throwable)((Object)string)).printStackTrace(printWriter);
            string = stringWriter.toString();
            stringWriter.close();
            printWriter.close();
            return string;
        }
        catch (Exception exception) {
            return "ErrorInfoFromException";
        }
    }

    public static abstract class SafeRunnable
    implements Runnable {
        protected abstract void safeRun();

        protected void onException(Throwable e) {
        }

        protected void onFinal() {
        }

        @Override
        public void run() {
            try {
                this.safeRun();
                return;
            }
            catch (Throwable throwable) {
                this.onException(throwable);
                return;
            }
            finally {
                this.onFinal();
            }
        }
    }
}

