/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.core;

import android.content.ContentResolver;
import android.content.Context;
import android.net.ConnectivityManager;
import android.os.Build;
import android.provider.Settings;
import android.telephony.TelephonyManager;
import android.util.Log;
import java.lang.reflect.Method;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.Enumeration;

public class NetworkUtils {
    public static boolean isMobileNetworkOpen(Context context) {
        if (!NetworkUtils.hasSimCard(context)) {
            return false;
        }
        if (NetworkUtils.isAirModeEnable(context)) {
            return false;
        }
        if (NetworkUtils.isMobileNetConnected(context)) {
            return true;
        }
        try {
            Context context2;
            context2 = (ConnectivityManager)context2.getApplicationContext().getSystemService("connectivity");
            Method method = ConnectivityManager.class.getDeclaredMethod("getMobileDataEnabled", new Class[0]);
            method.setAccessible(true);
            return (Boolean)method.invoke((Object)context2, new Object[0]);
        }
        catch (Exception exception) {
            Log.e((String)"NetworkUtils", (String)exception.getMessage());
            return true;
        }
    }

    public static boolean hasSimCard(Context context) {
        return ((TelephonyManager)context.getSystemService("phone")).getSimState() == 5;
    }

    public static String getLocalIPAddress() {
        try {
            Enumeration<NetworkInterface> enumeration = NetworkInterface.getNetworkInterfaces();
            while (enumeration.hasMoreElements()) {
                Enumeration<InetAddress> enumeration2 = enumeration.nextElement().getInetAddresses();
                while (enumeration2.hasMoreElements()) {
                    InetAddress inetAddress = enumeration2.nextElement();
                    if (inetAddress.isLoopbackAddress() || !(inetAddress instanceof Inet4Address)) continue;
                    return inetAddress.getHostAddress();
                }
            }
        }
        catch (Exception exception) {
            Log.e((String)"NetworkUtils", (String)exception.getMessage());
        }
        return "";
    }

    public static boolean isMobileNetConnected(Context context) {
        if (context != null) {
            Context context2;
            return (context2 = ((ConnectivityManager)context2.getSystemService("connectivity")).getNetworkInfo(0)) != null && context2.isAvailable() && context2.isConnected();
        }
        return false;
    }

    public static boolean isAirModeEnable(Context context) {
        boolean bl = false;
        try {
            Context context2;
            bl = Build.VERSION.SDK_INT < 17 ? Settings.System.getInt((ContentResolver)context.getContentResolver(), (String)"airplane_mode_on", (int)0) == 1 : Settings.Global.getInt((ContentResolver)context2.getContentResolver(), (String)"airplane_mode_on", (int)0) == 1;
        }
        catch (Throwable throwable) {
            Log.e((String)"NetworkUtils", (String)throwable.getMessage());
        }
        return bl;
    }
}

