/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.jsoner;

import com.nirvana.tools.jsoner.JsonPreconditions;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Properties;

public final class JsonHelper {
    static final Type[] EMPTY_TYPE_ARRAY = new Type[0];

    private JsonHelper() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    public static ParameterizedType newParameterizedTypeWithOwner(Type ownerType, Type rawType, Type ... typeArguments) {
        void var2_2;
        void var1_1;
        Type type;
        return new b(type, (Type)var1_1, (Type[])var2_2);
    }

    public static GenericArrayType arrayOf(Type componentType) {
        Type type;
        return new a(type);
    }

    public static WildcardType subtypeOf(Type bound) {
        Type[] typeArray;
        typeArray = bound instanceof WildcardType ? ((WildcardType)typeArray).getUpperBounds() : new Type[]{typeArray};
        return new c(typeArray, EMPTY_TYPE_ARRAY);
    }

    public static WildcardType supertypeOf(Type bound) {
        Type[] typeArray;
        typeArray = bound instanceof WildcardType ? ((WildcardType)typeArray).getLowerBounds() : new Type[]{typeArray};
        return new c(new Type[]{Object.class}, typeArray);
    }

    public static Type canonicalize(Type type) {
        Type type2;
        if (type instanceof Class) {
            return ((Class)(type2 = (Class)type2)).isArray() ? new a(JsonHelper.canonicalize(((Class)type2).getComponentType())) : type2;
        }
        if (type2 instanceof ParameterizedType) {
            type2 = (ParameterizedType)type2;
            return new b(type2.getOwnerType(), type2.getRawType(), type2.getActualTypeArguments());
        }
        if (type2 instanceof GenericArrayType) {
            type2 = (GenericArrayType)type2;
            return new a(type2.getGenericComponentType());
        }
        if (type2 instanceof WildcardType) {
            type2 = (WildcardType)type2;
            return new c(type2.getUpperBounds(), type2.getLowerBounds());
        }
        return type2;
    }

    public static Class<?> getRawType(Type type) {
        Type type2;
        while (true) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof ParameterizedType) {
                type2 = ((ParameterizedType)type2).getRawType();
                JsonPreconditions.checkArgument(type2 instanceof Class);
                return (Class)type2;
            }
            if (type2 instanceof GenericArrayType) {
                return Array.newInstance(JsonHelper.getRawType(((GenericArrayType)type2).getGenericComponentType()), 0).getClass();
            }
            if (type2 instanceof TypeVariable) {
                return Object.class;
            }
            if (!(type2 instanceof WildcardType)) break;
            type2 = ((WildcardType)type2).getUpperBounds()[0];
        }
        String string = type2 == null ? "null" : type2.getClass().getName();
        throw new IllegalArgumentException("Expected a Class, ParameterizedType, or GenericArrayType, but <" + type2 + "> is of type " + string);
    }

    /*
     * WARNING - void declaration
     */
    static boolean equal(Object a2, Object b2) {
        void var1_1;
        Object object;
        return a2 == b2 || a2 != null && object.equals(var1_1);
    }

    public static boolean equals(Type a2, Type b2) {
        Type type;
        Type type2;
        while (true) {
            if (a2 == b2) {
                return true;
            }
            if (a2 instanceof Class) {
                return a2.equals(b2);
            }
            if (a2 instanceof ParameterizedType) {
                if (!(b2 instanceof ParameterizedType)) {
                    return false;
                }
                type2 = (ParameterizedType)type2;
                type = (ParameterizedType)type;
                return JsonHelper.equal(type2.getOwnerType(), type.getOwnerType()) && type2.getRawType().equals(type.getRawType()) && Arrays.equals(type2.getActualTypeArguments(), type.getActualTypeArguments());
            }
            if (!(type2 instanceof GenericArrayType)) break;
            if (!(type instanceof GenericArrayType)) {
                return false;
            }
            type2 = (GenericArrayType)type2;
            type = (GenericArrayType)type;
            type = type.getGenericComponentType();
            type2 = type2.getGenericComponentType();
        }
        if (type2 instanceof WildcardType) {
            if (!(type instanceof WildcardType)) {
                return false;
            }
            type2 = (WildcardType)type2;
            type = (WildcardType)type;
            return Arrays.equals(type2.getUpperBounds(), type.getUpperBounds()) && Arrays.equals(type2.getLowerBounds(), type.getLowerBounds());
        }
        if (type2 instanceof TypeVariable) {
            if (!(type instanceof TypeVariable)) {
                return false;
            }
            type2 = (TypeVariable)type2;
            type = (TypeVariable)type;
            return type2.getGenericDeclaration() == type.getGenericDeclaration() && type2.getName().equals(type.getName());
        }
        return false;
    }

    static int hashCodeOrZero(Object o) {
        if (o != null) {
            Object object;
            return object.hashCode();
        }
        return 0;
    }

    public static String typeToString(Type type) {
        Type type2;
        if (type instanceof Class) {
            return ((Class)type).getName();
        }
        return type2.toString();
    }

    /*
     * WARNING - void declaration
     */
    static Type getGenericSupertype(Type context, Class<?> rawType, Class<?> toResolve) {
        void var2_2;
        block0: while (true) {
            Object object;
            if (toResolve == rawType) {
                return object;
            }
            if (toResolve.isInterface()) {
                object = ((Class)rawType).getInterfaces();
                int n = ((Class<?>[])object).length;
                for (int i = 0; i < n; ++i) {
                    if (object[i] == toResolve) {
                        return ((Class)rawType).getGenericInterfaces()[i];
                    }
                    if (!toResolve.isAssignableFrom(object[i])) continue;
                    Type type = ((Class)rawType).getGenericInterfaces()[i];
                    rawType = object[i];
                    object = type;
                    continue block0;
                }
            }
            if (((Class)rawType).isInterface()) break;
            while (rawType != Object.class) {
                object = ((Class)rawType).getSuperclass();
                if (object == toResolve) {
                    return ((Class)rawType).getGenericSuperclass();
                }
                if (toResolve.isAssignableFrom((Class<?>)object)) {
                    Type type = ((Class)rawType).getGenericSuperclass();
                    rawType = object;
                    object = type;
                    continue block0;
                }
                rawType = object;
            }
            break;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static Type getSupertype(Type context, Class<?> contextRawType, Class<?> supertype) {
        void var2_2;
        void var1_1;
        Type type;
        if (context instanceof WildcardType) {
            context = ((WildcardType)context).getUpperBounds()[0];
        }
        JsonPreconditions.checkArgument(supertype.isAssignableFrom(contextRawType));
        return JsonHelper.resolve(context, contextRawType, JsonHelper.getGenericSupertype(type, var1_1, var2_2));
    }

    public static Type getArrayComponentType(Type array) {
        Type type;
        if (array instanceof GenericArrayType) {
            return ((GenericArrayType)array).getGenericComponentType();
        }
        return ((Class)type).getComponentType();
    }

    /*
     * WARNING - void declaration
     */
    public static Type getCollectionElementType(Type context, Class<?> contextRawType) {
        void var1_1;
        Type type = JsonHelper.getSupertype(context, var1_1, Collection.class);
        if (type instanceof WildcardType) {
            type = ((WildcardType)type).getUpperBounds()[0];
        }
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return Object.class;
    }

    /*
     * WARNING - void declaration
     */
    public static Type[] getMapKeyAndValueTypes(Type context, Class<?> contextRawType) {
        void var1_1;
        Type type;
        if (context == Properties.class) {
            return new Type[]{String.class, String.class};
        }
        if ((type = JsonHelper.getSupertype(type, var1_1, Map.class)) instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return new Type[]{Object.class, Object.class};
    }

    /*
     * WARNING - void declaration
     */
    public static Type resolve(Type context, Class<?> contextRawType, Type toResolve) {
        void var2_2;
        void var1_1;
        return JsonHelper.resolve(context, var1_1, (Type)var2_2, new HashSet<TypeVariable>());
    }

    /*
     * WARNING - void declaration
     */
    private static Type resolve(Type context, Class<?> contextRawType, Type toResolve, Collection<TypeVariable> visitedTypeVariables) {
        Type[] typeArray;
        Type type;
        while (toResolve instanceof TypeVariable) {
            type = (TypeVariable)toResolve;
            if (visitedTypeVariables.contains(type)) {
                return toResolve;
            }
            visitedTypeVariables.add((TypeVariable)type);
            toResolve = JsonHelper.resolveTypeVariable(context, contextRawType, type);
            if (toResolve != type) continue;
            return toResolve;
        }
        if (toResolve instanceof Class && ((Class)toResolve).isArray()) {
            Type type2;
            type = (Class)typeArray;
            if ((typeArray = ((Class)type).getComponentType()) == (type2 = JsonHelper.resolve(context, contextRawType, typeArray, visitedTypeVariables))) {
                return type;
            }
            return JsonHelper.arrayOf(type2);
        }
        if (typeArray instanceof GenericArrayType) {
            Type type3;
            type = (GenericArrayType)typeArray;
            if ((typeArray = type.getGenericComponentType()) == (type3 = JsonHelper.resolve(context, contextRawType, typeArray, visitedTypeVariables))) {
                return type;
            }
            return JsonHelper.arrayOf(type3);
        }
        if (typeArray instanceof ParameterizedType) {
            type = (ParameterizedType)typeArray;
            Type type4 = JsonHelper.resolve(context, contextRawType, typeArray = type.getOwnerType(), visitedTypeVariables);
            boolean bl = type4 != typeArray;
            typeArray = type.getActualTypeArguments();
            int n = typeArray.length;
            for (int i = 0; i < n; ++i) {
                Type type5 = JsonHelper.resolve(context, contextRawType, typeArray[i], visitedTypeVariables);
                if (type5 == typeArray[i]) continue;
                if (!bl) {
                    typeArray = (Type[])typeArray.clone();
                    bl = true;
                }
                typeArray[i] = type5;
            }
            if (bl) {
                return JsonHelper.newParameterizedTypeWithOwner(type4, type.getRawType(), typeArray);
            }
            return type;
        }
        if (typeArray instanceof WildcardType) {
            void var3_3;
            void var1_1;
            Type type6;
            Type type7;
            type = (WildcardType)typeArray;
            typeArray = type.getLowerBounds();
            Type[] typeArray2 = type.getUpperBounds();
            if (typeArray.length == 1) {
                Type type8 = JsonHelper.resolve(context, contextRawType, typeArray[0], visitedTypeVariables);
                if (type8 != typeArray[0]) {
                    return JsonHelper.supertypeOf(type8);
                }
            } else if (typeArray2.length == 1 && (type7 = JsonHelper.resolve(type6, var1_1, typeArray2[0], (Collection<TypeVariable>)var3_3)) != typeArray2[0]) {
                return JsonHelper.subtypeOf(type7);
            }
            return type;
        }
        return typeArray;
    }

    /*
     * WARNING - void declaration
     */
    static Type resolveTypeVariable(Type context, Class<?> contextRawType, TypeVariable<?> unknown) {
        void var2_3;
        void var1_1;
        Type type;
        Class<?> clazz = JsonHelper.declaringClassOf(unknown);
        if (clazz == null) {
            return unknown;
        }
        if ((type = JsonHelper.getGenericSupertype(type, var1_1, clazz)) instanceof ParameterizedType) {
            int n = JsonHelper.indexOf(clazz.getTypeParameters(), unknown);
            return ((ParameterizedType)type).getActualTypeArguments()[n];
        }
        return var2_3;
    }

    private static int indexOf(Object[] array, Object toFind) {
        int n = array.length;
        for (int i = 0; i < n; ++i) {
            if (!toFind.equals(array[i])) continue;
            return i;
        }
        throw new NoSuchElementException();
    }

    private static Class<?> declaringClassOf(TypeVariable<?> typeVariable) {
        TypeVariable<?> typeVariable2 = typeVariable.getGenericDeclaration();
        if (typeVariable2 instanceof Class) {
            return (Class)((Object)typeVariable2);
        }
        return null;
    }

    static void checkNotPrimitive(Type type) {
        Type type2;
        JsonPreconditions.checkArgument(!(type instanceof Class) || !((Class)type2).isPrimitive());
    }

    static final class c
    implements Serializable,
    WildcardType {
        private final Type a;
        private final Type b;

        public c(Type[] typeArray, Type[] typeArray2) {
            JsonPreconditions.checkArgument(typeArray2.length <= 1);
            JsonPreconditions.checkArgument(typeArray.length == 1);
            if (typeArray2.length == 1) {
                JsonPreconditions.checkNotNull(typeArray2[0]);
                JsonHelper.checkNotPrimitive(typeArray2[0]);
                JsonPreconditions.checkArgument(typeArray[0] == Object.class);
                this.b = JsonHelper.canonicalize(typeArray2[0]);
                this.a = Object.class;
                return;
            }
            JsonPreconditions.checkNotNull(typeArray[0]);
            JsonHelper.checkNotPrimitive(typeArray[0]);
            this.b = null;
            this.a = JsonHelper.canonicalize(typeArray[0]);
        }

        @Override
        public final Type[] getUpperBounds() {
            return new Type[]{this.a};
        }

        @Override
        public final Type[] getLowerBounds() {
            if (this.b != null) {
                return new Type[]{this.b};
            }
            return EMPTY_TYPE_ARRAY;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof WildcardType && JsonHelper.equals(this, (WildcardType)var1_1);
        }

        public final int hashCode() {
            return (this.b != null ? 31 + this.b.hashCode() : 1) ^ 31 + this.a.hashCode();
        }

        public final String toString() {
            if (this.b != null) {
                return "? super " + JsonHelper.typeToString(this.b);
            }
            if (this.a == Object.class) {
                return "?";
            }
            return "? extends " + JsonHelper.typeToString(this.a);
        }
    }

    static final class a
    implements Serializable,
    GenericArrayType {
        private final Type a;

        public a(Type type) {
            this.a = JsonHelper.canonicalize(type);
        }

        @Override
        public final Type getGenericComponentType() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object o) {
            void var1_1;
            return o instanceof GenericArrayType && JsonHelper.equals(this, (GenericArrayType)var1_1);
        }

        public final int hashCode() {
            return this.a.hashCode();
        }

        public final String toString() {
            return JsonHelper.typeToString(this.a) + "[]";
        }
    }

    static final class b
    implements Serializable,
    ParameterizedType {
        private final Type a;
        private final Type b;
        private final Type[] c;

        public b(Type type, Type type2, Type ... typeArray) {
            int n;
            if (type2 instanceof Class) {
                Class clazz = (Class)type2;
                n = Modifier.isStatic(clazz.getModifiers()) || clazz.getEnclosingClass() == null ? 1 : 0;
                JsonPreconditions.checkArgument(type != null || n != 0);
            }
            this.a = type == null ? null : JsonHelper.canonicalize(type);
            this.b = JsonHelper.canonicalize(type2);
            this.c = (Type[])typeArray.clone();
            n = this.c.length;
            for (int i = 0; i < n; ++i) {
                JsonPreconditions.checkNotNull(this.c[i]);
                JsonHelper.checkNotPrimitive(this.c[i]);
                this.c[i] = JsonHelper.canonicalize(this.c[i]);
            }
        }

        @Override
        public final Type[] getActualTypeArguments() {
            return (Type[])this.c.clone();
        }

        @Override
        public final Type getRawType() {
            return this.b;
        }

        @Override
        public final Type getOwnerType() {
            return this.a;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean equals(Object other) {
            void var1_1;
            return other instanceof ParameterizedType && JsonHelper.equals(this, (ParameterizedType)var1_1);
        }

        public final int hashCode() {
            return Arrays.hashCode(this.c) ^ this.b.hashCode() ^ JsonHelper.hashCodeOrZero(this.a);
        }

        public final String toString() {
            int n = this.c.length;
            if (n == 0) {
                return JsonHelper.typeToString(this.b);
            }
            StringBuilder stringBuilder = new StringBuilder(30 * (n + 1));
            stringBuilder.append(JsonHelper.typeToString(this.b)).append("<").append(JsonHelper.typeToString(this.c[0]));
            for (int i = 1; i < n; ++i) {
                stringBuilder.append(", ").append(JsonHelper.typeToString(this.c[i]));
            }
            return stringBuilder.append(">").toString();
        }
    }
}

