/*
 * Decompiled with CFR 0.152.
 */
package com.nirvana.tools.jsoner;

import com.nirvana.tools.jsoner.JsonHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;

public class JsonType<T> {
    private Class<? super T> mGenericsClz;
    private Constructor mConstructor;

    public T newInstance() {
        if (this.mConstructor == null) {
            this.setup();
        }
        if (this.mConstructor != null) {
            try {
                this.mConstructor.setAccessible(true);
                return this.mConstructor.newInstance(new Object[0]);
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
        return null;
    }

    private void setup() {
        Type type = JsonType.getSuperclassTypeParameter(this.getClass());
        this.mGenericsClz = JsonHelper.getRawType(type);
        if (this.mGenericsClz == null) {
            throw new IllegalArgumentException("JsonType's generics is not recognizable!");
        }
        try {
            this.mConstructor = this.mGenericsClz.getDeclaredConstructor(new Class[0]);
            return;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            noSuchMethodException.printStackTrace();
            return;
        }
    }

    static Type getSuperclassTypeParameter(Class<?> subclass) {
        Type type = subclass.getGenericSuperclass();
        if (type instanceof Class) {
            throw new RuntimeException("Missing type parameter.");
        }
        return JsonHelper.canonicalize(((ParameterizedType)type).getActualTypeArguments()[0]);
    }
}

