/*
 * Decompiled with CFR 0.152.
 */
package com.mobile.auth.gatewayauth;

import android.graphics.drawable.Drawable;
import android.support.annotation.ColorInt;
import android.support.annotation.IntRange;
import android.widget.ImageView;
import android.widget.TextView;
import com.mobile.auth.gatewayauth.a;
import com.mobile.auth.gatewayauth.annotations.AuthNumber;
import java.io.Serializable;

@AuthNumber
public class AuthUIConfig
implements Serializable {
    private static final int MODE_SHIFT = 30;
    private static final int MODE_MASK = -1073741824;
    public static final int SP_MODE = 0;
    public static final int DP_MODE = 0x40000000;
    public static int DEFAULT_STATUS_BAR_COLOR = -1;
    public static int DEFAULT_BOTTOM_NAV_COLOR = -16777216;
    public static int DEFAULT_NAV_COLOR = -16617774;
    public static int DEFAULT_NAV_TEXT_COLOR = -1;
    public static int DEFAULT_NUMBER_COLOR = -16777216;
    public static int DEFAULT_SWITCH_ACC_TEXT_COLOR = -10066330;
    public static int DEFAULT_LOGIN_BTN_TEXT_COLOR = -1;
    public static int DEFAULT_PROTOCOL_ONE_COLOR = -13070867;
    public static int DEFAULT_PROTOCOL_TWO_COLOR = -13070867;
    public static int DEFAULT_PROTOCOL_COLOR = -6710887;
    public static int DEFAULT_SLOGAN_TEXT_COLOR = -6710887;
    public static int DEFAULT_WEB_STATUS_BAR_COLOR = -1;
    public static int DEFAULT_WEB_NAV_COLOR = -16617774;
    public static int DEFAULT_WEB_NAV_TEXT_COLOR = -1;
    public static int DEFAULT_PROTOCOL_THREE_COLOR = -13070867;
    private int statusBarColor;
    private int bottomNavBarColor;
    private boolean isLightColor;
    private boolean isStatusBarHidden;
    private int statusBarUIFlag;
    private int navColor;
    private String navText;
    private int navTextColor;
    private int navTextSize;
    private String navReturnImgPath;
    private Drawable navReturnImgDrawable;
    private int navReturnImgWidth;
    private int navReturnImgHeight;
    private boolean navReturnHidden;
    private ImageView.ScaleType navReturnScaleType;
    private boolean navHidden;
    private String logoImgPath;
    private Drawable logoImgDrawable;
    private int logoWidth;
    private int logoHeight;
    private boolean logoHidden;
    private int logoOffsetY;
    private int logoOffsetY_B;
    private ImageView.ScaleType logoScaleType;
    private boolean checkboxHidden;
    private String uncheckedImgPath;
    private Drawable uncheckedImgDrawable;
    private String checkedImgPath;
    private Drawable checkedImgDrawable;
    private int checkBoxHeight;
    private int checkBoxWidth;
    private int numberColor;
    private int numberSize;
    private int numFieldOffsetY;
    private int numFieldOffsetY_B;
    private int numberFieldOffsetX;
    private int numberLayoutGravity;
    private boolean switchAccHidden;
    private int switchAccTextColor;
    private int switchAccTextSize;
    private String switchAccText;
    private int switchOffsetY;
    private int switchOffsetY_B;
    private String logBtnText;
    private int logBtnTextColor;
    private int logBtnTextSize;
    private String logBtnBackgroundPath;
    private Drawable logBtnBackgroundDrawable;
    private int logBtnOffsetX;
    private int logBtnOffsetY;
    private int logBtnOffsetY_B;
    private int logBtnWidth;
    private int logBtnHeight;
    private int logBtnMarginLeftAndRight;
    private String loadingImgPath;
    private Drawable loadingImgDrawable;
    private String loadingBackgroundPath;
    private Drawable loadingBackgroundDrawable;
    private boolean isHiddenLoading;
    private int logBtnLayoutGravity;
    private boolean logBtnToastHidden;
    private String protocolOneName;
    private String protocolOneURL;
    private int protocolOneColor;
    private String protocolTwoName;
    private String protocolTwoURL;
    private int protocolTwoColor;
    private int protocolColor;
    private int privacyOffsetX;
    private int privacyOffsetY;
    private int privacyOffsetY_B;
    private boolean privacyState;
    private int protocolGravity;
    private int privacyTextSize;
    private int privacyMargin;
    private String privacyBefore;
    private String privacyEnd;
    private String vendorPrivacyPrefix;
    private String vendorPrivacySuffix;
    private int protocolLayoutGravity;
    private String[] privacyConectTexts;
    private int privacyOperatorIndex;
    private boolean sloganHidden;
    private String sloganText;
    private int sloganTextSize;
    private int sloganTextColor;
    private int sloganOffsetY;
    private int sloganOffsetY_B;
    private int dialogWidth;
    private int dialogHeight;
    private boolean dialogBottom;
    private int dialogOffsetX;
    private int dialogOffsetY;
    private String pageBackgroundPath;
    private Drawable pageBackgroundDrawable;
    private int webViewStatusBarColor;
    private int webNavColor;
    private int webNavTextColor;
    private int webNavTextSize;
    private String webNavReturnImgPath;
    private Drawable webNavReturnImgDrawable;
    private boolean webSupportedJavascript;
    private String authPageActIn;
    private String activityOut;
    private String authPageActOut;
    private String activityIn;
    private int screenOrientation;
    private float dialogAlpha = -1.0f;
    private String protocolThreeName = null;
    private String protocolThreeURL = null;
    private int protocolThreeColor = DEFAULT_PROTOCOL_THREE_COLOR;
    private String protocolAction;
    private String packageName;

    public boolean isHiddenLoading() {
        try {
            return this.isHiddenLoading;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public String getProtocolThreeName() {
        try {
            return this.protocolThreeName;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public void setProtocolThreeName(String string) {
        try {
            this.protocolThreeName = string;
            return;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return;
        }
    }

    public String getProtocolThreeURL() {
        try {
            return this.protocolThreeURL;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public void setProtocolThreeURL(String string) {
        try {
            this.protocolThreeURL = string;
            return;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return;
        }
    }

    public int getProtocolThreeColor() {
        try {
            return this.protocolThreeColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public void setProtocolThreeColor(int n2) {
        try {
            this.protocolThreeColor = n2;
            return;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return;
        }
    }

    public float getDialogAlpha() {
        try {
            return this.dialogAlpha;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1.0f;
        }
    }

    public void setDialogAlpha(float f2) {
        try {
            this.dialogAlpha = f2;
            return;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return;
        }
    }

    public int getNavColor() {
        try {
            return this.navColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getNavText() {
        try {
            return this.navText;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getNavTextColor() {
        try {
            return this.navTextColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getNavReturnImgPath() {
        try {
            return this.navReturnImgPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public ImageView.ScaleType getNavReturnScaleType() {
        try {
            return this.navReturnScaleType;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getLogoImgPath() {
        try {
            return this.logoImgPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public boolean isLogoHidden() {
        try {
            return this.logoHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public int getLogoOffsetY() {
        try {
            return this.logoOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNumberColor() {
        try {
            return this.numberColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNumberSize() {
        try {
            return this.numberSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNumFieldOffsetY() {
        try {
            return this.numFieldOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public boolean isSwitchAccHidden() {
        try {
            return this.switchAccHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public int getSwitchAccTextColor() {
        try {
            return this.switchAccTextColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getSwitchOffsetY() {
        try {
            return this.switchOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getLogBtnText() {
        try {
            return this.logBtnText;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getLogBtnTextColor() {
        try {
            return this.logBtnTextColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogBtnTextSize() {
        try {
            return this.logBtnTextSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getLogBtnBackgroundPath() {
        try {
            return this.logBtnBackgroundPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getLogBtnOffsetY() {
        try {
            return this.logBtnOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getProtocolOneName() {
        try {
            return this.protocolOneName;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getProtocolOneURL() {
        try {
            return this.protocolOneURL;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getProtocolOneColor() {
        try {
            return this.protocolOneColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getProtocolTwoName() {
        try {
            return this.protocolTwoName;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getProtocolTwoURL() {
        try {
            return this.protocolTwoURL;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getProtocolTwoColor() {
        try {
            return this.protocolTwoColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getProtocolColor() {
        try {
            return this.protocolColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getPrivacyOffsetY() {
        try {
            return this.privacyOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getSloganTextColor() {
        try {
            return this.sloganTextColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getSloganOffsetY() {
        try {
            return this.sloganOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogoOffsetY_B() {
        try {
            return this.logoOffsetY_B;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNumFieldOffsetY_B() {
        try {
            return this.numFieldOffsetY_B;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getSwitchOffsetY_B() {
        try {
            return this.switchOffsetY_B;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogBtnOffsetY_B() {
        try {
            return this.logBtnOffsetY_B;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getPrivacyOffsetY_B() {
        try {
            return this.privacyOffsetY_B;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getSloganOffsetY_B() {
        try {
            return this.sloganOffsetY_B;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public boolean isCheckboxHidden() {
        try {
            return this.checkboxHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public String getSloganText() {
        try {
            return this.sloganText;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getNavTextSize() {
        try {
            return this.navTextSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogoWidth() {
        try {
            return this.logoWidth;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogoHeight() {
        try {
            return this.logoHeight;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getSwitchAccTextSize() {
        try {
            return this.switchAccTextSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getSwitchAccText() {
        try {
            return this.switchAccText;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getSloganTextSize() {
        try {
            return this.sloganTextSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public boolean isSloganHidden() {
        try {
            return this.sloganHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public String getUncheckedImgPath() {
        try {
            return this.uncheckedImgPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getCheckedImgPath() {
        try {
            return this.checkedImgPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public boolean isPrivacyState() {
        try {
            return this.privacyState;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public int getProtocolGravity() {
        try {
            return this.protocolGravity;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getStatusBarColor() {
        try {
            return this.statusBarColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getBottomNavBarColor() {
        try {
            return this.bottomNavBarColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public boolean isLightColor() {
        try {
            return this.isLightColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public int getCheckBoxHeight() {
        try {
            return this.checkBoxHeight;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getCheckBoxWidth() {
        try {
            return this.checkBoxWidth;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNumberFieldOffsetX() {
        try {
            return this.numberFieldOffsetX;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogBtnWidth() {
        try {
            return this.logBtnWidth;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogBtnHeight() {
        try {
            return this.logBtnHeight;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogBtnMarginLeftAndRight() {
        try {
            return this.logBtnMarginLeftAndRight;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getPrivacyTextSize() {
        try {
            return this.privacyTextSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNavReturnImgWidth() {
        try {
            return this.navReturnImgWidth;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNavReturnImgHeight() {
        try {
            return this.navReturnImgHeight;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getPrivacyMargin() {
        try {
            return this.privacyMargin;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String[] getPrivacyConectTexts() {
        try {
            return this.privacyConectTexts;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getPrivacyOperatorIndex() {
        try {
            return this.privacyOperatorIndex;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getPrivacyBefore() {
        try {
            return this.privacyBefore;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getPrivacyEnd() {
        try {
            return this.privacyEnd;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public boolean isNavReturnHidden() {
        try {
            return this.navReturnHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public String getLoadingImgPath() {
        try {
            return this.loadingImgPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getDialogWidth() {
        try {
            return this.dialogWidth;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getDialogHeight() {
        try {
            return this.dialogHeight;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getDialogOffsetX() {
        try {
            return this.dialogOffsetX;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getDialogOffsetY() {
        try {
            return this.dialogOffsetY;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public boolean isDialogBottom() {
        try {
            return this.dialogBottom;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public String getPageBackgroundPath() {
        try {
            return this.pageBackgroundPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public boolean isNavHidden() {
        try {
            return this.navHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public ImageView.ScaleType getLogoScaleType() {
        try {
            return this.logoScaleType;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public boolean isStatusBarHidden() {
        try {
            return this.isStatusBarHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public int getStatusBarUIFlag() {
        try {
            return this.statusBarUIFlag;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getWebViewStatusBarColor() {
        try {
            return this.webViewStatusBarColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getWebNavColor() {
        try {
            return this.webNavColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getWebNavTextColor() {
        try {
            return this.webNavTextColor;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getWebNavTextSize() {
        try {
            return this.webNavTextSize;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getWebNavReturnImgPath() {
        try {
            return this.webNavReturnImgPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getAuthPageActIn() {
        try {
            return this.authPageActIn;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getActivityOut() {
        try {
            return this.activityOut;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getAuthPageActOut() {
        try {
            return this.authPageActOut;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getActivityIn() {
        try {
            return this.activityIn;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getScreenOrientation() {
        try {
            return this.screenOrientation;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public String getVendorPrivacyPrefix() {
        try {
            return this.vendorPrivacyPrefix;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getVendorPrivacySuffix() {
        try {
            return this.vendorPrivacySuffix;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getLogBtnOffsetX() {
        try {
            return this.logBtnOffsetX;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getNumberLayoutGravity() {
        try {
            return this.numberLayoutGravity;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getLogBtnLayoutGravity() {
        try {
            return this.logBtnLayoutGravity;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getPrivacyOffsetX() {
        try {
            return this.privacyOffsetX;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public int getProtocolLayoutGravity() {
        try {
            return this.protocolLayoutGravity;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return -1;
        }
    }

    public boolean isLogBtnToastHidden() {
        try {
            return this.logBtnToastHidden;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public boolean isDialog() {
        try {
            return this.dialogWidth > 0 && this.dialogHeight > 0;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public boolean isWebSupportedJavascript() {
        try {
            return this.webSupportedJavascript;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return false;
        }
    }

    public Drawable getNavReturnImgDrawable() {
        try {
            return this.navReturnImgDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getLogoImgDrawable() {
        try {
            return this.logoImgDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getUncheckedImgDrawable() {
        try {
            return this.uncheckedImgDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getCheckedImgDrawable() {
        try {
            return this.checkedImgDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getLogBtnBackgroundDrawable() {
        try {
            return this.logBtnBackgroundDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getPageBackgroundDrawable() {
        try {
            return this.pageBackgroundDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getWebNavReturnImgDrawable() {
        try {
            return this.webNavReturnImgDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getLoadingImgDrawable() {
        try {
            return this.loadingImgDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getProtocolAction() {
        try {
            return this.protocolAction;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getPackageName() {
        try {
            return this.packageName;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String getLoadingBackgroundPath() {
        try {
            return this.loadingBackgroundPath;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public Drawable getLoadingBackgroundDrawable() {
        try {
            return this.loadingBackgroundDrawable;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    private AuthUIConfig(Builder builder) {
        this.statusBarColor = Builder.access$000(builder);
        this.bottomNavBarColor = Builder.access$100(builder);
        this.isLightColor = Builder.access$200(builder);
        this.isStatusBarHidden = Builder.access$300(builder);
        this.statusBarUIFlag = Builder.access$400(builder);
        this.navColor = Builder.access$500(builder);
        this.navText = Builder.access$600(builder);
        this.navTextColor = Builder.access$700(builder);
        this.navReturnImgPath = Builder.access$800(builder);
        this.navReturnImgWidth = Builder.access$900(builder);
        this.navReturnImgHeight = Builder.access$1000(builder);
        this.navReturnHidden = Builder.access$1100(builder);
        this.navReturnScaleType = Builder.access$1200(builder);
        this.logoImgPath = Builder.access$1300(builder);
        this.logoHidden = Builder.access$1400(builder);
        this.logoScaleType = Builder.access$1500(builder);
        this.numberColor = Builder.access$1600(builder);
        this.switchAccHidden = Builder.access$1700(builder);
        this.switchAccTextColor = Builder.access$1800(builder);
        this.logBtnText = Builder.access$1900(builder);
        this.logBtnTextColor = Builder.access$2000(builder);
        this.protocolOneName = Builder.access$2100(builder);
        this.protocolOneURL = Builder.access$2200(builder);
        this.protocolOneColor = Builder.access$2300(builder);
        this.protocolTwoColor = Builder.access$2400(builder);
        this.protocolTwoName = Builder.access$2500(builder);
        this.protocolTwoURL = Builder.access$2600(builder);
        this.protocolColor = Builder.access$2700(builder);
        this.sloganTextColor = Builder.access$2800(builder);
        this.numberSize = Builder.access$2900(builder);
        this.logBtnBackgroundPath = Builder.access$3000(builder);
        this.loadingImgPath = Builder.access$3100(builder);
        this.sloganOffsetY = Builder.access$3200(builder);
        this.logoOffsetY = Builder.access$3300(builder);
        this.logoOffsetY_B = Builder.access$3400(builder);
        this.numFieldOffsetY = Builder.access$3500(builder);
        this.numFieldOffsetY_B = Builder.access$3600(builder);
        this.numberFieldOffsetX = Builder.access$3700(builder);
        this.switchOffsetY = Builder.access$3800(builder);
        this.switchOffsetY_B = Builder.access$3900(builder);
        this.logBtnTextSize = Builder.access$4000(builder);
        this.logBtnOffsetY = Builder.access$4100(builder);
        this.logBtnOffsetY_B = Builder.access$4200(builder);
        this.logBtnWidth = Builder.access$4300(builder);
        this.logBtnHeight = Builder.access$4400(builder);
        this.logBtnOffsetX = Builder.access$4500(builder);
        this.logBtnMarginLeftAndRight = Builder.access$4600(builder);
        this.privacyOffsetY = Builder.access$4700(builder);
        this.privacyOffsetY_B = Builder.access$4800(builder);
        this.sloganOffsetY_B = Builder.access$4900(builder);
        this.checkboxHidden = Builder.access$5000(builder);
        this.sloganText = Builder.access$5100(builder);
        this.navTextSize = Builder.access$5200(builder);
        this.logoWidth = Builder.access$5300(builder);
        this.logoHeight = Builder.access$5400(builder);
        this.switchAccTextSize = Builder.access$5500(builder);
        this.switchAccText = Builder.access$5600(builder);
        this.sloganTextSize = Builder.access$5700(builder);
        this.sloganHidden = Builder.access$5800(builder);
        this.uncheckedImgPath = Builder.access$5900(builder);
        this.checkedImgPath = Builder.access$6000(builder);
        this.checkBoxHeight = Builder.access$6100(builder);
        this.checkBoxWidth = Builder.access$6200(builder);
        this.privacyState = Builder.access$6300(builder);
        this.protocolGravity = Builder.access$6400(builder);
        this.privacyTextSize = Builder.access$6500(builder);
        this.privacyMargin = Builder.access$6600(builder);
        this.privacyBefore = Builder.access$6700(builder);
        this.vendorPrivacyPrefix = Builder.access$6800(builder);
        this.vendorPrivacySuffix = Builder.access$6900(builder);
        this.privacyEnd = Builder.access$7000(builder);
        this.dialogWidth = Builder.access$7100(builder);
        this.dialogHeight = Builder.access$7200(builder);
        this.dialogBottom = Builder.access$7300(builder);
        this.dialogOffsetX = Builder.access$7400(builder);
        this.dialogOffsetY = Builder.access$7500(builder);
        this.pageBackgroundPath = Builder.access$7600(builder);
        this.navHidden = Builder.access$7700(builder);
        this.webViewStatusBarColor = Builder.access$7800(builder);
        this.webNavColor = Builder.access$7900(builder);
        this.webNavTextColor = Builder.access$8000(builder);
        this.webNavTextSize = Builder.access$8100(builder);
        this.webNavReturnImgPath = Builder.access$8200(builder);
        this.authPageActIn = Builder.access$8300(builder);
        this.activityOut = Builder.access$8400(builder);
        this.authPageActOut = Builder.access$8500(builder);
        this.activityIn = Builder.access$8600(builder);
        this.screenOrientation = Builder.access$8700(builder);
        this.protocolLayoutGravity = Builder.access$8800(builder);
        this.numberLayoutGravity = Builder.access$8900(builder);
        this.logBtnLayoutGravity = Builder.access$9000(builder);
        this.privacyOffsetX = Builder.access$9100(builder);
        this.logBtnToastHidden = Builder.access$9200(builder);
        this.dialogAlpha = Builder.access$9300(builder);
        this.protocolThreeName = Builder.access$9400(builder);
        this.protocolThreeURL = Builder.access$9500(builder);
        this.protocolThreeColor = Builder.access$9600(builder);
        this.webSupportedJavascript = Builder.access$9700(builder);
        this.privacyOperatorIndex = Builder.access$9800(builder) < 0 || Builder.access$9800(builder) > 3 ? 0 : Builder.access$9800(builder);
        this.privacyConectTexts = this.makePrivacyConectTexts(Builder.access$9900(builder));
        this.navReturnImgDrawable = Builder.access$10000(builder);
        this.logoImgDrawable = Builder.access$10100(builder);
        this.uncheckedImgDrawable = Builder.access$10200(builder);
        this.checkedImgDrawable = Builder.access$10300(builder);
        this.logBtnBackgroundDrawable = Builder.access$10400(builder);
        this.pageBackgroundDrawable = Builder.access$10500(builder);
        this.webNavReturnImgDrawable = Builder.access$10600(builder);
        this.packageName = Builder.access$10700(builder);
        this.protocolAction = Builder.access$10800(builder);
        this.loadingImgDrawable = Builder.access$10900(builder);
        this.loadingBackgroundPath = Builder.access$11000(builder);
        this.loadingBackgroundDrawable = Builder.access$11100(builder);
        this.isHiddenLoading = Builder.access$11200(builder);
    }

    private String[] makePrivacyConectTexts(String[] stringArray) {
        try {
            String[] stringArray2 = new String[]{"\u548c", "\u3001", "\u3001"};
            if (stringArray == null || stringArray.length == 0) {
                return stringArray2;
            }
            stringArray2 = new String[]{"\u548c", "\u3001", "\u3001"};
            int n2 = stringArray.length;
            for (int i2 = 0; i2 < n2 && i2 < 3; ++i2) {
                stringArray2[i2] = stringArray[i2];
            }
            return stringArray2;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public String toString() {
        try {
            return "AuthUIConfig{statusBarColor=" + this.statusBarColor + ", bottomNavBarColor=" + this.bottomNavBarColor + ", isLightColor=" + this.isLightColor + ", isStatusBarHidden=" + this.isStatusBarHidden + ", statusBarUIFlag=" + this.statusBarUIFlag + ", navColor=" + this.navColor + ", navText='" + this.navText + '\'' + ", navTextColor=" + this.navTextColor + ", navTextSize=" + this.navTextSize + ", navReturnImgPath='" + this.navReturnImgPath + '\'' + ", navReturnImgWidth=" + this.navReturnImgWidth + ", navReturnImgHeight=" + this.navReturnImgHeight + ", navReturnHidden=" + this.navReturnHidden + ", navReturnScaleType=" + this.navReturnScaleType + ", navHidden=" + this.navHidden + ", logoImgPath='" + this.logoImgPath + '\'' + ", logoWidth=" + this.logoWidth + ", logoHeight=" + this.logoHeight + ", logoHidden=" + this.logoHidden + ", logoOffsetY=" + this.logoOffsetY + ", logoOffsetY_B=" + this.logoOffsetY_B + ", logoScaleType=" + this.logoScaleType + ", checkboxHidden=" + this.checkboxHidden + ", uncheckedImgPath='" + this.uncheckedImgPath + '\'' + ", checkedImgPath='" + this.checkedImgPath + '\'' + ", checkBoxHeight=" + this.checkBoxHeight + ", checkBoxWidth=" + this.checkBoxWidth + ", numberColor=" + this.numberColor + ", numberSize=" + this.numberSize + ", numFieldOffsetY=" + this.numFieldOffsetY + ", numFieldOffsetY_B=" + this.numFieldOffsetY_B + ", numberFieldOffsetX=" + this.numberFieldOffsetX + ", numberLayoutGravity=" + this.numberLayoutGravity + ", switchAccHidden=" + this.switchAccHidden + ", switchAccTextColor=" + this.switchAccTextColor + ", switchAccTextSize=" + this.switchAccTextSize + ", switchAccText='" + this.switchAccText + '\'' + ", switchOffsetY=" + this.switchOffsetY + ", switchOffsetY_B=" + this.switchOffsetY_B + ", logBtnText='" + this.logBtnText + '\'' + ", logBtnTextColor=" + this.logBtnTextColor + ", logBtnTextSize=" + this.logBtnTextSize + ", logBtnBackgroundPath='" + this.logBtnBackgroundPath + '\'' + ", logBtnOffsetX=" + this.logBtnOffsetX + ", logBtnOffsetY=" + this.logBtnOffsetY + ", logBtnOffsetY_B=" + this.logBtnOffsetY_B + ", logBtnWidth=" + this.logBtnWidth + ", logBtnHeight=" + this.logBtnHeight + ", logBtnMarginLeftAndRight=" + this.logBtnMarginLeftAndRight + ", loadingImgPath='" + this.loadingImgPath + '\'' + ", logBtnLayoutGravity=" + this.logBtnLayoutGravity + ", logBtnToastHidden=" + this.logBtnToastHidden + ", protocolOneName='" + this.protocolOneName + '\'' + ", protocolOneURL='" + this.protocolOneURL + '\'' + ", protocolOneColor=" + this.protocolOneColor + ", protocolTwoName='" + this.protocolTwoName + '\'' + ", protocolTwoURL='" + this.protocolTwoURL + '\'' + ", protocolTwoColor=" + this.protocolTwoColor + ", protocolColor=" + this.protocolColor + ", privacyOffsetX=" + this.privacyOffsetX + ", privacyOffsetY=" + this.privacyOffsetY + ", privacyOffsetY_B=" + this.privacyOffsetY_B + ", privacyState=" + this.privacyState + ", protocolGravity=" + this.protocolGravity + ", privacyTextSize=" + this.privacyTextSize + ", privacyMargin=" + this.privacyMargin + ", privacyBefore='" + this.privacyBefore + '\'' + ", privacyEnd='" + this.privacyEnd + '\'' + ", vendorPrivacyPrefix='" + this.vendorPrivacyPrefix + '\'' + ", vendorPrivacySuffix='" + this.vendorPrivacySuffix + '\'' + ", protocolLayoutGravity=" + this.protocolLayoutGravity + ", sloganHidden=" + this.sloganHidden + ", sloganText='" + this.sloganText + '\'' + ", sloganTextSize=" + this.sloganTextSize + ", sloganTextColor=" + this.sloganTextColor + ", sloganOffsetY=" + this.sloganOffsetY + ", sloganOffsetY_B=" + this.sloganOffsetY_B + ", dialogWidth=" + this.dialogWidth + ", dialogHeight=" + this.dialogHeight + ", dialogBottom=" + this.dialogBottom + ", dialogOffsetX=" + this.dialogOffsetX + ", dialogOffsetY=" + this.dialogOffsetY + ", pageBackgroundPath='" + this.pageBackgroundPath + '\'' + ", webViewStatusBarColor=" + this.webViewStatusBarColor + ", webNavColor=" + this.webNavColor + ", webNavTextColor=" + this.webNavTextColor + ", webNavTextSize=" + this.webNavTextSize + ", webNavReturnImgPath='" + this.webNavReturnImgPath + '\'' + ", webSupportedJavascript=" + this.webSupportedJavascript + ", authPageActIn='" + this.authPageActIn + '\'' + ", activityOut='" + this.activityOut + '\'' + ", authPageActOut='" + this.authPageActOut + '\'' + ", activityIn='" + this.activityIn + '\'' + ", screenOrientation=" + this.screenOrientation + ", dialogAlpha=" + this.dialogAlpha + ", protocolThreeName='" + this.protocolThreeName + '\'' + ", protocolThreeURL='" + this.protocolThreeURL + '\'' + ", privacyConectTexts='" + this.privacyConectTexts + '\'' + ", privacyOperatorIndex='" + this.privacyOperatorIndex + '\'' + ", protocolAction='" + this.protocolAction + '\'' + ", packageName='" + this.packageName + '\'' + ", protocolThreeColor=" + this.protocolThreeColor + ", loadingBackgroundPath=" + this.loadingBackgroundPath + ", isHiddenLoading=" + this.isHiddenLoading + '}';
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return null;
        }
    }

    public int getMode(int n2) {
        return n2 & 0xC0000000;
    }

    public int getSize(int n2) {
        return n2 & 0x3FFFFFFF;
    }

    public void setTextSize(TextView textView, int n2) {
        try {
            if (0 == this.getMode(n2)) {
                textView.setTextSize(2, (float)this.getSize(n2));
                return;
            }
            textView.setTextSize(1, (float)this.getSize(n2));
            return;
        }
        catch (Throwable throwable) {
            a.a(throwable);
            return;
        }
    }

    @AuthNumber
    public static class Builder {
        private int statusBarColor = DEFAULT_STATUS_BAR_COLOR;
        private int bottomNavColor = DEFAULT_BOTTOM_NAV_COLOR;
        private boolean isLightColor = false;
        private boolean isStatusBarHidden = false;
        private int statusBarUIFlag = -1;
        private int navColor = DEFAULT_NAV_COLOR;
        private String navText = "\u514d\u5bc6\u767b\u5f55";
        private int navTextColor = DEFAULT_NAV_TEXT_COLOR;
        private String navReturnImgPath = "authsdk_return_bg";
        private int navReturnImgWidth = 30;
        private int navReturnImgHeight = 30;
        private boolean navReturnHidden = false;
        private ImageView.ScaleType navReturnScaleType = ImageView.ScaleType.CENTER;
        private boolean navHidden = false;
        private String logoImgPath = null;
        private boolean logoHidden = false;
        private int numberColor = DEFAULT_NUMBER_COLOR;
        private int numberSize = this.makeTextSizeSpec(28, 0x40000000);
        private boolean switchAccHidden = false;
        private int switchAccTextColor = DEFAULT_SWITCH_ACC_TEXT_COLOR;
        private String logBtnText = "\u4e00\u952e\u767b\u5f55";
        private int logBtnTextSize = this.makeTextSizeSpec(16, 0x40000000);
        private int logBtnTextColor = DEFAULT_LOGIN_BTN_TEXT_COLOR;
        private String protocolOneName = null;
        private String protocolOneURL = null;
        private int protocolOneColor = DEFAULT_PROTOCOL_ONE_COLOR;
        private String protocolTwoName = null;
        private String protocolTwoURL = null;
        private int protocolTwoColor = DEFAULT_PROTOCOL_TWO_COLOR;
        private int protocolColor = DEFAULT_PROTOCOL_COLOR;
        private int protocolLayoutGravity = 1;
        private int sloganTextColor = DEFAULT_SLOGAN_TEXT_COLOR;
        private String sloganText = null;
        private String logBtnBackgroundPath = "authsdk_dialog_login_btn_bg";
        private String loadingImgPath = "authsdk_waiting_icon";
        private int sloganOffsetY = -1;
        private int logoOffsetY = -1;
        private int logoOffsetY_B = -1;
        private ImageView.ScaleType logoScaleType = ImageView.ScaleType.FIT_XY;
        private int numFieldOffsetY = -1;
        private int numFieldOffsetY_B = -1;
        private int numberFieldOffsetX = 0;
        private int numberLayoutGravity = 1;
        private int switchOffsetY = -1;
        private int switchOffsetY_B = -1;
        private int logBtnOffsetY = -1;
        private int logBtnOffsetY_B = -1;
        private int logBtnWidth = -1;
        private int logBtnHeight = 51;
        private int logBtnOffsetX = 0;
        private int logBtnMarginLeftAndRight = 28;
        private int logBtnLayoutGravity = 1;
        private int privacyOffsetX;
        private int privacyOffsetY = -1;
        private int privacyOffsetY_B = 28;
        private int sloganOffsetY_B = -1;
        private int checkBoxWidth = 18;
        private int checkBoxHeight = 18;
        private boolean checkboxHidden = false;
        private int navTextSize = this.makeTextSizeSpec(18, 0x40000000);
        private int logoWidth = 90;
        private int logoHeight = 90;
        private int switchAccTextSize = this.makeTextSizeSpec(16, 0x40000000);
        private String switchAccText = "\u5207\u6362\u5230\u5176\u4ed6\u65b9\u5f0f";
        private int sloganTextSize = this.makeTextSizeSpec(16, 0x40000000);
        private boolean sloganHidden = false;
        private String uncheckedImgPath = "authsdk_checkbox_uncheck_bg";
        private String checkedImgPath = "authsdk_checkbox_checked_bg";
        private boolean privacyState = false;
        private int protocolGravity = 17;
        private int privacyTextSize = this.makeTextSizeSpec(12, 0x40000000);
        private int privacyMargin = 28;
        private String privacyBefore = "";
        private String privacyEnd = "";
        private String vendorPrivacyPrefix = "";
        private String vendorPrivacySuffix = "";
        private int dialogWidth = -1;
        private int dialogHeight = -1;
        private boolean dialogBottom = false;
        private int dialogOffsetX = 0;
        private int dialogOffsetY = 0;
        private String pageBackgroundPath = null;
        private int webViewStatusBarColor = DEFAULT_WEB_STATUS_BAR_COLOR;
        private int webNavColor = DEFAULT_WEB_NAV_COLOR;
        private int webNavTextColor = DEFAULT_WEB_NAV_TEXT_COLOR;
        private int webNavTextSize = -1;
        private String webNavReturnImgPath = null;
        private boolean webSupportedJavascript = true;
        private String authPageActIn = null;
        private String activityOut = null;
        private String authPageActOut = null;
        private String activityIn = null;
        private int screenOrientation = -1;
        private boolean logBtnToastHidden = false;
        private float dialogAlpha = -1.0f;
        private String protocolThreeName = null;
        private String protocolThreeURL = null;
        private int protocolThreeColor = DEFAULT_PROTOCOL_THREE_COLOR;
        private String[] privacyConectTexts;
        private int privacyOperatorIndex = 0;
        private Drawable navReturnImgDrawable;
        private Drawable logoImgDrawable;
        private Drawable uncheckedImgDrawable;
        private Drawable checkedImgDrawable;
        private Drawable logBtnBackgroundDrawable;
        private Drawable pageBackgroundDrawable;
        private Drawable webNavReturnImgDrawable;
        private Drawable loadingImgDrawable;
        private String protocolAction;
        private String packageName;
        private String loadingBackgroundPath;
        private Drawable loadingBackgroundDrawable;
        private boolean isHiddenLoading;

        public Builder setDialogAlpha(float f2) {
            try {
                this.dialogAlpha = f2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavColor(@ColorInt int n2) {
            try {
                this.navColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLoadingBackgroundPath(String string) {
            try {
                this.loadingBackgroundPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLoadingBackgroundDrawable(Drawable drawable) {
            try {
                this.loadingBackgroundDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavText(String string) {
            try {
                this.navText = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavTextColor(@ColorInt int n2) {
            try {
                this.navTextColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyOperatorIndex(@IntRange(from=0L, to=3L) int n2) {
            try {
                this.privacyOperatorIndex = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyConectTexts(String[] stringArray) {
            try {
                this.privacyConectTexts = stringArray;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavReturnScaleType(ImageView.ScaleType scaleType) {
            try {
                this.navReturnScaleType = scaleType;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoImgPath(String string) {
            try {
                this.logoImgPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoHidden(boolean bl) {
            try {
                this.logoHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNumberColor(@ColorInt int n2) {
            try {
                this.numberColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        @Deprecated
        public Builder setNumberSize(int n2) {
            try {
                this.numberSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNumberSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.numberSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSwitchAccHidden(boolean bl) {
            try {
                this.switchAccHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSwitchAccTextColor(@ColorInt int n2) {
            try {
                this.switchAccTextColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnText(String string) {
            try {
                this.logBtnText = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnTextColor(@ColorInt int n2) {
            try {
                this.logBtnTextColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        @Deprecated
        public Builder setLogBtnTextSize(int n2) {
            try {
                this.logBtnTextSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnTextSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.logBtnTextSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setAppPrivacyOne(String string, String string2) {
            try {
                this.protocolOneName = string;
                this.protocolOneURL = string2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setAppPrivacyTwo(String string, String string2) {
            try {
                this.protocolTwoName = string;
                this.protocolTwoURL = string2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setAppPrivacyThree(String string, String string2) {
            try {
                this.protocolThreeName = string;
                this.protocolThreeURL = string2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setAppPrivacyColor(@ColorInt int n2, @ColorInt int n3) {
            try {
                this.protocolColor = n2;
                this.protocolOneColor = n3;
                this.protocolTwoColor = n3;
                this.protocolThreeColor = n3;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSloganTextColor(@ColorInt int n2) {
            try {
                this.sloganTextColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnBackgroundPath(String string) {
            try {
                this.logBtnBackgroundPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavReturnImgPath(String string) {
            try {
                this.navReturnImgPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSloganOffsetY(int n2) {
            try {
                this.sloganOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoOffsetY(int n2) {
            try {
                this.logoOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoOffsetY_B(int n2) {
            try {
                this.logoOffsetY_B = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNumFieldOffsetY(int n2) {
            try {
                this.numFieldOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNumFieldOffsetY_B(int n2) {
            try {
                this.numFieldOffsetY_B = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSwitchOffsetY(int n2) {
            try {
                this.switchOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSwitchOffsetY_B(int n2) {
            try {
                this.switchOffsetY_B = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnOffsetY(int n2) {
            try {
                this.logBtnOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnOffsetY_B(int n2) {
            try {
                this.logBtnOffsetY_B = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyOffsetY(int n2) {
            try {
                this.privacyOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyOffsetY_B(int n2) {
            try {
                this.privacyOffsetY_B = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSloganOffsetY_B(int n2) {
            try {
                this.sloganOffsetY_B = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSloganText(String string) {
            try {
                this.sloganText = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setCheckboxHidden(boolean bl) {
            try {
                this.checkboxHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        @Deprecated
        public Builder setNavTextSize(int n2) {
            try {
                this.navTextSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavTextSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.navTextSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoWidth(int n2) {
            try {
                this.logoWidth = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoHeight(int n2) {
            try {
                this.logoHeight = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        @Deprecated
        public Builder setSwitchAccTextSize(int n2) {
            try {
                this.switchAccTextSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSwitchAccTextSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.switchAccTextSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSwitchAccText(String string) {
            try {
                this.switchAccText = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        @Deprecated
        public Builder setSloganTextSize(int n2) {
            try {
                this.sloganTextSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSloganTextSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.sloganTextSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setSloganHidden(boolean bl) {
            try {
                this.sloganHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setUncheckedImgPath(String string) {
            try {
                this.uncheckedImgPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setCheckedImgPath(String string) {
            try {
                this.checkedImgPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyState(boolean bl) {
            try {
                this.privacyState = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setProtocolGravity(int n2) {
            try {
                this.protocolGravity = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setStatusBarColor(@ColorInt int n2) {
            try {
                this.statusBarColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setBottomNavColor(@ColorInt int n2) {
            try {
                this.bottomNavColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLightColor(boolean bl) {
            try {
                this.isLightColor = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnWidth(int n2) {
            try {
                this.logBtnWidth = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnHeight(int n2) {
            try {
                this.logBtnHeight = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnMarginLeftAndRight(int n2) {
            try {
                this.logBtnMarginLeftAndRight = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setCheckBoxWidth(int n2) {
            try {
                this.checkBoxWidth = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setCheckBoxHeight(int n2) {
            try {
                this.checkBoxHeight = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNumberFieldOffsetX(int n2) {
            try {
                this.numberFieldOffsetX = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyTextSize(int n2) {
            try {
                this.privacyTextSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyTextSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.privacyTextSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavReturnImgWidth(int n2) {
            try {
                this.navReturnImgWidth = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavReturnImgHeight(int n2) {
            try {
                this.navReturnImgHeight = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyMargin(int n2) {
            try {
                this.privacyMargin = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyBefore(String string) {
            try {
                this.privacyBefore = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyEnd(String string) {
            try {
                this.privacyEnd = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLoadingImgPath(String string) {
            try {
                this.loadingImgPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setDialogWidth(int n2) {
            try {
                this.dialogWidth = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setDialogHeight(int n2) {
            try {
                this.dialogHeight = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setDialogOffsetX(int n2) {
            try {
                this.dialogOffsetX = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setDialogOffsetY(int n2) {
            try {
                this.dialogOffsetY = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setDialogBottom(boolean bl) {
            try {
                this.dialogBottom = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPageBackgroundPath(String string) {
            try {
                this.pageBackgroundPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavReturnHidden(boolean bl) {
            try {
                this.navReturnHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavHidden(boolean bl) {
            try {
                this.navHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoScaleType(ImageView.ScaleType scaleType) {
            try {
                this.logoScaleType = scaleType;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setStatusBarHidden(boolean bl) {
            try {
                this.isStatusBarHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setStatusBarUIFlag(int n2) {
            try {
                this.statusBarUIFlag = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebViewStatusBarColor(@ColorInt int n2) {
            try {
                this.webViewStatusBarColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebNavColor(@ColorInt int n2) {
            try {
                this.webNavColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebNavTextColor(@ColorInt int n2) {
            try {
                this.webNavTextColor = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        @Deprecated
        public Builder setWebNavTextSize(int n2) {
            try {
                this.webNavTextSize = this.makeTextSizeSpec(n2, 0);
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebNavTextSizeDp(int n2) {
            try {
                if (n2 > 0) {
                    this.webNavTextSize = this.makeTextSizeSpec(n2, 0x40000000);
                }
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebNavReturnImgPath(String string) {
            try {
                this.webNavReturnImgPath = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setAuthPageActIn(String string, String string2) {
            try {
                this.authPageActIn = string;
                this.activityOut = string2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setAuthPageActOut(String string, String string2) {
            try {
                this.authPageActOut = string;
                this.activityIn = string2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setVendorPrivacyPrefix(String string) {
            try {
                this.vendorPrivacyPrefix = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setVendorPrivacySuffix(String string) {
            try {
                this.vendorPrivacySuffix = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setScreenOrientation(int n2) {
            try {
                this.screenOrientation = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnOffsetX(int n2) {
            try {
                this.logBtnOffsetX = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnLayoutGravity(int n2) {
            try {
                this.logBtnLayoutGravity = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNumberLayoutGravity(int n2) {
            try {
                this.numberLayoutGravity = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setProtocolLayoutGravity(int n2) {
            try {
                this.protocolLayoutGravity = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPrivacyOffsetX(int n2) {
            try {
                this.privacyOffsetX = n2;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setHiddenLoading(boolean bl) {
            try {
                this.isHiddenLoading = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnToastHidden(boolean bl) {
            try {
                this.logBtnToastHidden = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebSupportedJavascript(boolean bl) {
            try {
                this.webSupportedJavascript = bl;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setNavReturnImgDrawable(Drawable drawable) {
            try {
                this.navReturnImgDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogoImgDrawable(Drawable drawable) {
            try {
                this.logoImgDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setUncheckedImgDrawable(Drawable drawable) {
            try {
                this.uncheckedImgDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setCheckedImgDrawable(Drawable drawable) {
            try {
                this.checkedImgDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLogBtnBackgroundDrawable(Drawable drawable) {
            try {
                this.logBtnBackgroundDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPageBackgroundDrawable(Drawable drawable) {
            try {
                this.pageBackgroundDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setWebNavReturnImgDrawable(Drawable drawable) {
            try {
                this.webNavReturnImgDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setLoadingImgDrawable(Drawable drawable) {
            try {
                this.loadingImgDrawable = drawable;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setProtocolAction(String string) {
            try {
                this.protocolAction = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public Builder setPackageName(String string) {
            try {
                this.packageName = string;
                return this;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        public int makeTextSizeSpec(int n2, int n3) {
            return n2 & 0x3FFFFFFF | n3 & 0xC0000000;
        }

        public AuthUIConfig create() {
            try {
                return new AuthUIConfig(this);
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$000(Builder builder) {
            try {
                return builder.statusBarColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$100(Builder builder) {
            try {
                return builder.bottomNavColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$200(Builder builder) {
            try {
                return builder.isLightColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ boolean access$300(Builder builder) {
            try {
                return builder.isStatusBarHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ int access$400(Builder builder) {
            try {
                return builder.statusBarUIFlag;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$500(Builder builder) {
            try {
                return builder.navColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$600(Builder builder) {
            try {
                return builder.navText;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$700(Builder builder) {
            try {
                return builder.navTextColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$800(Builder builder) {
            try {
                return builder.navReturnImgPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$900(Builder builder) {
            try {
                return builder.navReturnImgWidth;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$1000(Builder builder) {
            try {
                return builder.navReturnImgHeight;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$1100(Builder builder) {
            try {
                return builder.navReturnHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ ImageView.ScaleType access$1200(Builder builder) {
            try {
                return builder.navReturnScaleType;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$1300(Builder builder) {
            try {
                return builder.logoImgPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ boolean access$1400(Builder builder) {
            try {
                return builder.logoHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ ImageView.ScaleType access$1500(Builder builder) {
            try {
                return builder.logoScaleType;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$1600(Builder builder) {
            try {
                return builder.numberColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$1700(Builder builder) {
            try {
                return builder.switchAccHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ int access$1800(Builder builder) {
            try {
                return builder.switchAccTextColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$1900(Builder builder) {
            try {
                return builder.logBtnText;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$2000(Builder builder) {
            try {
                return builder.logBtnTextColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$2100(Builder builder) {
            try {
                return builder.protocolOneName;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$2200(Builder builder) {
            try {
                return builder.protocolOneURL;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$2300(Builder builder) {
            try {
                return builder.protocolOneColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$2400(Builder builder) {
            try {
                return builder.protocolTwoColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$2500(Builder builder) {
            try {
                return builder.protocolTwoName;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$2600(Builder builder) {
            try {
                return builder.protocolTwoURL;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$2700(Builder builder) {
            try {
                return builder.protocolColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$2800(Builder builder) {
            try {
                return builder.sloganTextColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$2900(Builder builder) {
            try {
                return builder.numberSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$3000(Builder builder) {
            try {
                return builder.logBtnBackgroundPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$3100(Builder builder) {
            try {
                return builder.loadingImgPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$3200(Builder builder) {
            try {
                return builder.sloganOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3300(Builder builder) {
            try {
                return builder.logoOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3400(Builder builder) {
            try {
                return builder.logoOffsetY_B;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3500(Builder builder) {
            try {
                return builder.numFieldOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3600(Builder builder) {
            try {
                return builder.numFieldOffsetY_B;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3700(Builder builder) {
            try {
                return builder.numberFieldOffsetX;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3800(Builder builder) {
            try {
                return builder.switchOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$3900(Builder builder) {
            try {
                return builder.switchOffsetY_B;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4000(Builder builder) {
            try {
                return builder.logBtnTextSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4100(Builder builder) {
            try {
                return builder.logBtnOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4200(Builder builder) {
            try {
                return builder.logBtnOffsetY_B;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4300(Builder builder) {
            try {
                return builder.logBtnWidth;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4400(Builder builder) {
            try {
                return builder.logBtnHeight;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4500(Builder builder) {
            try {
                return builder.logBtnOffsetX;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4600(Builder builder) {
            try {
                return builder.logBtnMarginLeftAndRight;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4700(Builder builder) {
            try {
                return builder.privacyOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4800(Builder builder) {
            try {
                return builder.privacyOffsetY_B;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$4900(Builder builder) {
            try {
                return builder.sloganOffsetY_B;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$5000(Builder builder) {
            try {
                return builder.checkboxHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ String access$5100(Builder builder) {
            try {
                return builder.sloganText;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$5200(Builder builder) {
            try {
                return builder.navTextSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$5300(Builder builder) {
            try {
                return builder.logoWidth;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$5400(Builder builder) {
            try {
                return builder.logoHeight;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$5500(Builder builder) {
            try {
                return builder.switchAccTextSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$5600(Builder builder) {
            try {
                return builder.switchAccText;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$5700(Builder builder) {
            try {
                return builder.sloganTextSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$5800(Builder builder) {
            try {
                return builder.sloganHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ String access$5900(Builder builder) {
            try {
                return builder.uncheckedImgPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$6000(Builder builder) {
            try {
                return builder.checkedImgPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$6100(Builder builder) {
            try {
                return builder.checkBoxHeight;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$6200(Builder builder) {
            try {
                return builder.checkBoxWidth;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$6300(Builder builder) {
            try {
                return builder.privacyState;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ int access$6400(Builder builder) {
            try {
                return builder.protocolGravity;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$6500(Builder builder) {
            try {
                return builder.privacyTextSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$6600(Builder builder) {
            try {
                return builder.privacyMargin;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$6700(Builder builder) {
            try {
                return builder.privacyBefore;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$6800(Builder builder) {
            try {
                return builder.vendorPrivacyPrefix;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$6900(Builder builder) {
            try {
                return builder.vendorPrivacySuffix;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$7000(Builder builder) {
            try {
                return builder.privacyEnd;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$7100(Builder builder) {
            try {
                return builder.dialogWidth;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$7200(Builder builder) {
            try {
                return builder.dialogHeight;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$7300(Builder builder) {
            try {
                return builder.dialogBottom;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ int access$7400(Builder builder) {
            try {
                return builder.dialogOffsetX;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$7500(Builder builder) {
            try {
                return builder.dialogOffsetY;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$7600(Builder builder) {
            try {
                return builder.pageBackgroundPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ boolean access$7700(Builder builder) {
            try {
                return builder.navHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ int access$7800(Builder builder) {
            try {
                return builder.webViewStatusBarColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$7900(Builder builder) {
            try {
                return builder.webNavColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$8000(Builder builder) {
            try {
                return builder.webNavTextColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$8100(Builder builder) {
            try {
                return builder.webNavTextSize;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String access$8200(Builder builder) {
            try {
                return builder.webNavReturnImgPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$8300(Builder builder) {
            try {
                return builder.authPageActIn;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$8400(Builder builder) {
            try {
                return builder.activityOut;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$8500(Builder builder) {
            try {
                return builder.authPageActOut;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$8600(Builder builder) {
            try {
                return builder.activityIn;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$8700(Builder builder) {
            try {
                return builder.screenOrientation;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$8800(Builder builder) {
            try {
                return builder.protocolLayoutGravity;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$8900(Builder builder) {
            try {
                return builder.numberLayoutGravity;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$9000(Builder builder) {
            try {
                return builder.logBtnLayoutGravity;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ int access$9100(Builder builder) {
            try {
                return builder.privacyOffsetX;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$9200(Builder builder) {
            try {
                return builder.logBtnToastHidden;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ float access$9300(Builder builder) {
            try {
                return builder.dialogAlpha;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1.0f;
            }
        }

        static /* synthetic */ String access$9400(Builder builder) {
            try {
                return builder.protocolThreeName;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$9500(Builder builder) {
            try {
                return builder.protocolThreeURL;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ int access$9600(Builder builder) {
            try {
                return builder.protocolThreeColor;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ boolean access$9700(Builder builder) {
            try {
                return builder.webSupportedJavascript;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }

        static /* synthetic */ int access$9800(Builder builder) {
            try {
                return builder.privacyOperatorIndex;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return -1;
            }
        }

        static /* synthetic */ String[] access$9900(Builder builder) {
            try {
                return builder.privacyConectTexts;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10000(Builder builder) {
            try {
                return builder.navReturnImgDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10100(Builder builder) {
            try {
                return builder.logoImgDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10200(Builder builder) {
            try {
                return builder.uncheckedImgDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10300(Builder builder) {
            try {
                return builder.checkedImgDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10400(Builder builder) {
            try {
                return builder.logBtnBackgroundDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10500(Builder builder) {
            try {
                return builder.pageBackgroundDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10600(Builder builder) {
            try {
                return builder.webNavReturnImgDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$10700(Builder builder) {
            try {
                return builder.packageName;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$10800(Builder builder) {
            try {
                return builder.protocolAction;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$10900(Builder builder) {
            try {
                return builder.loadingImgDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ String access$11000(Builder builder) {
            try {
                return builder.loadingBackgroundPath;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ Drawable access$11100(Builder builder) {
            try {
                return builder.loadingBackgroundDrawable;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return null;
            }
        }

        static /* synthetic */ boolean access$11200(Builder builder) {
            try {
                return builder.isHiddenLoading;
            }
            catch (Throwable throwable) {
                a.a(throwable);
                return false;
            }
        }
    }
}

