/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.vivo;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.IntentFilter;
import android.support.v4.content.LocalBroadcastManager;
import android.text.TextUtils;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.agoo.BaseNotifyClickActivity;
import com.vivo.push.IPushActionListener;
import com.vivo.push.PushClient;
import org.android.agoo.control.NotifManager;
import org.android.agoo.vivo.VivoBadgeReceiver;
import org.android.agoo.vivo.VivoMsgParseImpl;

public class VivoRegister {
    public static final String TAG = "VivoRegister";
    private static Context mContext;
    private static VivoBadgeReceiver vivoBadgeReceiver;

    public static void register(final Context context) {
        try {
            if (context == null) {
                return;
            }
            mContext = context.getApplicationContext();
            if (!UtilityImpl.isMainProcess((Context)context)) {
                ALog.i((String)TAG, (String)"not in main process, return", (Object[])new Object[0]);
                return;
            }
            if (PushClient.getInstance((Context)context).isSupport()) {
                ALog.d((String)TAG, (String)"register start", (Object[])new Object[0]);
                BaseNotifyClickActivity.addNotifyListener((BaseNotifyClickActivity.INotifyListener)new VivoMsgParseImpl());
                PushClient.getInstance((Context)context).initialize();
                PushClient.getInstance((Context)context).turnOnPush(new IPushActionListener(){

                    public void onStateChanged(int state) {
                        String regId;
                        ALog.d((String)VivoRegister.TAG, (String)"turnOnPush", (Object[])new Object[]{"state", state});
                        if (state == 0 && !TextUtils.isEmpty((CharSequence)(regId = PushClient.getInstance((Context)context).getRegId()))) {
                            NotifManager notifyManager = new NotifManager();
                            notifyManager.init(context.getApplicationContext());
                            notifyManager.reportThirdPushToken(regId, "VIVO_TOKEN", "1.0.4", true);
                        }
                    }
                });
                vivoBadgeReceiver = new VivoBadgeReceiver();
                IntentFilter filter = new IntentFilter();
                filter.addAction("msg.action.ACTION_MPM_MESSAGE_BOX_UNREAD");
                LocalBroadcastManager.getInstance((Context)context).registerReceiver((BroadcastReceiver)vivoBadgeReceiver, filter);
            } else {
                ALog.e((String)TAG, (String)"this device is not support vivo push", (Object[])new Object[0]);
            }
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"register", (Throwable)t, (Object[])new Object[0]);
        }
    }

    public static void unregister() {
        ALog.i((String)TAG, (String)"unregister", (Object[])new Object[0]);
        if (vivoBadgeReceiver != null) {
            LocalBroadcastManager.getInstance((Context)mContext).unregisterReceiver((BroadcastReceiver)vivoBadgeReceiver);
        }
        PushClient.getInstance((Context)mContext).turnOffPush(new IPushActionListener(){

            public void onStateChanged(int state) {
                ALog.d((String)VivoRegister.TAG, (String)"turnOffPush", (Object[])new Object[]{"state", state});
            }
        });
    }
}

