/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.mipush.sdk;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.ServiceInfo;
import android.os.Build;
import android.text.TextUtils;
import com.xiaomi.clientreport.data.Config;
import com.xiaomi.clientreport.manager.ClientReportClient;
import com.xiaomi.mipush.sdk.Constants;
import com.xiaomi.mipush.sdk.Logger;
import com.xiaomi.mipush.sdk.MiPushCommandMessage;
import com.xiaomi.mipush.sdk.MiPushMessage;
import com.xiaomi.mipush.sdk.MiTinyDataClient;
import com.xiaomi.mipush.sdk.PushConfiguration;
import com.xiaomi.mipush.sdk.PushMessageHandler;
import com.xiaomi.mipush.sdk.PushMessageHelper;
import com.xiaomi.mipush.sdk.a;
import com.xiaomi.mipush.sdk.ad;
import com.xiaomi.mipush.sdk.ae;
import com.xiaomi.mipush.sdk.an;
import com.xiaomi.mipush.sdk.at;
import com.xiaomi.mipush.sdk.au;
import com.xiaomi.mipush.sdk.b;
import com.xiaomi.mipush.sdk.e;
import com.xiaomi.mipush.sdk.f;
import com.xiaomi.mipush.sdk.i;
import com.xiaomi.mipush.sdk.r;
import com.xiaomi.mipush.sdk.s;
import com.xiaomi.mipush.sdk.u;
import com.xiaomi.push.ai;
import com.xiaomi.push.ax;
import com.xiaomi.push.bm;
import com.xiaomi.push.dj;
import com.xiaomi.push.dk;
import com.xiaomi.push.ei;
import com.xiaomi.push.ej;
import com.xiaomi.push.ek;
import com.xiaomi.push.ev;
import com.xiaomi.push.g;
import com.xiaomi.push.hf;
import com.xiaomi.push.hj;
import com.xiaomi.push.hk;
import com.xiaomi.push.hp;
import com.xiaomi.push.hs;
import com.xiaomi.push.ht;
import com.xiaomi.push.hz;
import com.xiaomi.push.ie;
import com.xiaomi.push.if;
import com.xiaomi.push.ij;
import com.xiaomi.push.il;
import com.xiaomi.push.in;
import com.xiaomi.push.l;
import com.xiaomi.push.n;
import com.xiaomi.push.service.aq;
import com.xiaomi.push.service.receivers.NetworkStatusReceiver;
import com.xiaomi.push.t;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;

public abstract class MiPushClient {
    public static final String COMMAND_REGISTER = "register";
    public static final String COMMAND_UNREGISTER = "unregister";
    public static final String COMMAND_SET_ALIAS = "set-alias";
    public static final String COMMAND_UNSET_ALIAS = "unset-alias";
    public static final String COMMAND_SET_ACCOUNT = "set-account";
    public static final String COMMAND_UNSET_ACCOUNT = "unset-account";
    public static final String COMMAND_SUBSCRIBE_TOPIC = "subscribe-topic";
    public static final String COMMAND_UNSUBSCRIBE_TOPIC = "unsubscibe-topic";
    public static final String COMMAND_SET_ACCEPT_TIME = "accept-time";
    public static final String PREF_EXTRA = "mipush_extra";
    private static Context sContext;
    private static long sCurMsgId;

    public static boolean shouldUseMIUIPush(Context context) {
        return an.a(context).a();
    }

    public static void registerPush(Context context, String string, String string2) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration());
    }

    public static void registerPush(Context context, String string, String string2, String string3) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), string3, null);
    }

    public static void registerPush(Context context, String string, String string2, PushConfiguration pushConfiguration) {
        MiPushClient.registerPush(context, string, string2, pushConfiguration, null, null);
    }

    private static void registerPush(Context context, final String string, final String string2, PushConfiguration pushConfiguration, final String string3, final ICallbackResult iCallbackResult) {
        MiPushClient.checkNotNull(context, "context");
        MiPushClient.checkNotNull(string, "appID");
        MiPushClient.checkNotNull(string2, "appToken");
        sContext = context.getApplicationContext();
        if (sContext == null) {
            sContext = context;
        }
        context = sContext;
        t.a(context);
        if (!NetworkStatusReceiver.a()) {
            MiPushClient.registerNetworkReceiver(sContext);
        }
        f.a(sContext).a(pushConfiguration);
        ai.a(context).a(new Runnable(){

            @Override
            public void run() {
                MiPushClient.initialize(sContext, string, string2, null, string3, iCallbackResult);
            }
        });
    }

    private static void registerNetworkReceiver(Context context) {
        try {
            IntentFilter intentFilter = new IntentFilter();
            intentFilter.addAction("android.net.conn.CONNECTIVITY_CHANGE");
            intentFilter.addCategory("android.intent.category.DEFAULT");
            Context context2 = context.getApplicationContext();
            context2.registerReceiver((BroadcastReceiver)new NetworkStatusReceiver(null), intentFilter);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    @Deprecated
    public static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback) {
        MiPushClient.initialize(context, string, string2, miPushClientCallback, null, null);
    }

    private static void initialize(Context context, String string, String string2, MiPushClientCallback miPushClientCallback, String string3, ICallbackResult iCallbackResult) {
        try {
            boolean bl2;
            com.xiaomi.channel.commonutils.logger.b.a(context.getApplicationContext());
            com.xiaomi.channel.commonutils.logger.b.e("sdk_version = 3_8_5");
            if (miPushClientCallback != null) {
                PushMessageHandler.a(miPushClientCallback);
            }
            if (iCallbackResult != null) {
                PushMessageHandler.a(iCallbackResult);
            }
            if (t.a(sContext)) {
                u.a(sContext);
            }
            boolean bl3 = bl2 = b.a(sContext).a() != Constants.a();
            if (!bl2 && !MiPushClient.shouldSendRegRequest(sContext)) {
                an.a(sContext).a();
                com.xiaomi.channel.commonutils.logger.b.a("Could not send  register message within 5s repeatly .");
                return;
            }
            if (!bl2 && b.a(sContext).a(string, string2) && !b.a(sContext).f()) {
                Object object;
                Object object2;
                if (1 == PushMessageHelper.getPushMode(sContext)) {
                    MiPushClient.checkNotNull(miPushClientCallback, "callback");
                    miPushClientCallback.onInitializeResult(0L, null, b.a(sContext).c());
                } else {
                    object2 = new ArrayList<String>();
                    object2.add(b.a(sContext).c());
                    object = PushMessageHelper.generateCommandMessage(ev.a.a, object2, 0L, null, null);
                    PushMessageHelper.sendCommandMessageBroadcast(sContext, (MiPushCommandMessage)object);
                }
                an.a(sContext).a();
                if (b.a(sContext).a()) {
                    object2 = new ie();
                    ((ie)object2).b(b.a(sContext).a());
                    ((ie)object2).c(hp.g.a);
                    ((ie)object2).a(com.xiaomi.push.service.at.a());
                    ((ie)object2).a = new HashMap();
                    ((ie)object2).a.put("app_version", g.a(sContext, sContext.getPackageName()));
                    ((ie)object2).a.put("app_version_code", Integer.toString(g.a(sContext, sContext.getPackageName())));
                    ((ie)object2).a.put("push_sdk_vn", "3_8_5");
                    ((ie)object2).a.put("push_sdk_vc", Integer.toString(30805));
                    com.xiaomi.push.i.a(sContext, (Map<String, String>)((Object)((ie)object2).a));
                    object = b.a(sContext).e();
                    if (!TextUtils.isEmpty((CharSequence)object)) {
                        ((ie)object2).a.put("deviceid", object);
                    }
                    an.a(sContext).a(object2, hf.i, false, null);
                }
                if (!n.a(sContext, "update_devId", false)) {
                    MiPushClient.updateImeiOrOaid();
                    n.a(sContext, "update_devId", true);
                }
                if (!TextUtils.isEmpty((CharSequence)(object2 = com.xiaomi.push.i.c(sContext)))) {
                    object = new hz();
                    ((hz)object).a(com.xiaomi.push.service.at.a());
                    ((hz)object).b(string);
                    ((hz)object).c(ev.j.a);
                    ArrayList<String> arrayList = new ArrayList<String>();
                    String string4 = com.xiaomi.push.i.b(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string4)) {
                        arrayList.add(string4);
                    }
                    arrayList.add((String)(object2 != null ? object2 : ""));
                    arrayList.add(Build.MODEL != null ? Build.MODEL : "");
                    arrayList.add(Build.BOARD != null ? Build.BOARD : "");
                    ((hz)object).a(arrayList);
                    an.a(sContext).a(object, hf.j, false, null);
                }
                if (MiPushClient.shouldUseMIUIPush(sContext) && MiPushClient.shouldPullNotification(sContext)) {
                    object = new ie();
                    ((ie)object).b(b.a(sContext).a());
                    ((ie)object).c(hp.j.a);
                    ((ie)object).a(com.xiaomi.push.service.at.a());
                    ((ie)object).a(false);
                    an.a(sContext).a(object, hf.i, false, null, false);
                    MiPushClient.addPullNotificationTime(sContext);
                }
            } else {
                int n2;
                String string5;
                String string6 = bm.a(6);
                b.a(sContext).a();
                b.a(sContext).a(Constants.a());
                b.a(sContext).a(string, string2, string6);
                MiTinyDataClient.a.a().b("com.xiaomi.xmpushsdk.tinydataPending.appId");
                MiPushClient.clearExtras(sContext);
                MiPushClient.clearNotification(context);
                if if_ = new if();
                if_.a(com.xiaomi.push.service.at.a());
                if_.b(string);
                if_.e(string2);
                if_.d(sContext.getPackageName());
                if_.f(string6);
                if_.c(g.a(sContext, sContext.getPackageName()));
                if_.b(g.a(sContext, sContext.getPackageName()));
                if_.h("3_8_5");
                if_.a(30805);
                if_.a(ht.c);
                if (!TextUtils.isEmpty((CharSequence)string3)) {
                    if_.g(string3);
                }
                if (!l.d() && !TextUtils.isEmpty((CharSequence)(string5 = com.xiaomi.push.i.g(sContext)))) {
                    if_.i(bm.a(string5) + "," + com.xiaomi.push.i.j(sContext));
                }
                if ((n2 = com.xiaomi.push.i.a()) >= 0) {
                    if_.c(n2);
                }
                an.a(sContext).a(if_, bl2);
                sContext.getSharedPreferences(PREF_EXTRA, 4).getBoolean("mipush_registed", true);
            }
            MiPushClient.addRegRequestTime(sContext);
            MiPushClient.scheduleOcVersionCheckJob();
            MiPushClient.scheduleDataCollectionJobs(sContext);
            MiPushClient.initEventPerfLogic(sContext);
            au.a(sContext);
            if (!sContext.getPackageName().equals("com.xiaomi.xmsf")) {
                if (Logger.getUserLogger() != null) {
                    Logger.setLogger(sContext, Logger.getUserLogger());
                }
                com.xiaomi.channel.commonutils.logger.b.a(2);
            }
            MiPushClient.operateSyncAction(context);
        }
        catch (Throwable throwable) {
            com.xiaomi.channel.commonutils.logger.b.a(throwable);
        }
    }

    private static void scheduleOcVersionCheckJob() {
        int n2 = aq.a(sContext).a(hk.A.a(), 86400);
        ai.a(sContext).a(new ad(sContext), n2, 5);
    }

    private static void scheduleDataCollectionJobs(Context context) {
        int n2 = hk.z.a();
        if (aq.a(sContext).a(n2, MiPushClient.getDefaultSwitch())) {
            dj.a().a(new r(context));
            ai.a(sContext).a(new Runnable(){

                @Override
                public void run() {
                    dk.a(sContext);
                }
            }, 10);
        }
    }

    private static boolean getDefaultSwitch() {
        return l.b();
    }

    private static void updateImeiOrOaid() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (!l.d() && (com.xiaomi.push.i.f(sContext) != null || ax.a(sContext).a())) {
                    ie ie2 = new ie();
                    ie2.b(b.a(sContext).a());
                    ie2.c(hp.g.a);
                    ie2.a(com.xiaomi.push.service.at.a());
                    ie2.a(new HashMap<String, String>());
                    String string = "";
                    String string2 = com.xiaomi.push.i.f(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string2)) {
                        string = string + bm.a(string2);
                    }
                    String string3 = com.xiaomi.push.i.h(sContext);
                    if (!TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)string3)) {
                        string = string + "," + string3;
                    }
                    if (!TextUtils.isEmpty((CharSequence)string)) {
                        ie2.a().put("imei_md5", string);
                    }
                    ax.a(sContext).a(ie2.a());
                    com.xiaomi.push.i.a(sContext, (Map<String, String>)((Object)ie2.a));
                    int n2 = com.xiaomi.push.i.a();
                    if (n2 >= 0) {
                        ie2.a().put("space_id", Integer.toString(n2));
                    }
                    an.a(sContext).a(ie2, hf.i, false, null);
                }
            }
        }).start();
    }

    public static void awakeApps(final Context context, final String[] stringArray) {
        ai.a(context).a(new Runnable(){

            @Override
            public void run() {
                try {
                    for (String string : stringArray) {
                        PackageInfo packageInfo;
                        if (TextUtils.isEmpty((CharSequence)string) || (packageInfo = context.getPackageManager().getPackageInfo(string, 4)) == null) continue;
                        MiPushClient.awakePushServiceByPackageInfo(context, packageInfo);
                    }
                }
                catch (Throwable throwable) {
                    com.xiaomi.channel.commonutils.logger.b.a(throwable);
                }
            }
        });
    }

    private static void awakePushServiceByPackageInfo(Context context, PackageInfo packageInfo) {
        ServiceInfo[] serviceInfoArray = packageInfo.services;
        if (serviceInfoArray != null) {
            for (ServiceInfo serviceInfo : serviceInfoArray) {
                if (!serviceInfo.exported || !serviceInfo.enabled || !"com.xiaomi.mipush.sdk.PushMessageHandler".equals(serviceInfo.name) || context.getPackageName().equals(serviceInfo.packageName)) continue;
                try {
                    Thread.sleep((long)(Math.random() * 2.0 + 1.0) * 1000L);
                    Intent intent = new Intent();
                    intent.setClassName(serviceInfo.packageName, serviceInfo.name);
                    intent.setAction("com.xiaomi.mipush.sdk.WAKEUP");
                    intent.putExtra("waker_pkgname", context.getPackageName());
                    PushMessageHandler.a(context, intent);
                }
                catch (Throwable throwable) {}
                break;
            }
        }
    }

    public static List<String> getAllAlias(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("alias_")) continue;
            arrayList.add(string.substring("alias_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllTopic(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("topic_") || string.contains("**ALL**")) continue;
            arrayList.add(string.substring("topic_".length()));
        }
        return arrayList;
    }

    public static List<String> getAllUserAccount(Context context) {
        ArrayList<String> arrayList = new ArrayList<String>();
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        Set set = sharedPreferences.getAll().keySet();
        for (String string : set) {
            if (!string.startsWith("account_")) continue;
            arrayList.add(string.substring("account_".length()));
        }
        return arrayList;
    }

    protected static void clearExtras(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.clear();
        editor.commit();
    }

    static void reInitialize(Context context, ht ht2) {
        com.xiaomi.channel.commonutils.logger.b.e("re-register reason: " + (Object)((Object)ht2));
        String string = bm.a(6);
        String string2 = b.a(context).a();
        String string3 = b.a(context).b();
        b.a(context).a();
        MiPushClient.clearNotification(context);
        b.a(context).a(Constants.a());
        b.a(context).a(string2, string3, string);
        if if_ = new if();
        if_.a(com.xiaomi.push.service.at.a());
        if_.b(string2);
        if_.e(string3);
        if_.f(string);
        if_.d(context.getPackageName());
        if_.c(g.a(context, context.getPackageName()));
        if_.b(g.a(context, context.getPackageName()));
        if_.h("3_8_5");
        if_.a(30805);
        if_.a(ht2);
        int n2 = com.xiaomi.push.i.a();
        if (n2 >= 0) {
            if_.c(n2);
        }
        an.a(context).a(if_, false);
    }

    @Deprecated
    public static void reportMessageClicked(Context context, String string) {
        MiPushClient.reportMessageClicked(context, string, null, null);
    }

    public static void reportMessageClicked(Context context, MiPushMessage miPushMessage) {
        hs hs2 = new hs();
        hs2.a(miPushMessage.getMessageId());
        hs2.b(miPushMessage.getTopic());
        hs2.d(miPushMessage.getDescription());
        hs2.c(miPushMessage.getTitle());
        hs2.c(miPushMessage.getNotifyId());
        hs2.a(miPushMessage.getNotifyType());
        hs2.b(miPushMessage.getPassThrough());
        hs2.a(miPushMessage.getExtra());
        MiPushClient.reportMessageClicked(context, miPushMessage.getMessageId(), hs2, null);
    }

    /*
     * Enabled aggressive block sorting
     */
    static void reportMessageClicked(Context context, String string, hs hs2, String string2) {
        ie ie2 = new ie();
        if (TextUtils.isEmpty((CharSequence)string2)) {
            if (!b.a(context).b()) {
                com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
                return;
            }
            ie2.b(b.a(context).a());
        } else {
            ie2.b(string2);
        }
        ie2.c("bar:click");
        ie2.a(string);
        ie2.a(false);
        an.a(context).a(ie2, hf.i, false, hs2);
    }

    static void reportIgnoreRegMessageClicked(Context context, String string, hs hs2, String string2, String string3) {
        ie ie2 = new ie();
        if (TextUtils.isEmpty((CharSequence)string3)) {
            com.xiaomi.channel.commonutils.logger.b.d("do not report clicked message");
            return;
        }
        ie2.b(string3);
        ie2.c("bar:click");
        ie2.a(string);
        ie2.a(false);
        an.a(context).a(ie2, hf.i, false, true, hs2, true, string2, string3);
    }

    public static void setLocalNotificationType(Context context, int n2) {
        int n3 = n2 & 0xFFFFFFFF;
        an.a(context).b(n3);
    }

    public static void clearLocalNotificationType(Context context) {
        an.a(context).e();
    }

    public static void unregisterPush(Context context) {
        i.c(context);
        aq.a(context).a();
        if (!b.a(context).b()) {
            return;
        }
        il il2 = new il();
        il2.a(com.xiaomi.push.service.at.a());
        il2.b(b.a(context).a());
        il2.c(b.a(context).c());
        il2.e(b.a(context).b());
        il2.d(context.getPackageName());
        an.a(context).a(il2);
        PushMessageHandler.a();
        PushMessageHandler.b();
        b.a(context).b();
        MiPushClient.clearLocalNotificationType(context);
        MiPushClient.clearNotification(context);
        MiPushClient.clearExtras(context);
    }

    public static void disablePush(Context context) {
        an.a(context).a(true);
    }

    public static void enablePush(Context context) {
        an.a(context).a(false);
    }

    public static void syncAssemblePushToken(Context context) {
        an.a(context).a(null, at.c, e.a);
    }

    public static void syncAssembleFCMPushToken(Context context) {
        an.a(context).a(null, at.d, e.b);
    }

    public static void syncAssembleCOSPushToken(Context context) {
        an.a(context).a(null, at.e, e.c);
    }

    public static void syncAssembleFTOSPushToken(Context context) {
        an.a(context).a(null, at.f, e.d);
    }

    public static void setAlias(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ev.c.a, string, string2);
        }
    }

    public static void unsetAlias(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ev.d.a, string, string2);
    }

    public static void setUserAccount(Context context, String string, String string2) {
        if (!TextUtils.isEmpty((CharSequence)string)) {
            MiPushClient.setCommand(context, ev.e.a, string, string2);
        }
    }

    public static void unsetUserAccount(Context context, String string, String string2) {
        MiPushClient.setCommand(context, ev.f.a, string, string2);
    }

    public static void subscribe(Context context, String string, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a()) || TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (Math.abs(System.currentTimeMillis() - MiPushClient.topicSubscribedTime(context, string)) > 86400000L) {
            ij ij2 = new ij();
            String string3 = com.xiaomi.push.service.at.a();
            ij2.a(string3);
            ij2.b(b.a(context).a());
            ij2.c(string);
            ij2.d(context.getPackageName());
            ij2.e(string2);
            com.xiaomi.channel.commonutils.logger.b.e("cmd:" + (Object)((Object)ev.g) + ", " + string3);
            an.a(context).a(ij2, hf.c, null);
        } else if (1 == PushMessageHelper.getPushMode(context)) {
            PushMessageHandler.a(context, string2, 0L, null, string);
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ev.g.a, arrayList, 0L, null, null);
            PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
        }
    }

    public static void unsubscribe(Context context, String string, String string2) {
        if (!b.a(context).b()) {
            return;
        }
        if (MiPushClient.topicSubscribedTime(context, string) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel subscribe for " + string + " is unsubscribed");
            return;
        }
        in in2 = new in();
        String string3 = com.xiaomi.push.service.at.a();
        in2.a(string3);
        in2.b(b.a(context).a());
        in2.c(string);
        in2.d(context.getPackageName());
        in2.e(string2);
        com.xiaomi.channel.commonutils.logger.b.e("cmd:" + (Object)((Object)ev.h) + ", " + string3);
        an.a(context).a(in2, hf.d, null);
    }

    public static void pausePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 0, 0, string);
    }

    public static void resumePush(Context context, String string) {
        MiPushClient.setAcceptTime(context, 0, 0, 23, 59, string);
    }

    public static void clearNotification(Context context, int n2) {
        an.a(context).a(n2);
    }

    public static void clearNotification(Context context, String string, String string2) {
        an.a(context).a(string, string2);
    }

    public static void clearNotification(Context context) {
        an.a(context).a(-1);
    }

    public static void reportAppRunInBackground(Context context, boolean bl2) {
        if (!b.a(context).b()) {
            return;
        }
        hp hp2 = bl2 ? hp.R : hp.Q;
        ie ie2 = new ie();
        ie2.b(b.a(context).a());
        ie2.c(hp2.a);
        ie2.d(context.getPackageName());
        ie2.a(com.xiaomi.push.service.at.a());
        ie2.a(false);
        an.a(context).a(ie2, hf.i, false, null, false);
    }

    public static String getRegId(Context context) {
        if (b.a(context).c()) {
            return b.a(context).c();
        }
        return null;
    }

    public static String getAppRegion(Context context) {
        if (b.a(context).c()) {
            return b.a(context).f();
        }
        return null;
    }

    protected static void setCommand(Context context, String string, String string2, String string3) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!TextUtils.isEmpty((CharSequence)string2)) {
            arrayList.add(string2);
        }
        if (ev.c.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.aliasSetTime(context, string2)) < 86400000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ev.c.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ev.d.a.equalsIgnoreCase(string) && MiPushClient.aliasSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel alias for " + bm.a(arrayList.toString(), 3) + " is unseted");
        } else if (ev.e.a.equalsIgnoreCase(string) && Math.abs(System.currentTimeMillis() - MiPushClient.accountSetTime(context, string2)) < 3600000L) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string3, string, 0L, null, arrayList);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ev.e.a, arrayList, 0L, null, string3);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else if (ev.f.a.equalsIgnoreCase(string) && MiPushClient.accountSetTime(context, string2) < 0L) {
            com.xiaomi.channel.commonutils.logger.b.a("Don't cancel account for " + bm.a(arrayList.toString(), 3) + " is unseted");
        } else {
            MiPushClient.setCommand(context, string, arrayList, string3);
        }
    }

    protected static void setCommand(Context context, String string, ArrayList<String> arrayList, String string2) {
        if (TextUtils.isEmpty((CharSequence)b.a(context).a())) {
            return;
        }
        hz hz2 = new hz();
        String string3 = com.xiaomi.push.service.at.a();
        hz2.a(string3);
        hz2.b(b.a(context).a());
        hz2.c(string);
        for (String string4 : arrayList) {
            hz2.a(string4);
        }
        hz2.e(string2);
        hz2.d(context.getPackageName());
        com.xiaomi.channel.commonutils.logger.b.e("cmd:" + string + ", " + string3);
        an.a(context).a(hz2, hf.j, null);
    }

    public static void setAcceptTime(Context context, int n2, int n3, int n4, int n5, String string) {
        if (n2 < 0 || n2 >= 24 || n4 < 0 || n4 >= 24 || n3 < 0 || n3 >= 60 || n5 < 0 || n5 >= 60) {
            throw new IllegalArgumentException("the input parameter is not valid.");
        }
        TimeZone timeZone = TimeZone.getTimeZone("GMT+08");
        TimeZone timeZone2 = TimeZone.getDefault();
        long l2 = 1440L;
        long l3 = (timeZone.getRawOffset() - timeZone2.getRawOffset()) / 1000 / 60;
        long l4 = ((long)(n2 * 60 + n3) + l3 + l2) % l2;
        long l5 = ((long)(n4 * 60 + n5) + l3 + l2) % l2;
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(String.format("%1$02d:%2$02d", l4 / 60L, l4 % 60L));
        arrayList.add(String.format("%1$02d:%2$02d", l5 / 60L, l5 % 60L));
        ArrayList<String> arrayList2 = new ArrayList<String>();
        arrayList2.add(String.format("%1$02d:%2$02d", n2, n3));
        arrayList2.add(String.format("%1$02d:%2$02d", n4, n5));
        if (MiPushClient.acceptTimeSet(context, (String)arrayList.get(0), (String)arrayList.get(1))) {
            if (1 == PushMessageHelper.getPushMode(context)) {
                PushMessageHandler.a(context, string, ev.i.a, 0L, null, arrayList2);
            } else {
                MiPushCommandMessage miPushCommandMessage = PushMessageHelper.generateCommandMessage(ev.i.a, arrayList2, 0L, null, null);
                PushMessageHelper.sendCommandMessageBroadcast(context, miPushCommandMessage);
            }
        } else {
            MiPushClient.setCommand(context, ev.i.a, arrayList, string);
        }
    }

    protected static boolean getOpenHmsPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return f.a(context).b(e.a);
    }

    protected static boolean getOpenFCMPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return f.a(context).b(e.b);
    }

    protected static boolean getOpenOPPOPush(Context context) {
        MiPushClient.checkNotNull(context, "context");
        return f.a(context).b(e.c);
    }

    protected static boolean getOpenVIVOPush(Context context) {
        return f.a(context).b(e.d);
    }

    private static void checkNotNull(Object object, String string) {
        if (object == null) {
            throw new IllegalArgumentException("param " + string + " is not nullable");
        }
    }

    static synchronized void addAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("alias_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAlias(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("alias_" + string).commit();
    }

    static synchronized void removeAllAliases(Context context) {
        List<String> list = MiPushClient.getAllAlias(context);
        for (String string : list) {
            MiPushClient.removeAlias(context, string);
        }
    }

    static synchronized void addAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("account_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeAccount(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("account_" + string).commit();
    }

    static synchronized void removeAllAccounts(Context context) {
        List<String> list = MiPushClient.getAllUserAccount(context);
        for (String string : list) {
            MiPushClient.removeAccount(context, string);
        }
    }

    static synchronized void addTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().putLong("topic_" + string, System.currentTimeMillis()).commit();
    }

    static synchronized void removeTopic(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        sharedPreferences.edit().remove("topic_" + string).commit();
    }

    static synchronized void removeAllTopics(Context context) {
        List<String> list = MiPushClient.getAllTopic(context);
        for (String string : list) {
            MiPushClient.removeTopic(context, string);
        }
    }

    static synchronized void addAcceptTime(Context context, String string, String string2) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putString("accept_time", string + "," + string2);
        com.xiaomi.push.r.a(editor);
    }

    static synchronized void removeAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.remove("accept_time");
        com.xiaomi.push.r.a(editor);
    }

    public static long topicSubscribedTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("topic_" + string, -1L);
    }

    public static long accountSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("account_" + string, -1L);
    }

    public static long aliasSetTime(Context context, String string) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getLong("alias_" + string, -1L);
    }

    private static boolean acceptTimeSet(Context context, String string, String string2) {
        String string3 = MiPushClient.getAcceptTime(context);
        return TextUtils.equals((CharSequence)string3, (CharSequence)(string + "," + string2));
    }

    protected static String getAcceptTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return sharedPreferences.getString("accept_time", "00:00-23:59");
    }

    private static void addPullNotificationTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_pull_notification", System.currentTimeMillis());
        com.xiaomi.push.r.a(editor);
    }

    private static boolean shouldPullNotification(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_pull_notification", -1L)) > 300000L;
    }

    private static void addRegRequestTime(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        SharedPreferences.Editor editor = sharedPreferences.edit();
        editor.putLong("last_reg_request", System.currentTimeMillis());
        com.xiaomi.push.r.a(editor);
    }

    private static boolean shouldSendRegRequest(Context context) {
        SharedPreferences sharedPreferences = context.getSharedPreferences(PREF_EXTRA, 0);
        return Math.abs(System.currentTimeMillis() - sharedPreferences.getLong("last_reg_request", -1L)) > 5000L;
    }

    private static void initEventPerfLogic(final Context context) {
        ek.a(new ek.a(){

            @Override
            public void uploader(Context context, hj hj2) {
                MiTinyDataClient.upload(context, hj2);
            }
        });
        Config config = ek.a(context);
        com.xiaomi.clientreport.manager.a.a(context).a("3_8_5");
        ClientReportClient.init(context, config, new ei(context), new ej(context));
        a.a(context);
        s.a(context, config);
        aq.a(context).a(new aq.a(100, "perf event job update"){

            @Override
            protected void onCallback() {
                ek.a(context);
            }
        });
    }

    @Deprecated
    public static void registerCrashHandler(Thread.UncaughtExceptionHandler uncaughtExceptionHandler) {
        Thread.setDefaultUncaughtExceptionHandler(uncaughtExceptionHandler);
    }

    private static void operateSyncAction(Context context) {
        if ("syncing".equals(ae.a(sContext).a(at.a))) {
            MiPushClient.disablePush(sContext);
        }
        if ("syncing".equals(ae.a(sContext).a(at.b))) {
            MiPushClient.enablePush(sContext);
        }
        if ("syncing".equals(ae.a(sContext).a(at.c))) {
            MiPushClient.syncAssemblePushToken(sContext);
        }
        if ("syncing".equals(ae.a(sContext).a(at.d))) {
            MiPushClient.syncAssembleFCMPushToken(sContext);
        }
        if ("syncing".equals(ae.a(sContext).a(at.e))) {
            MiPushClient.syncAssembleCOSPushToken(context);
        }
        if ("syncing".equals(ae.a(sContext).a(at.f))) {
            MiPushClient.syncAssembleFTOSPushToken(context);
        }
    }

    public static void registerToken(Context context, String string, String string2, String string3, UPSRegisterCallBack uPSRegisterCallBack) {
        MiPushClient.registerPush(context, string, string2, new PushConfiguration(), null, uPSRegisterCallBack);
    }

    public static void unRegisterToken(Context context, UPSUnRegisterCallBack uPSUnRegisterCallBack) {
        MiPushClient.unregisterPush(context);
        if (uPSUnRegisterCallBack != null) {
            TokenResult tokenResult = new TokenResult();
            tokenResult.setToken(null);
            tokenResult.getToken();
            tokenResult.setResultCode(0L);
            tokenResult.getResultCode();
            uPSUnRegisterCallBack.onResult(tokenResult);
        }
    }

    public static void turnOnPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.enablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    public static void turnOffPush(Context context, UPSTurnCallBack uPSTurnCallBack) {
        MiPushClient.disablePush(context);
        if (uPSTurnCallBack != null) {
            CodeResult codeResult = new CodeResult();
            codeResult.setResultCode(0L);
            codeResult.getResultCode();
            uPSTurnCallBack.onResult(codeResult);
        }
    }

    static {
        sCurMsgId = System.currentTimeMillis();
    }

    public static class CodeResult {
        private long resultCode = -1L;

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static class TokenResult {
        private String token = null;
        private long resultCode = -1L;

        protected void setToken(String string) {
            this.token = string;
        }

        public String getToken() {
            return this.token;
        }

        protected void setResultCode(long l2) {
            this.resultCode = l2;
        }

        public long getResultCode() {
            return this.resultCode;
        }
    }

    public static interface UPSTurnCallBack
    extends ICallbackResult<CodeResult> {
    }

    public static interface UPSUnRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface UPSRegisterCallBack
    extends ICallbackResult<TokenResult> {
    }

    public static interface ICallbackResult<R> {
        public void onResult(R var1);
    }

    @Deprecated
    public static abstract class MiPushClientCallback {
        private String category;

        protected String getCategory() {
            return this.category;
        }

        protected void setCategory(String string) {
            this.category = string;
        }

        public void onReceiveMessage(String string, String string2, String string3, boolean bl2) {
        }

        public void onReceiveMessage(MiPushMessage miPushMessage) {
        }

        public void onInitializeResult(long l2, String string, String string2) {
        }

        public void onSubscribeResult(long l2, String string, String string2) {
        }

        public void onUnsubscribeResult(long l2, String string, String string2) {
        }

        public void onCommandResult(String string, long l2, String string2, List<String> list) {
        }
    }
}

