/*
 * Decompiled with CFR 0.152.
 */
package com.xiaomi.clientreport.data;

import android.content.Context;
import android.text.TextUtils;
import com.xiaomi.clientreport.data.b;
import com.xiaomi.push.cb;

public class Config {
    public static final boolean DEFAULT_EVENT_ENCRYPTED = true;
    public static final boolean DEFAULT_EVENT_UPLOAD_SWITCH_OPEN = false;
    public static final boolean DEFAULT_PERF_UPLOAD_SWITCH_OPEN = false;
    public static final long DEFAULT_MAX_FILE_LENGTH = 0x100000L;
    public static final long DEFAULT_PERF_UPLOAD_FREQUENCY = 86400L;
    public static final long DEFAULT_EVENT_UPLOAD_FREQUENCY = 86400L;
    private String mAESKey;
    private boolean mEventEncrypted = true;
    private boolean mEventUploadSwitchOpen = false;
    private boolean mPerfUploadSwitchOpen = false;
    private long mMaxFileLength = 0x100000L;
    private long mEventUploadFrequency = 86400L;
    private long mPerfUploadFrequency = 86400L;

    private Config() {
    }

    private Config(Context context, Builder builder) {
        this.mEventEncrypted = builder.mEventEncrypted == 0 ? false : (builder.mEventEncrypted == 1 ? true : true);
        this.mAESKey = !TextUtils.isEmpty((CharSequence)builder.mAESKey) ? builder.mAESKey : cb.a(context);
        this.mMaxFileLength = builder.mMaxFileLength > -1L ? builder.mMaxFileLength : 0x100000L;
        this.mEventUploadFrequency = builder.mEventUploadFrequency > -1L ? builder.mEventUploadFrequency : 86400L;
        this.mPerfUploadFrequency = builder.mPerfUploadFrequency > -1L ? builder.mPerfUploadFrequency : 86400L;
        this.mEventUploadSwitchOpen = builder.mEventUploadSwitchOpen == 0 ? false : builder.mEventUploadSwitchOpen == 1;
        this.mPerfUploadSwitchOpen = builder.mPerfUploadSwitchOpen == 0 ? false : builder.mPerfUploadSwitchOpen == 1;
    }

    public static Config defaultConfig(Context context) {
        Config config = Config.getBuilder().setEventEncrypted(true).setAESKey(cb.a(context)).setMaxFileLength(0x100000L).setEventUploadSwitchOpen(false).setEventUploadFrequency(86400L).setPerfUploadSwitchOpen(false).setPerfUploadFrequency(86400L).build(context);
        return config;
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    public boolean isEventEncrypted() {
        return this.mEventEncrypted;
    }

    public boolean isEventUploadSwitchOpen() {
        return this.mEventUploadSwitchOpen;
    }

    public boolean isPerfUploadSwitchOpen() {
        return this.mPerfUploadSwitchOpen;
    }

    public long getMaxFileLength() {
        return this.mMaxFileLength;
    }

    public long getEventUploadFrequency() {
        return this.mEventUploadFrequency;
    }

    public long getPerfUploadFrequency() {
        return this.mPerfUploadFrequency;
    }

    public String toString() {
        return "Config{mEventEncrypted=" + this.mEventEncrypted + ", mAESKey='" + this.mAESKey + '\'' + ", mMaxFileLength=" + this.mMaxFileLength + ", mEventUploadSwitchOpen=" + this.mEventUploadSwitchOpen + ", mPerfUploadSwitchOpen=" + this.mPerfUploadSwitchOpen + ", mEventUploadFrequency=" + this.mEventUploadFrequency + ", mPerfUploadFrequency=" + this.mPerfUploadFrequency + '}';
    }

    /* synthetic */ Config(Context context, Builder builder, b b2) {
        this(context, builder);
    }

    public static class Builder {
        private int mEventEncrypted = -1;
        private int mEventUploadSwitchOpen = -1;
        private int mPerfUploadSwitchOpen = -1;
        private String mAESKey = null;
        private long mMaxFileLength = -1L;
        private long mEventUploadFrequency = -1L;
        private long mPerfUploadFrequency = -1L;

        public Builder setEventEncrypted(boolean bl2) {
            this.mEventEncrypted = bl2 ? 1 : 0;
            return this;
        }

        public Builder setAESKey(String string) {
            this.mAESKey = string;
            return this;
        }

        public Builder setMaxFileLength(long l2) {
            this.mMaxFileLength = l2;
            return this;
        }

        public Builder setEventUploadSwitchOpen(boolean bl2) {
            this.mEventUploadSwitchOpen = bl2 ? 1 : 0;
            return this;
        }

        public Builder setPerfUploadSwitchOpen(boolean bl2) {
            this.mPerfUploadSwitchOpen = bl2 ? 1 : 0;
            return this;
        }

        public Builder setEventUploadFrequency(long l2) {
            this.mEventUploadFrequency = l2;
            return this;
        }

        public Builder setPerfUploadFrequency(long l2) {
            this.mPerfUploadFrequency = l2;
            return this;
        }

        public Config build(Context context) {
            return new Config(context, this, null);
        }
    }
}

