/*
 * Decompiled with CFR 0.152.
 */
package org.android.agoo.xiaomi;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.text.TextUtils;
import com.taobao.accs.utl.ALog;
import com.taobao.accs.utl.UtilityImpl;
import com.taobao.agoo.BaseNotifyClickActivity;
import com.xiaomi.mipush.sdk.MiPushClient;
import com.xiaomi.mipush.sdk.MiPushMessage;

public class MiPushRegistar {
    private static final String TAG = "MiPushRegistar";
    private static final String XIAOMI = "xiaomi";
    private static final String REDMI = "redmi";
    private static final String BLACKSHARK = "blackshark";
    private static final String brand;

    public static boolean checkDevice() {
        return XIAOMI.equals(brand) || REDMI.equals(brand) || BLACKSHARK.equals(brand);
    }

    public static void register(Context context, String xiaomiId, String xiaomiKey, boolean ignoreBrand) {
        try {
            if (!UtilityImpl.isMainProcess((Context)context)) {
                ALog.e((String)TAG, (String)"register not in main process, return", (Object[])new Object[0]);
                return;
            }
            if (MiPushRegistar.checkDevice() || ignoreBrand) {
                ALog.i((String)TAG, (String)"register begin", (Object[])new Object[0]);
                BaseNotifyClickActivity.addNotifyListener((BaseNotifyClickActivity.INotifyListener)new XiaoMiNotifyListener());
                MiPushClient.registerPush((Context)context, (String)xiaomiId, (String)xiaomiKey);
            }
        }
        catch (Throwable t) {
            ALog.e((String)TAG, (String)"register", (Throwable)t, (Object[])new Object[0]);
        }
    }

    public static void register(Context context, String xiaomiId, String xiaomiKey) {
        MiPushRegistar.register(context, xiaomiId, xiaomiKey, false);
    }

    public static void unregister(Context context) {
        try {
            MiPushClient.unregisterPush((Context)context);
        }
        catch (Throwable e) {
            ALog.e((String)TAG, (String)"unregister", (Throwable)e, (Object[])new Object[0]);
        }
    }

    static {
        String tmpBrand = TextUtils.isEmpty((CharSequence)Build.BRAND) ? Build.MANUFACTURER : Build.BRAND;
        brand = tmpBrand == null ? "" : tmpBrand.toLowerCase();
    }

    private static class XiaoMiNotifyListener
    implements BaseNotifyClickActivity.INotifyListener {
        private XiaoMiNotifyListener() {
        }

        public String parseMsgFromIntent(Intent intent) {
            String msg = null;
            try {
                MiPushMessage miPushMessage = (MiPushMessage)intent.getSerializableExtra("key_message");
                msg = miPushMessage.getContent();
            }
            catch (Exception exception) {
                // empty catch block
            }
            ALog.i((String)MiPushRegistar.TAG, (String)"parseMsgFromIntent", (Object[])new Object[]{"msg", msg});
            return msg;
        }

        public String getMsgSource() {
            return MiPushRegistar.XIAOMI;
        }

        public String toString() {
            return "INotifyListener: " + this.getMsgSource();
        }
    }
}

