/*
 * Copyright 2019 Ping Identity Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License (GPLv2 only)
 * or the terms of the GNU Lesser General Public License (LGPLv2.1 only)
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses>.
 */
package com.unboundid.scim.tools;



import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;



/**
 * This enum defines a set of message keys for messages in the
 * com.unboundid.scim.tools package, which correspond to messages in the
 * scim.sdk.properties properties file.
 * <BR><BR>
 * This source file was generated from the properties file.
 * Do not edit it directly.
 */
enum ToolMessages
{
  /**
   * Unable to parse the filter pattern: {0}
   */
  ERR_QUERY_TOOL_BAD_FILTER_PATTERN("Unable to parse the filter pattern: {0}"),



  /**
   * Unable to parse the resource ID pattern: {0}
   */
  ERR_QUERY_TOOL_BAD_RESOURCE_ID_PATTERN("Unable to parse the resource ID pattern: {0}"),



  /**
   * Unable to create a valid URL from the provided hostname, port and contextPath values: {0}
   */
  ERR_QUERY_TOOL_CANNOT_CREATE_URL("Unable to create a valid URL from the provided hostname, port and contextPath values: {0}"),



  /**
   * Error retrieving resource schema: {0}
   */
  ERR_QUERY_TOOL_RETRIEVE_RESOURCE_SCHEMA("Error retrieving resource schema: {0}"),



  /**
   * Unable to set basic authentication: {0}
   */
  ERR_QUERY_TOOL_SET_BASIC_AUTH("Unable to set basic authentication: {0}"),



  /**
   * Unable to create the key manager for secure communication:  {0}
   */
  ERR_SCIM_TOOL_CANNOT_CREATE_KEY_MANAGER("Unable to create the key manager for secure communication:  {0}"),



  /**
   * Unable to create the SSL context to use for secure communication with the server:  {0}
   */
  ERR_SCIM_TOOL_CANNOT_CREATE_SSL_CONTEXT("Unable to create the SSL context to use for secure communication with the server:  {0}"),



  /**
   * Unable to read the key store password:  {0}
   */
  ERR_SCIM_TOOL_CANNOT_READ_KEY_STORE_PASSWORD("Unable to read the key store password:  {0}"),



  /**
   * Unable to read the trust store password:  {0}
   */
  ERR_SCIM_TOOL_CANNOT_READ_TRUST_STORE_PASSWORD("Unable to read the trust store password:  {0}"),



  /**
   * The name of an attribute to include in resources returned from the queries.  Multiple attributes may be requested by providing this argument multiple times.  If no request attributes are provided, then the resources returned will include all available attributes.
   */
  INFO_QUERY_TOOL_ARG_DESC_ATTRIBUTE("The name of an attribute to include in resources returned from the queries.  Multiple attributes may be requested by providing this argument multiple times.  If no request attributes are provided, then the resources returned will include all available attributes."),



  /**
   * The ID to use to authenticate to the server when performing basic authentication.
   */
  INFO_QUERY_TOOL_ARG_DESC_AUTHID("The ID to use to authenticate to the server when performing basic authentication."),



  /**
   * The password to use to authenticate to the server when performing basic authentication or a password-based SASL mechanism.
   */
  INFO_QUERY_TOOL_ARG_DESC_AUTH_PASSWORD("The password to use to authenticate to the server when performing basic authentication or a password-based SASL mechanism."),



  /**
   * The path to a file containing the password to use to authenticate to the server when performing basic authentication or a password-based SASL mechanism.
   */
  INFO_QUERY_TOOL_ARG_DESC_AUTH_PASSWORD_FILE("The path to a file containing the password to use to authenticate to the server when performing basic authentication or a password-based SASL mechanism."),



  /**
   * The OAuth2 bearer token to use when authenticating to the server via OAuth
   */
  INFO_QUERY_TOOL_ARG_DESC_BEARER_TOKEN("The OAuth2 bearer token to use when authenticating to the server via OAuth"),



  /**
   * The context path of the SCIM server.  If no context path is specified, then the default value '/' is used.
   */
  INFO_QUERY_TOOL_ARG_DESC_CONTEXT_PATH("The context path of the SCIM server.  If no context path is specified, then the default value '/' is used."),



  /**
   * Generate output in CSV format rather than a display-friendly format.
   */
  INFO_QUERY_TOOL_ARG_DESC_CSV_FORMAT("Generate output in CSV format rather than a display-friendly format."),



  /**
   * The filter to use for the queries.  It may be a simple filter, or it may be a value pattern to express a range of filters (e.g., 'userName eq "user.[1-1000]"'). If this isn't specified, then no filtering is requested.
   */
  INFO_QUERY_TOOL_ARG_DESC_FILTER("The filter to use for the queries.  It may be a simple filter, or it may be a value pattern to express a range of filters (e.g., 'userName eq \"user.[1-1000]\"'). If this isn't specified, then no filtering is requested."),



  /**
   * The IP address or resolvable name to use to connect to the server.  If this is not provided, then a default value of 'localhost' will be used.
   */
  INFO_QUERY_TOOL_ARG_DESC_HOSTNAME("The IP address or resolvable name to use to connect to the server.  If this is not provided, then a default value of 'localhost' will be used."),



  /**
   * The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used.
   */
  INFO_QUERY_TOOL_ARG_DESC_INTERVAL_DURATION("The length of time in seconds between output lines.  If this is not provided, then a default interval of five seconds will be used."),



  /**
   * The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted.
   */
  INFO_QUERY_TOOL_ARG_DESC_NUM_INTERVALS("The maximum number of intervals for which to run.  If this is not provided, then the tool will run until it is interrupted."),



  /**
   * The number of threads to use to perform the queries.  If this is not provided, then a default of one thread will be used.
   */
  INFO_QUERY_TOOL_ARG_DESC_NUM_THREADS("The number of threads to use to perform the queries.  If this is not provided, then a default of one thread will be used."),



  /**
   * The port to use to connect to the server.  If this is not provided, then a default value of 80 will be used.
   */
  INFO_QUERY_TOOL_ARG_DESC_PORT("The port to use to connect to the server.  If this is not provided, then a default value of 80 will be used."),



  /**
   * Specifies the seed to use for the random number generator.
   */
  INFO_QUERY_TOOL_ARG_DESC_RANDOM_SEED("Specifies the seed to use for the random number generator."),



  /**
   * The target number of queries to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If this option is not provided, then the tool will run at the maximum rate for the specified number of threads.
   */
  INFO_QUERY_TOOL_ARG_DESC_RATE_PER_SECOND("The target number of queries to perform per second.  It is still necessary to specify a sufficient number of threads for achieving this rate.  If this option is not provided, then the tool will run at the maximum rate for the specified number of threads."),



  /**
   * The ID of a SCIM resource. It may be a literal SCIM resource identifier, or it may be a value pattern to express a range of resource IDs (e.g., 'uid=user.[1-1000],ou=people,dc=example,dc=com'). This may not be used in conjunction with the "--filter" argument.
   */
  INFO_QUERY_TOOL_ARG_DESC_RESOURCE_ID("The ID of a SCIM resource. It may be a literal SCIM resource identifier, or it may be a value pattern to express a range of resource IDs (e.g., 'uid=user.[1-1000],ou=people,dc=example,dc=com'). This may not be used in conjunction with the \"--filter\" argument."),



  /**
   * The name of resources to be queried.  If this isn't specified, then a default of 'User' will be used.
   */
  INFO_QUERY_TOOL_ARG_DESC_RESOURCE_NAME("The name of resources to be queried.  If this isn't specified, then a default of 'User' will be used."),



  /**
   * Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included.
   */
  INFO_QUERY_TOOL_ARG_DESC_TIMESTAMP_FORMAT("Indicates the format to use for timestamps included in the output.  A value of 'none' indicates that no timestamps should be included.  A value of 'with-date' indicates that both the date and the time should be included.  A value of 'without-date' indicates that only the time should be included."),



  /**
   * The number of intervals to complete before beginning overall statistics collection.  Specifying a non-zero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results.
   */
  INFO_QUERY_TOOL_ARG_DESC_WARM_UP_INTERVALS("The number of intervals to complete before beginning overall statistics collection.  Specifying a non-zero number of warm-up intervals gives the client and server a chance to warm up without skewing performance results."),



  /**
   * Use XML format in requests rather than JSON format.
   */
  INFO_QUERY_TOOL_ARG_DESC_XML_FORMAT("Use XML format in requests rather than JSON format."),



  /**
   * {name}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_ATTRIBUTE("{name}"),



  /**
   * {userName}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTHID("{userName}"),



  /**
   * {password}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTH_PASSWORD("{password}"),



  /**
   * {path}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_AUTH_PASSWORD_FILE("{path}"),



  /**
   * {b64 token}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_BEARER_TOKEN("{b64 token}"),



  /**
   * {path}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_CONTEXT_PATH("{path}"),



  /**
   * {filter}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_FILTER("{filter}"),



  /**
   * {host}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_HOSTNAME("{host}"),



  /**
   * {num}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_INTERVAL_DURATION("{num}"),



  /**
   * {num}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_NUM_INTERVALS("{num}"),



  /**
   * {num}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_NUM_THREADS("{num}"),



  /**
   * {port}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_PORT("{port}"),



  /**
   * {value}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_RANDOM_SEED("{value}"),



  /**
   * {queries-per-second}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_RATE_PER_SECOND("{queries-per-second}"),



  /**
   * {resource}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_RESOURCE_ID("{resource}"),



  /**
   * {resource-name}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_RESOURCE_NAME("{resource-name}"),



  /**
   * {format}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_TIMESTAMP_FORMAT("{format}"),



  /**
   * {num}
   */
  INFO_QUERY_TOOL_ARG_PLACEHOLDER_WARM_UP_INTERVALS("{num}"),



  /**
   * Perform repeated resource queries against a SCIM server.
   */
  INFO_QUERY_TOOL_DESC("Perform repeated resource queries against a SCIM server."),



  /**
   * Test query performance by querying randomly across a set of one million users with eight concurrent threads.  The user resources returned to the client will be in XML format and will include the userName and name attributes.
   */
  INFO_QUERY_TOOL_EXAMPLE_1("Test query performance by querying randomly across a set of one million users with eight concurrent threads.  The user resources returned to the client will be in XML format and will include the userName and name attributes."),



  /**
   * Test resource lookup performance by querying randomly across a set of one million user resource IDs with eight concurrent threads. The user resources returned to the client will be in JSON format and will include the userName and name attributes.
   */
  INFO_QUERY_TOOL_EXAMPLE_2("Test resource lookup performance by querying randomly across a set of one million user resource IDs with eight concurrent threads. The user resources returned to the client will be in JSON format and will include the userName and name attributes."),



  /**
   * Warm-up completed.  Beginning overall statistics collection.
   */
  INFO_QUERY_TOOL_WARM_UP_COMPLETED("Warm-up completed.  Beginning overall statistics collection."),



  /**
   * The nickname (alias) of the client certificate in the key store to present to the SCIM server for SSL client authentication.
   */
  INFO_SCIM_TOOL_DESCRIPTION_CERT_NICKNAME("The nickname (alias) of the client certificate in the key store to present to the SCIM server for SSL client authentication."),



  /**
   * The format (e.g., jks, jceks, pkcs12, etc.) for the key store file.
   */
  INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_FORMAT("The format (e.g., jks, jceks, pkcs12, etc.) for the key store file."),



  /**
   * The password to use to access the key store contents.
   */
  INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PASSWORD("The password to use to access the key store contents."),



  /**
   * The path to the file containing the password to use to access the key store contents.
   */
  INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the key store contents."),



  /**
   * The path to the file to use as the key store for obtaining client certificates when communicating securely with the SCIM server.
   */
  INFO_SCIM_TOOL_DESCRIPTION_KEY_STORE_PATH("The path to the file to use as the key store for obtaining client certificates when communicating securely with the SCIM server."),



  /**
   * Trust any certificate presented by the SCIM server.
   */
  INFO_SCIM_TOOL_DESCRIPTION_TRUST_ALL("Trust any certificate presented by the SCIM server."),



  /**
   * The format (e.g., jks, jceks, pkcs12, etc.) for the trust store file.
   */
  INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_FORMAT("The format (e.g., jks, jceks, pkcs12, etc.) for the trust store file."),



  /**
   * The password to use to access the trust store contents.
   */
  INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD("The password to use to access the trust store contents."),



  /**
   * The path to the file containing the password to use to access the trust store contents.
   */
  INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PASSWORD_FILE("The path to the file containing the password to use to access the trust store contents."),



  /**
   * The path to the file to use as trust store when determining whether to trust a certificate presented by the SCIM server.
   */
  INFO_SCIM_TOOL_DESCRIPTION_TRUST_STORE_PATH("The path to the file to use as trust store when determining whether to trust a certificate presented by the SCIM server."),



  /**
   * Use SSL when communicating with the SCIM server.
   */
  INFO_SCIM_TOOL_DESCRIPTION_USE_SSL("Use SSL when communicating with the SCIM server."),



  /**
   * {nickname}
   */
  INFO_SCIM_TOOL_PLACEHOLDER_CERT_NICKNAME("{nickname}"),



  /**
   * {format}
   */
  INFO_SCIM_TOOL_PLACEHOLDER_FORMAT("{format}"),



  /**
   * {password}
   */
  INFO_SCIM_TOOL_PLACEHOLDER_PASSWORD("{password}"),



  /**
   * {path}
   */
  INFO_SCIM_TOOL_PLACEHOLDER_PATH("{path}");



  /**
   * The resource bundle that will be used to load the properties file.
   */
  private static final ResourceBundle RESOURCE_BUNDLE;
  static
  {
    ResourceBundle rb = null;
    try
    {
      rb = ResourceBundle.getBundle("scim.sdk");
    } catch (Exception e) {}
    RESOURCE_BUNDLE = rb;
  }



  /**
   * The map that will be used to hold the unformatted message strings, indexed by property name.
   */
  private static final ConcurrentHashMap<ToolMessages,String> MESSAGE_STRINGS = new ConcurrentHashMap<ToolMessages,String>();



  /**
   * The map that will be used to hold the message format objects, indexed by property name.
   */
  private static final ConcurrentHashMap<ToolMessages,MessageFormat> MESSAGES = new ConcurrentHashMap<ToolMessages,MessageFormat>();



  // The default text for this message
  private final String defaultText;



  /**
   * Creates a new message key.
   */
  private ToolMessages(final String defaultText)
  {
    this.defaultText = defaultText;
  }



  /**
   * Retrieves a localized version of the message.
   * This method should only be used for messages which do not take any arguments.
   *
   * @return  A localized version of the message.
   */
  public String get()
  {
    String s = MESSAGE_STRINGS.get(this);
    if (s == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        return defaultText;
      }
      else
      {
        s = RESOURCE_BUNDLE.getString(name());
        MESSAGE_STRINGS.putIfAbsent(this, s);
      }
    }
    return s;
  }



  /**
   * Retrieves a localized version of the message.
   *
   * @param  args  The arguments to use to format the message.
   *
   * @return  A localized version of the message.
   */
  public String get(final Object... args)
  {
    MessageFormat f = MESSAGES.get(this);
    if (f == null)
    {
      if (RESOURCE_BUNDLE == null)
      {
        f = new MessageFormat(defaultText);
      }
      else
      {
        f = new MessageFormat(RESOURCE_BUNDLE.getString(name()));
      }
      MESSAGES.putIfAbsent(this, f);
    }
    synchronized (f)
    {
      return f.format(args);
    }
  }



  /**
   * Retrieves a string representation of this message key.
   *
   * @return  A string representation of this message key.
   */
  @Override()
  public String toString()
  {
    return get();
  }
}

