/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.client.requests;

import com.unboundid.scim2.client.requests.ResourceReturningRequestBuilder;
import com.unboundid.scim2.common.ScimResource;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import jakarta.ws.rs.client.Invocation;
import jakarta.ws.rs.client.WebTarget;
import jakarta.ws.rs.core.Response;

public abstract class RetrieveRequestBuilder<T extends RetrieveRequestBuilder<T>>
extends ResourceReturningRequestBuilder<T> {
    @Nullable
    protected String version;

    private RetrieveRequestBuilder(@NotNull WebTarget target) {
        super(target);
    }

    @Override
    @NotNull
    Invocation.Builder buildRequest() {
        Invocation.Builder request = super.buildRequest();
        if (this.version != null) {
            request.header("If-None-Match", (Object)this.version);
        }
        return request;
    }

    public static final class Typed
    extends RetrieveRequestBuilder<Typed> {
        public Typed(@NotNull WebTarget target) {
            super(target);
        }

        @NotNull
        public Typed ifNoneMatch(@Nullable String version) {
            this.version = version;
            return this;
        }

        @NotNull
        public <T> T invoke(@NotNull Class<T> cls) throws ScimException {
            try (Response response = this.buildRequest().get();){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (T)object;
                }
                throw Typed.toScimException(response);
            }
        }
    }

    public static final class Generic<T extends ScimResource>
    extends RetrieveRequestBuilder<Generic<T>> {
        @NotNull
        private final T resource;

        public Generic(@NotNull WebTarget target, @NotNull T resource) {
            super(target);
            this.resource = resource;
        }

        @NotNull
        public Generic<T> ifNoneMatch() {
            this.version = Generic.getResourceVersion(this.resource);
            return this;
        }

        @NotNull
        public T invoke() throws ScimException {
            return (T)((ScimResource)this.invoke(this.resource.getClass()));
        }

        @NotNull
        public <C> C invoke(@NotNull Class<C> cls) throws ScimException {
            try (Response response = this.buildRequest().get();){
                if (response.getStatusInfo().getFamily() == Response.Status.Family.SUCCESSFUL) {
                    Object object = response.readEntity(cls);
                    return (C)object;
                }
                throw Generic.toScimException(response);
            }
        }
    }
}

