/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.utils.Parser;
import com.unboundid.scim2.common.utils.SchemaUtils;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

public final class Path
implements Iterable<Element> {
    @Nullable
    private final String schemaUrn;
    @NotNull
    private final List<Element> elements;

    private Path(@Nullable String schemaUrn, @NotNull List<Element> elements) {
        this.schemaUrn = schemaUrn;
        this.elements = Collections.unmodifiableList(elements);
    }

    @NotNull
    public Path attribute(@NotNull String attribute) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.add(new Element(attribute, null));
        return new Path(this.schemaUrn, newElements);
    }

    @NotNull
    public Path attribute(@NotNull String attribute, @Nullable Filter valueFilter) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.add(new Element(attribute, valueFilter));
        return new Path(this.schemaUrn, newElements);
    }

    @NotNull
    public Path attribute(@NotNull Path path) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements.size() + path.size());
        newElements.addAll(this.elements);
        newElements.addAll(path.elements);
        return new Path(this.schemaUrn, newElements);
    }

    @NotNull
    public Path replace(int index, @NotNull String attribute, @Nullable Filter valueFilter) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.set(index, new Element(attribute, valueFilter));
        return new Path(this.schemaUrn, newElements);
    }

    @NotNull
    public Path replace(int index, @NotNull String attribute) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.set(index, new Element(attribute, this.elements.get(index).getValueFilter()));
        return new Path(this.schemaUrn, newElements);
    }

    @NotNull
    public Path replace(int index, @Nullable Filter valueFilter) {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements);
        newElements.set(index, new Element(this.elements.get(index).getAttribute(), valueFilter));
        return new Path(this.schemaUrn, newElements);
    }

    @NotNull
    public Path subPath(int index) throws IndexOutOfBoundsException {
        return new Path(this.schemaUrn, this.elements.subList(0, index));
    }

    @Override
    @NotNull
    public Iterator<Element> iterator() {
        return this.elements.iterator();
    }

    @Nullable
    public Element getElement(int index) throws IndexOutOfBoundsException {
        return this.elements.get(index);
    }

    public boolean isRoot() {
        return this.elements.isEmpty();
    }

    public int size() {
        return this.elements.size();
    }

    @NotNull
    public Path withoutFilters() {
        ArrayList<Element> newElements = new ArrayList<Element>(this.elements.size());
        for (Element element : this.elements) {
            newElements.add(new Element(element.getAttribute(), null));
        }
        return new Path(this.schemaUrn, newElements);
    }

    @JsonCreator
    @NotNull
    public static Path fromString(@Nullable String pathString) throws BadRequestException {
        return Parser.parsePath(pathString);
    }

    @NotNull
    public static Path root() {
        return new Path(null, Collections.emptyList());
    }

    @NotNull
    public static Path root(@Nullable String schemaUrn) {
        if (schemaUrn != null && !SchemaUtils.isUrn(schemaUrn)) {
            throw new IllegalArgumentException(String.format("Invalid extension schema URN: %s", schemaUrn));
        }
        return new Path(schemaUrn, Collections.emptyList());
    }

    @NotNull
    public static <T> Path root(@NotNull Class<T> extensionClass) {
        return Path.root(SchemaUtils.getSchemaUrn(extensionClass));
    }

    @Nullable
    public String getSchemaUrn() {
        return this.schemaUrn;
    }

    public boolean equals(@NotNull Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        if (this.schemaUrn != null ? !this.schemaUrn.equalsIgnoreCase(path.schemaUrn) : path.schemaUrn != null) {
            return false;
        }
        return this.elements.equals(path.elements);
    }

    public int hashCode() {
        return Objects.hash(StaticUtils.toLowerCase(this.schemaUrn), this.elements);
    }

    @NotNull
    @JsonValue
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(@NotNull StringBuilder builder) {
        if (this.schemaUrn != null) {
            builder.append(this.schemaUrn);
            builder.append(":");
        }
        Iterator<Element> i = this.elements.iterator();
        while (i.hasNext()) {
            i.next().toString(builder);
            if (!i.hasNext()) continue;
            builder.append(".");
        }
    }

    public static final class Element {
        @NotNull
        private final String attribute;
        @Nullable
        private final Filter valueFilter;

        private Element(@NotNull String attribute, @Nullable Filter valueFilter) {
            this.attribute = attribute;
            this.valueFilter = valueFilter;
        }

        @NotNull
        public String getAttribute() {
            return this.attribute;
        }

        @Nullable
        public Filter getValueFilter() {
            return this.valueFilter;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Element element = (Element)o;
            if (!StaticUtils.toLowerCase(this.attribute).equals(StaticUtils.toLowerCase(element.attribute))) {
                return false;
            }
            return Objects.equals(this.valueFilter, element.valueFilter);
        }

        public int hashCode() {
            return Objects.hash(StaticUtils.toLowerCase(this.attribute), this.valueFilter);
        }

        @NotNull
        public String toString() {
            StringBuilder builder = new StringBuilder();
            this.toString(builder);
            return builder.toString();
        }

        public void toString(@NotNull StringBuilder builder) {
            builder.append(this.attribute);
            if (this.valueFilter != null) {
                builder.append("[");
                builder.append(this.valueFilter);
                builder.append("]");
            }
        }
    }
}

