/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.exceptions;

import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.ErrorResponse;

public class BadRequestException
extends ScimException {
    @NotNull
    public static final String INVALID_FILTER = "invalidFilter";
    @NotNull
    public static final String TOO_MANY = "tooMany";
    @NotNull
    public static final String UNIQUENESS = "uniqueness";
    @NotNull
    public static final String MUTABILITY = "mutability";
    @NotNull
    public static final String INVALID_SYNTAX = "invalidSyntax";
    @NotNull
    public static final String INVALID_PATH = "invalidPath";
    @NotNull
    public static final String NO_TARGET = "noTarget";
    @NotNull
    public static final String INVALID_VALUE = "invalidValue";
    @NotNull
    public static final String INVALID_VERSION = "invalidVersion";

    public BadRequestException(@Nullable String errorMessage) {
        this(errorMessage, (String)null);
    }

    public BadRequestException(@Nullable String errorMessage, @Nullable String scimType) {
        super(400, scimType, errorMessage);
    }

    public BadRequestException(@Nullable String errorMessage, @Nullable Throwable cause) {
        this(errorMessage, null, cause);
    }

    public BadRequestException(@Nullable String errorMessage, @Nullable String scimType, @Nullable Throwable cause) {
        super(400, scimType, errorMessage, cause);
    }

    public BadRequestException(@NotNull ErrorResponse scimError, @Nullable Throwable cause) {
        super(scimError, cause);
    }

    @NotNull
    public static BadRequestException invalidFilter(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, INVALID_FILTER);
    }

    @NotNull
    public static BadRequestException tooMany(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, TOO_MANY);
    }

    @NotNull
    public static BadRequestException uniqueness(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, UNIQUENESS);
    }

    @NotNull
    public static BadRequestException mutability(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, MUTABILITY);
    }

    @NotNull
    public static BadRequestException invalidSyntax(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, INVALID_SYNTAX);
    }

    @NotNull
    public static BadRequestException invalidPath(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, INVALID_PATH);
    }

    @NotNull
    public static BadRequestException noTarget(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, NO_TARGET);
    }

    @NotNull
    public static BadRequestException invalidValue(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, INVALID_VALUE);
    }

    @NotNull
    public static BadRequestException invalidVersion(@Nullable String errorMessage) {
        return new BadRequestException(errorMessage, INVALID_VERSION);
    }
}

