/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.filters;

import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.BadRequestException;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.AndFilter;
import com.unboundid.scim2.common.filters.ComplexValueFilter;
import com.unboundid.scim2.common.filters.ContainsFilter;
import com.unboundid.scim2.common.filters.EndsWithFilter;
import com.unboundid.scim2.common.filters.EqualFilter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.filters.FilterVisitor;
import com.unboundid.scim2.common.filters.GreaterThanFilter;
import com.unboundid.scim2.common.filters.GreaterThanOrEqualFilter;
import com.unboundid.scim2.common.filters.LessThanFilter;
import com.unboundid.scim2.common.filters.LessThanOrEqualFilter;
import com.unboundid.scim2.common.filters.NotEqualFilter;
import com.unboundid.scim2.common.filters.NotFilter;
import com.unboundid.scim2.common.filters.OrFilter;
import com.unboundid.scim2.common.filters.PresentFilter;
import com.unboundid.scim2.common.filters.StartsWithFilter;
import com.unboundid.scim2.common.utils.DateTimeUtils;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.Parser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public abstract class Filter {
    @NotNull
    public abstract FilterType getFilterType();

    @NotNull
    public abstract <R, P> R visit(@NotNull FilterVisitor<R, P> var1, @Nullable P var2) throws ScimException;

    public abstract void toString(@NotNull StringBuilder var1);

    public boolean isCombiningFilter() {
        return false;
    }

    @Nullable
    public List<Filter> getCombinedFilters() {
        return null;
    }

    public boolean isNotFilter() {
        return false;
    }

    @Nullable
    public Filter getInvertedFilter() {
        return null;
    }

    public boolean isComplexValueFilter() {
        return false;
    }

    @Nullable
    public Filter getValueFilter() {
        return null;
    }

    @Nullable
    public Path getAttributePath() {
        return null;
    }

    public boolean isComparisonFilter() {
        return false;
    }

    @Nullable
    public ValueNode getComparisonValue() {
        return null;
    }

    public boolean isPresentFilter() {
        return false;
    }

    @NotNull
    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    @NotNull
    public static Filter eq(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new EqualFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable Integer filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable Long filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable Double filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable Float filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable Boolean filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().booleanNode(filterValue.booleanValue()));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable byte[] filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().binaryNode(filterValue));
    }

    @NotNull
    public static Filter eq(@NotNull String attributePath, @Nullable Date filterValue) throws BadRequestException {
        return new EqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    @NotNull
    public static Filter ne(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new NotEqualFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable Integer filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable Long filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable Double filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable Float filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable Boolean filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().booleanNode(filterValue.booleanValue()));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable byte[] filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().binaryNode(filterValue));
    }

    @NotNull
    public static Filter ne(@NotNull String attributePath, @Nullable Date filterValue) throws BadRequestException {
        return new NotEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    @NotNull
    public static Filter co(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new ContainsFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter co(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new ContainsFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter sw(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new StartsWithFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter sw(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new StartsWithFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter ew(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new EndsWithFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter ew(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new EndsWithFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter pr(@NotNull Path attributePath) {
        return new PresentFilter(attributePath);
    }

    @NotNull
    public static Filter pr(@NotNull String attributePath) throws BadRequestException {
        return new PresentFilter(Path.fromString(attributePath));
    }

    @NotNull
    public static Filter gt(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new GreaterThanFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter gt(@NotNull String attributePath, @Nullable Integer filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter gt(@NotNull String attributePath, @Nullable Long filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter gt(@NotNull String attributePath, @Nullable Double filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter gt(@NotNull String attributePath, @Nullable Float filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter gt(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter gt(@NotNull String attributePath, @Nullable Date filterValue) throws BadRequestException {
        return new GreaterThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    @NotNull
    public static Filter ge(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new GreaterThanOrEqualFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter ge(@NotNull String attributePath, @Nullable Integer filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ge(@NotNull String attributePath, @Nullable Long filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ge(@NotNull String attributePath, @Nullable Double filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ge(@NotNull String attributePath, @Nullable Float filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter ge(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter ge(@NotNull String attributePath, @Nullable Date filterValue) throws BadRequestException {
        return new GreaterThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    @NotNull
    public static Filter lt(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new LessThanFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter lt(@NotNull String attributePath, @Nullable Integer filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter lt(@NotNull String attributePath, @Nullable Long filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter lt(@NotNull String attributePath, @Nullable Double filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter lt(@NotNull String attributePath, @Nullable Float filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter lt(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter lt(@NotNull String attributePath, @Nullable Date filterValue) throws BadRequestException {
        return new LessThanFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    @NotNull
    public static Filter le(@NotNull Path attributePath, @Nullable ValueNode filterValue) {
        return new LessThanOrEqualFilter(attributePath, filterValue);
    }

    @NotNull
    public static Filter le(@NotNull String attributePath, @Nullable Integer filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter le(@NotNull String attributePath, @Nullable Long filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter le(@NotNull String attributePath, @Nullable Double filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter le(@NotNull String attributePath, @Nullable Float filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), JsonUtils.getJsonNodeFactory().numberNode(filterValue));
    }

    @NotNull
    public static Filter le(@NotNull String attributePath, @Nullable String filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(filterValue));
    }

    @NotNull
    public static Filter le(@NotNull String attributePath, @Nullable Date filterValue) throws BadRequestException {
        return new LessThanOrEqualFilter(Path.fromString(attributePath), (ValueNode)JsonUtils.getJsonNodeFactory().textNode(DateTimeUtils.format(filterValue)));
    }

    @NotNull
    public static Filter and(@NotNull Filter filter1, @NotNull Filter filter2, Filter ... filters) {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(filter1);
        components.add(filter2);
        if (filters != null) {
            Collections.addAll(components, filters);
        }
        return new AndFilter(components);
    }

    @NotNull
    public static Filter and(@NotNull String filter1, @NotNull String filter2, String ... filters) throws BadRequestException {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(Filter.fromString(filter1));
        components.add(Filter.fromString(filter2));
        if (filters != null) {
            for (String filter : filters) {
                components.add(Filter.fromString(filter));
            }
        }
        return new AndFilter(components);
    }

    @NotNull
    public static Filter and(@NotNull List<Filter> filters) {
        if (filters.size() < 2) {
            throw new IllegalArgumentException("and logical filter must combine at least 2 filters");
        }
        return new AndFilter(new ArrayList<Filter>(filters));
    }

    @NotNull
    public static Filter or(@NotNull Filter filter1, @NotNull Filter filter2, Filter ... filters) {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(filter1);
        components.add(filter2);
        if (filters != null) {
            Collections.addAll(components, filters);
        }
        return new OrFilter(components);
    }

    @NotNull
    public static Filter or(@NotNull String filter1, @NotNull String filter2, String ... filters) throws BadRequestException {
        ArrayList<Filter> components = new ArrayList<Filter>(filters != null ? 2 + filters.length : 2);
        components.add(Filter.fromString(filter1));
        components.add(Filter.fromString(filter2));
        if (filters != null) {
            for (String filter : filters) {
                components.add(Filter.fromString(filter));
            }
        }
        return new OrFilter(components);
    }

    @NotNull
    public static Filter or(@NotNull List<Filter> filters) {
        if (filters.size() < 2) {
            throw new IllegalArgumentException("or logical filter must combine at least 2 filters");
        }
        return new OrFilter(new ArrayList<Filter>(filters));
    }

    @NotNull
    public static Filter not(@NotNull Filter filter) {
        return new NotFilter(filter);
    }

    @NotNull
    public static Filter not(@NotNull String filter) throws BadRequestException {
        return new NotFilter(Filter.fromString(filter));
    }

    @NotNull
    public static Filter hasComplexValue(@NotNull Path attributePath, @Nullable Filter valueFilter) {
        return Filter.complex(attributePath, valueFilter);
    }

    @NotNull
    public static Filter hasComplexValue(@NotNull String attributePath, @Nullable Filter valueFilter) throws BadRequestException {
        return Filter.complex(attributePath, valueFilter);
    }

    @NotNull
    public static Filter hasComplexValue(@NotNull String attributePath, @Nullable String valueFilter) throws BadRequestException {
        return Filter.complex(attributePath, valueFilter);
    }

    @NotNull
    public static Filter complex(@NotNull Path attributePath, @Nullable Filter valueFilter) {
        return new ComplexValueFilter(attributePath, valueFilter);
    }

    @NotNull
    public static Filter complex(@NotNull String attributePath, @Nullable Filter valueFilter) throws BadRequestException {
        return new ComplexValueFilter(Path.fromString(attributePath), valueFilter);
    }

    @NotNull
    public static Filter complex(@NotNull String attributePath, @Nullable String valueFilter) throws BadRequestException {
        return new ComplexValueFilter(Path.fromString(attributePath), Filter.fromString(valueFilter));
    }

    @NotNull
    public static Filter fromString(@NotNull String filterString) throws BadRequestException {
        return Parser.parseFilter(filterString);
    }
}

