/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.filters;

import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.filters.FilterVisitor;

public final class NotFilter
extends Filter {
    @NotNull
    private final Filter filterComponent;

    NotFilter(@NotNull Filter filterComponent) {
        this.filterComponent = filterComponent;
    }

    @Override
    public boolean isNotFilter() {
        return true;
    }

    @Override
    @Nullable
    public Filter getInvertedFilter() {
        return this.filterComponent;
    }

    @Override
    public void toString(@NotNull StringBuilder builder) {
        builder.append("not");
        builder.append(' ');
        builder.append('(');
        builder.append(this.filterComponent);
        builder.append(')');
    }

    @Override
    @NotNull
    public <R, P> R visit(@NotNull FilterVisitor<R, P> visitor, @Nullable P param) throws ScimException {
        return visitor.visit(this, param);
    }

    @Override
    @NotNull
    public FilterType getFilterType() {
        return FilterType.NOT;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NotFilter notFilter = (NotFilter)o;
        return this.filterComponent.equals(notFilter.filterComponent);
    }

    public int hashCode() {
        return this.filterComponent.hashCode();
    }
}

