/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.filters;

import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.filters.FilterType;
import com.unboundid.scim2.common.filters.FilterVisitor;

public final class PresentFilter
extends Filter {
    @NotNull
    private final Path filterAttribute;

    PresentFilter(@NotNull Path filterAttribute) {
        this.filterAttribute = filterAttribute;
    }

    @Override
    @Nullable
    public Path getAttributePath() {
        return this.filterAttribute;
    }

    @Override
    public boolean isPresentFilter() {
        return true;
    }

    @Override
    public void toString(@NotNull StringBuilder builder) {
        builder.append(this.filterAttribute);
        builder.append(' ');
        builder.append(FilterType.PRESENT.getStringValue());
    }

    @Override
    @NotNull
    public <R, P> R visit(@NotNull FilterVisitor<R, P> visitor, @Nullable P param) throws ScimException {
        return visitor.visit(this, param);
    }

    @Override
    @NotNull
    public FilterType getFilterType() {
        return FilterType.PRESENT;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PresentFilter that = (PresentFilter)o;
        return this.filterAttribute.equals(that.filterAttribute);
    }

    public int hashCode() {
        return this.filterAttribute.hashCode();
    }
}

