/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.messages;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.BaseScimResource;
import com.unboundid.scim2.common.GenericScimResource;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.exceptions.ScimException;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;

@Schema(id="urn:ietf:params:scim:api:messages:2.0:PatchOp", name="Patch Operation", description="SCIM 2.0 Patch Operation Request")
public final class PatchRequest
extends BaseScimResource
implements Iterable<PatchOperation> {
    @NotNull
    @Attribute(description="Patch Operations")
    @JsonProperty(value="Operations", required=true)
    private final List<PatchOperation> operations;

    @JsonCreator
    public PatchRequest(@NotNull @JsonProperty(value="Operations", required=true) List<PatchOperation> operations) {
        this.operations = Collections.unmodifiableList(operations);
    }

    public PatchRequest(@NotNull PatchOperation operation, PatchOperation ... operations) {
        this(StaticUtils.toList(operation, operations));
    }

    @NotNull
    public List<PatchOperation> getOperations() {
        return List.copyOf(this.operations);
    }

    @Override
    @NotNull
    public Iterator<PatchOperation> iterator() {
        return this.getOperations().iterator();
    }

    public void apply(@NotNull GenericScimResource object) throws ScimException {
        for (PatchOperation operation : this) {
            operation.apply(object.getObjectNode());
        }
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PatchRequest that = (PatchRequest)o;
        return this.operations.equals(that.operations);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.operations);
    }
}

