/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.Manager;
import java.util.Objects;

@Schema(id="urn:ietf:params:scim:schemas:extension:enterprise:2.0:User", name="EnterpriseUser", description="Enterprise User")
public class EnterpriseUserExtension {
    @Nullable
    @Attribute(description="Numeric or alphanumeric identifier assigned to a person, typically based on order of hire or association with an organization.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String employeeNumber;
    @Nullable
    @Attribute(description="Identifies the name of a cost center.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String costCenter;
    @Nullable
    @Attribute(description="Identifies the name of an organization.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String organization;
    @Nullable
    @Attribute(description="Identifies the name of a division.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String division;
    @Nullable
    @Attribute(description="Identifies the name of a department.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String department;
    @Nullable
    @Attribute(description="The User's manager.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Manager manager;

    @Nullable
    public String getEmployeeNumber() {
        return this.employeeNumber;
    }

    @NotNull
    public EnterpriseUserExtension setEmployeeNumber(@Nullable String employeeNumber) {
        this.employeeNumber = employeeNumber;
        return this;
    }

    @Nullable
    public String getCostCenter() {
        return this.costCenter;
    }

    @NotNull
    public EnterpriseUserExtension setCostCenter(@Nullable String costCenter) {
        this.costCenter = costCenter;
        return this;
    }

    @Nullable
    public String getOrganization() {
        return this.organization;
    }

    @NotNull
    public EnterpriseUserExtension setOrganization(@Nullable String organization) {
        this.organization = organization;
        return this;
    }

    @Nullable
    public String getDivision() {
        return this.division;
    }

    @NotNull
    public EnterpriseUserExtension setDivision(@Nullable String division) {
        this.division = division;
        return this;
    }

    @Nullable
    public String getDepartment() {
        return this.department;
    }

    @NotNull
    public EnterpriseUserExtension setDepartment(@Nullable String department) {
        this.department = department;
        return this;
    }

    @Nullable
    public Manager getManager() {
        return this.manager;
    }

    @NotNull
    public EnterpriseUserExtension setManager(@Nullable Manager manager) {
        this.manager = manager;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnterpriseUserExtension that = (EnterpriseUserExtension)o;
        if (!Objects.equals(this.employeeNumber, that.employeeNumber)) {
            return false;
        }
        if (!Objects.equals(this.costCenter, that.costCenter)) {
            return false;
        }
        if (!Objects.equals(this.organization, that.organization)) {
            return false;
        }
        if (!Objects.equals(this.division, that.division)) {
            return false;
        }
        if (!Objects.equals(this.department, that.department)) {
            return false;
        }
        return Objects.equals(this.manager, that.manager);
    }

    public int hashCode() {
        return Objects.hash(this.employeeNumber, this.costCenter, this.organization, this.division, this.department, this.manager);
    }
}

