/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.util.Objects;

public class InstantMessagingAddress {
    @Nullable
    @Attribute(description="Instant messaging address for the User.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String value;
    @Nullable
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;
    @Nullable
    @Attribute(description="A label indicating the attribute's function; e.g., 'aim', 'gtalk', 'mobile' etc.", isRequired=false, isCaseExact=false, canonicalValues={"aim", "gtalk", "icq", "xmpp", "msn", "skype", "qq", "yahoo"}, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Nullable
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute, e.g., the preferred messenger or primary messenger. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    @Nullable
    public String getValue() {
        return this.value;
    }

    @NotNull
    public InstantMessagingAddress setValue(@Nullable String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @NotNull
    public InstantMessagingAddress setDisplay(@Nullable String display) {
        this.display = display;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public InstantMessagingAddress setType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public InstantMessagingAddress setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstantMessagingAddress im = (InstantMessagingAddress)o;
        if (!Objects.equals(this.value, im.value)) {
            return false;
        }
        if (!Objects.equals(this.display, im.display)) {
            return false;
        }
        if (!Objects.equals(this.type, im.type)) {
            return false;
        }
        return Objects.equals(this.primary, im.primary);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.display, this.type, this.primary);
    }
}

