/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Nullable;
import java.util.Objects;

public class JsonReference<T> {
    private boolean set;
    @Nullable
    private T obj;

    public JsonReference() {
        this.set = false;
        this.obj = null;
    }

    public JsonReference(@Nullable T obj) {
        this.set = true;
        this.obj = obj;
    }

    public boolean isSet() {
        return this.set;
    }

    @Nullable
    public T getObjIfSet() {
        if (this.set) {
            return this.obj;
        }
        throw new RuntimeException("Invalid reference");
    }

    @Nullable
    public T getObj() {
        return this.set ? (T)this.obj : null;
    }

    @Nullable
    public static <T> T getObject(@Nullable JsonReference<T> jsonReference) {
        return jsonReference == null ? null : (T)jsonReference.getObj();
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JsonReference that = (JsonReference)o;
        if (this.set != that.set) {
            return false;
        }
        return Objects.equals(this.obj, that.obj);
    }

    public int hashCode() {
        return Objects.hash(this.set, this.obj);
    }
}

