/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.net.URI;
import java.util.Objects;

public class Manager {
    @Nullable
    @Attribute(description="The id of the SCIM resource representing the User's manager.", isRequired=true, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String value;
    @Nullable
    @Attribute(description="The URI of the SCIM resource representing the User's manager.", isRequired=true, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE, referenceTypes={"User"})
    @JsonProperty(value="$ref")
    private URI ref;
    @Nullable
    @Attribute(description="The displayName of the User's manager.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_ONLY, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String displayName;

    @Nullable
    public String getValue() {
        return this.value;
    }

    @NotNull
    public Manager setValue(@Nullable String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public URI getRef() {
        return this.ref;
    }

    @NotNull
    public Manager setRef(@Nullable URI ref) {
        this.ref = ref;
        return this;
    }

    @Nullable
    public String getDisplayName() {
        return this.displayName;
    }

    @NotNull
    public Manager setDisplayName(@Nullable String displayName) {
        this.displayName = displayName;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Manager manager = (Manager)o;
        if (!Objects.equals(this.value, manager.value)) {
            return false;
        }
        if (!Objects.equals(this.ref, manager.ref)) {
            return false;
        }
        return Objects.equals(this.displayName, manager.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.ref, this.displayName);
    }
}

