/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.types.AttributeDefinition;
import java.util.Objects;

public class Role {
    @Nullable
    @Attribute(description="The value of a role.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String value;
    @Nullable
    @Attribute(description="A human readable name, primarily used for display purposes.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String display;
    @Nullable
    @Attribute(description="A label indicating the attribute's function.", isRequired=false, isCaseExact=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT, uniqueness=AttributeDefinition.Uniqueness.NONE)
    private String type;
    @Nullable
    @Attribute(description="A Boolean value indicating the 'primary' or preferred attribute value for this attribute. The primary attribute value 'true' MUST appear no more than once.", isRequired=false, mutability=AttributeDefinition.Mutability.READ_WRITE, returned=AttributeDefinition.Returned.DEFAULT)
    private Boolean primary;

    @Nullable
    public String getValue() {
        return this.value;
    }

    @NotNull
    public Role setValue(@Nullable String value) {
        this.value = value;
        return this;
    }

    @Nullable
    public String getDisplay() {
        return this.display;
    }

    @NotNull
    public Role setDisplay(@Nullable String display) {
        this.display = display;
        return this;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    @NotNull
    public Role setType(@Nullable String type) {
        this.type = type;
        return this;
    }

    @Nullable
    public Boolean getPrimary() {
        return this.primary;
    }

    @NotNull
    public Role setPrimary(@Nullable Boolean primary) {
        this.primary = primary;
        return this;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Role role = (Role)o;
        if (!Objects.equals(this.value, role.value)) {
            return false;
        }
        if (!Objects.equals(this.display, role.display)) {
            return false;
        }
        if (!Objects.equals(this.type, role.type)) {
            return false;
        }
        return Objects.equals(this.primary, role.primary);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.display, this.type, this.primary);
    }
}

