/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.types;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.BaseScimResource;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.AuthenticationScheme;
import com.unboundid.scim2.common.types.BulkConfig;
import com.unboundid.scim2.common.types.ChangePasswordConfig;
import com.unboundid.scim2.common.types.ETagConfig;
import com.unboundid.scim2.common.types.FilterConfig;
import com.unboundid.scim2.common.types.PatchConfig;
import com.unboundid.scim2.common.types.SortConfig;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@Schema(id="urn:ietf:params:scim:schemas:core:2.0:ServiceProviderConfig", name="Service Provider Config", description="SCIM 2.0 Service Provider Config Resource")
public class ServiceProviderConfigResource
extends BaseScimResource {
    @Nullable
    @Attribute(description="An HTTP addressable URI pointing to the service provider's human consumable help documentation.", mutability=AttributeDefinition.Mutability.READ_ONLY)
    private final String documentationUri;
    @NotNull
    @Attribute(description="A complex type that specifies PATCH configuration options.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final PatchConfig patch;
    @NotNull
    @Attribute(description="A complex type that specifies Bulk configuration options.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final BulkConfig bulk;
    @NotNull
    @Attribute(description="A complex type that specifies FILTER options.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final FilterConfig filter;
    @NotNull
    @Attribute(description="A complex type that specifies Change Password configuration options.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final ChangePasswordConfig changePassword;
    @NotNull
    @Attribute(description="A complex type that specifies Sort configuration options.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final SortConfig sort;
    @NotNull
    @Attribute(description="A complex type that specifies Etag configuration options.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true)
    private final ETagConfig etag;
    @NotNull
    @Attribute(description="A complex type that specifies supported Authentication Scheme properties.", mutability=AttributeDefinition.Mutability.READ_ONLY, isRequired=true, multiValueClass=AuthenticationScheme.class)
    private final List<AuthenticationScheme> authenticationSchemes;

    @JsonCreator
    public ServiceProviderConfigResource(@Nullable @JsonProperty(value="documentationUri") String documentationUri, @NotNull @JsonProperty(value="patch", required=true) PatchConfig patch, @NotNull @JsonProperty(value="bulk", required=true) BulkConfig bulk, @NotNull @JsonProperty(value="filter", required=true) FilterConfig filter, @NotNull @JsonProperty(value="changePassword", required=true) ChangePasswordConfig changePassword, @NotNull @JsonProperty(value="sort", required=true) SortConfig sort, @NotNull @JsonProperty(value="etag", required=true) ETagConfig etag, @NotNull @JsonProperty(value="authenticationSchemes", required=true) List<AuthenticationScheme> authenticationSchemes) {
        this.documentationUri = documentationUri;
        this.patch = patch;
        this.bulk = bulk;
        this.filter = filter;
        this.changePassword = changePassword;
        this.sort = sort;
        this.etag = etag;
        this.authenticationSchemes = authenticationSchemes == null ? null : Collections.unmodifiableList(authenticationSchemes);
    }

    @Nullable
    public String getDocumentationUri() {
        return this.documentationUri;
    }

    @NotNull
    public PatchConfig getPatch() {
        return this.patch;
    }

    @NotNull
    public BulkConfig getBulk() {
        return this.bulk;
    }

    @NotNull
    public FilterConfig getFilter() {
        return this.filter;
    }

    @NotNull
    public ChangePasswordConfig getChangePassword() {
        return this.changePassword;
    }

    @NotNull
    public SortConfig getSort() {
        return this.sort;
    }

    @NotNull
    public ETagConfig getEtag() {
        return this.etag;
    }

    @NotNull
    public List<AuthenticationScheme> getAuthenticationSchemes() {
        return this.authenticationSchemes;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ServiceProviderConfigResource that = (ServiceProviderConfigResource)o;
        if (!Objects.equals(this.authenticationSchemes, that.authenticationSchemes)) {
            return false;
        }
        if (!Objects.equals(this.bulk, that.bulk)) {
            return false;
        }
        if (!Objects.equals(this.changePassword, that.changePassword)) {
            return false;
        }
        if (!Objects.equals(this.documentationUri, that.documentationUri)) {
            return false;
        }
        if (!Objects.equals(this.etag, that.etag)) {
            return false;
        }
        if (!Objects.equals(this.filter, that.filter)) {
            return false;
        }
        if (!Objects.equals(this.patch, that.patch)) {
            return false;
        }
        return Objects.equals(this.sort, that.sort);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.documentationUri, this.patch, this.bulk, this.filter, this.changePassword, this.sort, this.etag, this.authenticationSchemes);
    }
}

