/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class CaseIgnoreMap
implements Map<String, JsonNode> {
    @NotNull
    private final LinkedHashMap<CaseIgnoreKey, JsonNode> attributes;

    public CaseIgnoreMap() {
        this.attributes = new LinkedHashMap();
    }

    public CaseIgnoreMap(@NotNull Map<String, JsonNode> map) {
        this.attributes = new LinkedHashMap(map.size());
        this.putAll((Map<? extends String, ? extends JsonNode>)map);
    }

    @Override
    public int size() {
        return this.attributes.size();
    }

    @Override
    public boolean isEmpty() {
        return this.attributes.isEmpty();
    }

    @Override
    public boolean containsKey(@NotNull Object key) {
        return this.attributes.containsKey(new CaseIgnoreKey(key.toString()));
    }

    @Override
    public boolean containsValue(@Nullable Object value) {
        return this.attributes.containsValue(value);
    }

    @Override
    @Nullable
    public JsonNode get(@NotNull Object key) {
        return this.attributes.get(new CaseIgnoreKey(key.toString()));
    }

    @Override
    @Nullable
    public JsonNode put(@NotNull String key, @NotNull JsonNode value) {
        return this.attributes.put(new CaseIgnoreKey(key), value);
    }

    @Override
    @Nullable
    public JsonNode remove(@NotNull Object key) {
        return (JsonNode)this.attributes.remove(new CaseIgnoreKey(key.toString()));
    }

    @Override
    public void putAll(@NotNull Map<? extends String, ? extends JsonNode> m) {
        for (Map.Entry<? extends String, ? extends JsonNode> entry : m.entrySet()) {
            this.attributes.put(new CaseIgnoreKey(entry.getKey()), entry.getValue());
        }
    }

    @Override
    public void clear() {
        this.attributes.clear();
    }

    @Override
    @NotNull
    public Set<String> keySet() {
        return new KeySet(this.attributes.keySet());
    }

    @Override
    @NotNull
    public Collection<JsonNode> values() {
        return this.attributes.values();
    }

    @Override
    @NotNull
    public Set<Map.Entry<String, JsonNode>> entrySet() {
        return new EntrySet(this.attributes.entrySet());
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CaseIgnoreMap that = (CaseIgnoreMap)o;
        return this.attributes.equals(that.attributes);
    }

    @Override
    public int hashCode() {
        return this.attributes.hashCode();
    }

    @NotNull
    public String toString() {
        return this.attributes.toString();
    }

    private static class CaseIgnoreKey {
        @NotNull
        private final String key;

        CaseIgnoreKey(@NotNull String key) {
            this.key = key;
        }

        @NotNull
        public String getKey() {
            return this.key;
        }

        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CaseIgnoreKey that = (CaseIgnoreKey)o;
            return StaticUtils.toLowerCase(this.key).equals(StaticUtils.toLowerCase(that.key));
        }

        public int hashCode() {
            return StaticUtils.toLowerCase(this.key).hashCode();
        }
    }

    private static class KeySet
    extends AbstractSet<String> {
        @NotNull
        private final Set<CaseIgnoreKey> keys;

        KeySet(@NotNull Set<CaseIgnoreKey> keys) {
            this.keys = keys;
        }

        @Override
        @NotNull
        public Iterator<String> iterator() {
            return new KeyIterator(this.keys.iterator());
        }

        @Override
        public int size() {
            return this.keys.size();
        }
    }

    private static class EntrySet
    extends AbstractSet<Map.Entry<String, JsonNode>> {
        @NotNull
        private final Set<Map.Entry<CaseIgnoreKey, JsonNode>> entries;

        EntrySet(@NotNull Set<Map.Entry<CaseIgnoreKey, JsonNode>> entries) {
            this.entries = entries;
        }

        @Override
        @NotNull
        public Iterator<Map.Entry<String, JsonNode>> iterator() {
            return new EntryIterator(this.entries.iterator());
        }

        @Override
        public int size() {
            return this.entries.size();
        }
    }

    private static class EntryIterator
    implements Iterator<Map.Entry<String, JsonNode>> {
        @NotNull
        private final Iterator<Map.Entry<CaseIgnoreKey, JsonNode>> iterator;

        EntryIterator(@NotNull Iterator<Map.Entry<CaseIgnoreKey, JsonNode>> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @NotNull
        public Map.Entry<String, JsonNode> next() {
            Map.Entry<CaseIgnoreKey, JsonNode> entry = this.iterator.next();
            return new AbstractMap.SimpleEntry<String, JsonNode>(entry.getKey().getKey(), entry.getValue());
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    private static class KeyIterator
    implements Iterator<String> {
        @NotNull
        private final Iterator<CaseIgnoreKey> iterator;

        KeyIterator(@NotNull Iterator<CaseIgnoreKey> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        @NotNull
        public String next() {
            return this.iterator.next().getKey();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

