/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ValueNode;
import com.unboundid.scim2.common.Path;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.filters.Filter;
import com.unboundid.scim2.common.messages.PatchOperation;
import com.unboundid.scim2.common.utils.Debug;
import com.unboundid.scim2.common.utils.DebugType;
import com.unboundid.scim2.common.utils.JsonUtils;
import com.unboundid.scim2.common.utils.SchemaUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;

public class JsonDiff {
    @NotNull
    public List<PatchOperation> diff(@NotNull ObjectNode source, @NotNull ObjectNode target, boolean removeMissing) {
        LinkedList<PatchOperation> ops = new LinkedList<PatchOperation>();
        ObjectNode targetToAdd = target.deepCopy();
        ObjectNode targetToReplace = target.deepCopy();
        this.diff(Path.root(), source, targetToAdd, targetToReplace, ops, removeMissing);
        if (!targetToReplace.isEmpty()) {
            ops.add(PatchOperation.replace(targetToReplace));
        }
        if (!targetToAdd.isEmpty()) {
            ops.add(PatchOperation.add((JsonNode)targetToAdd));
        }
        return ops;
    }

    private void diff(@NotNull Path parentPath, @NotNull ObjectNode source, @NotNull ObjectNode targetToAdd, @NotNull ObjectNode targetToReplace, @NotNull List<PatchOperation> operations, boolean removeMissing) {
        Iterator si = source.fields();
        while (si.hasNext()) {
            this.processEntry(parentPath, targetToAdd, targetToReplace, operations, removeMissing, (Map.Entry)si.next());
        }
        if (targetToAdd != targetToReplace) {
            Iterator ai = targetToAdd.fieldNames();
            while (ai.hasNext()) {
                String f = (String)ai.next();
                if (source.has(f)) continue;
                ai.remove();
            }
        }
        this.removeNullAndEmptyValues((JsonNode)targetToAdd);
        this.removeNullAndEmptyValues((JsonNode)targetToReplace);
    }

    private void processEntry(@NotNull Path parentPath, @NotNull ObjectNode targetToAdd, @NotNull ObjectNode targetToReplace, @NotNull List<PatchOperation> operations, boolean removeMissing, @NotNull Map.Entry<String, JsonNode> sourceEntry) {
        JsonNode targetValueToReplace;
        String sourceKey = sourceEntry.getKey();
        JsonNode sourceNode = sourceEntry.getValue();
        Path path = this.computeDiffPath(parentPath, sourceKey);
        JsonNode targetValueToAdd = targetToAdd.remove(sourceKey);
        JsonNode jsonNode = targetValueToReplace = targetToReplace == targetToAdd ? targetValueToAdd : targetToReplace.remove(sourceKey);
        if (targetValueToAdd == null) {
            if (removeMissing) {
                operations.add(PatchOperation.remove(path));
            }
            return;
        }
        if (this.isSameType(sourceNode, targetValueToAdd)) {
            this.replaceNode(parentPath, path, targetToAdd, targetToReplace, operations, removeMissing, sourceNode, targetValueToAdd, targetValueToReplace, sourceKey);
        } else if (targetValueToAdd.isNull() || targetValueToAdd.isArray() && targetValueToAdd.isEmpty()) {
            operations.add(PatchOperation.remove(path));
        } else {
            targetToReplace.set(sourceKey, targetValueToReplace);
        }
    }

    private void replaceNode(@NotNull Path parentPath, @NotNull Path path, @NotNull ObjectNode targetToAdd, @NotNull ObjectNode targetToReplace, @NotNull List<PatchOperation> operations, boolean removeMissing, @NotNull JsonNode sourceNode, @NotNull JsonNode targetValueToAdd, @NotNull JsonNode targetValueToReplace, @NotNull String sourceKey) {
        if (sourceNode.isObject()) {
            this.computeObjectNodeDiffs(path, sourceNode, targetValueToAdd, targetValueToReplace, operations, removeMissing, targetToAdd, targetToReplace, sourceKey);
        } else if (sourceNode.isArray()) {
            this.computeArrayNodeDiffs(parentPath, path, targetToAdd, targetToReplace, operations, removeMissing, sourceNode, targetValueToAdd, targetValueToReplace, sourceKey);
        } else if (this.compareTo(path.withoutFilters(), sourceNode, targetValueToAdd) != 0) {
            targetToReplace.set(sourceKey, targetValueToReplace);
        }
    }

    protected int compareTo(@NotNull Path path, @NotNull JsonNode sourceNode, @NotNull JsonNode targetNode) {
        return JsonUtils.compareTo(sourceNode, targetNode, null);
    }

    private void computeArrayNodeDiffs(@NotNull Path parentPath, @NotNull Path path, @NotNull ObjectNode targetToAdd, @NotNull ObjectNode targetToReplace, @NotNull List<PatchOperation> operations, boolean removeMissing, @NotNull JsonNode sourceNode, @NotNull JsonNode targetValueToAdd, @NotNull JsonNode targetValueToReplace, @NotNull String sourceKey) {
        if (targetValueToAdd.isEmpty()) {
            if (sourceNode != null && sourceNode.isArray() && sourceNode.isEmpty()) {
                return;
            }
            operations.add(PatchOperation.remove(path));
        } else {
            LinkedList<PatchOperation> targetOpToRemoveOrReplace = new LinkedList<PatchOperation>();
            boolean replaceAllValues = false;
            for (JsonNode sv : sourceNode) {
                JsonNode tv = this.removeMatchingValue(sv, (ArrayNode)targetValueToAdd);
                Filter valueFilter = this.generateValueFilter(sv);
                if (valueFilter == null) {
                    replaceAllValues = true;
                    Debug.debug(Level.WARNING, DebugType.OTHER, "Performing full replace of target array node " + path + " since the it is not possible to generate a value filter to uniquely identify the value " + sv);
                    break;
                }
                Path valuePath = parentPath.attribute(sourceKey, valueFilter);
                if (tv != null) {
                    if (!sv.isObject() || !tv.isObject()) continue;
                    this.diff(valuePath, (ObjectNode)sv, (ObjectNode)tv, (ObjectNode)tv, operations, removeMissing);
                    if (tv.isEmpty()) continue;
                    targetOpToRemoveOrReplace.add(PatchOperation.replace(valuePath, tv));
                    continue;
                }
                targetOpToRemoveOrReplace.add(PatchOperation.remove(valuePath));
            }
            if (!replaceAllValues && targetValueToReplace.size() <= targetValueToAdd.size() + targetOpToRemoveOrReplace.size()) {
                Debug.debug(Level.INFO, DebugType.OTHER, "Performing full replace of target array node " + path + " since the array (" + targetValueToReplace.size() + ") is smaller than removing and replacing (" + targetOpToRemoveOrReplace.size() + ") then adding (" + targetValueToAdd.size() + ")  the values individually");
                replaceAllValues = true;
                targetToReplace.set(sourceKey, targetValueToReplace);
            }
            if (replaceAllValues) {
                targetToReplace.set(sourceKey, targetValueToReplace);
            } else {
                if (!targetOpToRemoveOrReplace.isEmpty()) {
                    operations.addAll(targetOpToRemoveOrReplace);
                }
                if (!targetValueToAdd.isEmpty()) {
                    targetToAdd.set(sourceKey, targetValueToAdd);
                }
            }
        }
    }

    private void computeObjectNodeDiffs(@NotNull Path path, @NotNull JsonNode sourceNode, @NotNull JsonNode targetValueToAdd, @NotNull JsonNode targetValueToReplace, @NotNull List<PatchOperation> operations, boolean removeMissing, @NotNull ObjectNode targetToAdd, @NotNull ObjectNode targetToReplace, @NotNull String sourceKey) {
        this.diff(path, (ObjectNode)sourceNode, (ObjectNode)targetValueToAdd, (ObjectNode)targetValueToReplace, operations, removeMissing);
        if (!targetValueToAdd.isEmpty()) {
            targetToAdd.set(sourceKey, targetValueToAdd);
        }
        if (!targetValueToReplace.isEmpty()) {
            targetToReplace.set(sourceKey, targetValueToReplace);
        }
    }

    @NotNull
    private Path computeDiffPath(@NotNull Path parentPath, @NotNull String sourceKey) {
        return parentPath.isRoot() && SchemaUtils.isUrn(sourceKey) ? Path.root(sourceKey) : parentPath.attribute(sourceKey);
    }

    @Nullable
    private JsonNode removeMatchingValue(@NotNull JsonNode sourceValue, @NotNull ArrayNode targetValues) {
        if (sourceValue.isObject()) {
            TreeMap<Integer, Integer> matchScoreToIndex = new TreeMap<Integer, Integer>();
            for (int i = 0; i < targetValues.size(); ++i) {
                JsonNode targetValue = targetValues.get(i);
                if (!targetValue.isObject()) continue;
                int matchScore = 0;
                Iterator si = sourceValue.fieldNames();
                block13: while (si.hasNext()) {
                    String field = (String)si.next();
                    if (!sourceValue.get(field).equals((Object)targetValue.path(field))) continue;
                    switch (field) {
                        case "value": 
                        case "$ref": {
                            matchScore += 3;
                            continue block13;
                        }
                        case "type": 
                        case "display": {
                            matchScore += 2;
                            continue block13;
                        }
                        case "primary": {
                            matchScore += 0;
                            continue block13;
                        }
                    }
                    ++matchScore;
                }
                if (matchScore <= 0 || matchScoreToIndex.containsKey(matchScore)) continue;
                matchScoreToIndex.put(matchScore, i);
            }
            if (!matchScoreToIndex.isEmpty()) {
                return targetValues.remove(((Integer)matchScoreToIndex.lastEntry().getValue()).intValue());
            }
        } else {
            for (int i = 0; i < targetValues.size(); ++i) {
                if (JsonUtils.compareTo(sourceValue, targetValues.get(i), null) != 0) continue;
                return targetValues.remove(i);
            }
        }
        return null;
    }

    @Nullable
    private Filter generateValueFilter(@NotNull JsonNode value) {
        if (value.isValueNode()) {
            return Filter.eq(Path.root().attribute("value"), (ValueNode)value);
        }
        if (value.isObject()) {
            ArrayList<Filter> filters = new ArrayList<Filter>(value.size());
            Iterator fieldsIterator = value.fields();
            while (fieldsIterator.hasNext()) {
                Map.Entry field = (Map.Entry)fieldsIterator.next();
                if (!((JsonNode)field.getValue()).isValueNode()) {
                    return null;
                }
                filters.add(Filter.eq(Path.root().attribute((String)field.getKey()), (ValueNode)field.getValue()));
            }
            if (filters.isEmpty()) {
                return null;
            }
            if (filters.size() == 1) {
                return (Filter)filters.get(0);
            }
            return Filter.and(filters);
        }
        return null;
    }

    private void removeNullAndEmptyValues(@NotNull JsonNode node) {
        Iterator si = node.elements();
        while (si.hasNext()) {
            JsonNode field = (JsonNode)si.next();
            if (JsonUtils.isNullNodeOrEmptyArray(field)) {
                si.remove();
                continue;
            }
            if (!field.isContainerNode()) continue;
            this.removeNullAndEmptyValues(field);
        }
    }

    public boolean isSameType(@NotNull JsonNode n1, @NotNull JsonNode n2) {
        return n1.getNodeType() == n2.getNodeType() || (n1.isTextual() || n1.isBinary()) && (n2.isTextual() || n2.isBinary());
    }
}

