/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.unboundid.scim2.common.annotations.Attribute;
import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import com.unboundid.scim2.common.annotations.Schema;
import com.unboundid.scim2.common.types.AttributeDefinition;
import com.unboundid.scim2.common.types.Meta;
import com.unboundid.scim2.common.types.SchemaResource;
import com.unboundid.scim2.common.utils.StaticUtils;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.Transient;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Stack;
import javax.lang.model.type.NullType;

public class SchemaUtils {
    @NotNull
    public static final AttributeDefinition SCHEMAS_ATTRIBUTE_DEFINITION;
    @NotNull
    public static final AttributeDefinition ID_ATTRIBUTE_DEFINITION;
    @NotNull
    public static final AttributeDefinition EXTERNAL_ID_ATTRIBUTE_DEFINITION;
    @NotNull
    public static final AttributeDefinition META_ATTRIBUTE_DEFINITION;
    @NotNull
    public static final Collection<AttributeDefinition> COMMON_ATTRIBUTE_DEFINITIONS;

    @NotNull
    public static Collection<PropertyDescriptor> getPropertyDescriptors(@NotNull Class<?> cls) throws IntrospectionException {
        BeanInfo beanInfo = Introspector.getBeanInfo(cls, Object.class);
        PropertyDescriptor[] propertyDescriptors = beanInfo.getPropertyDescriptors();
        return Arrays.asList(propertyDescriptors);
    }

    @Transient
    @NotNull
    public static Collection<AttributeDefinition> getAttributes(@NotNull Class<?> cls) throws IntrospectionException {
        Stack<String> classesProcessed = new Stack<String>();
        return SchemaUtils.getAttributes(classesProcessed, cls);
    }

    @NotNull
    private static Collection<AttributeDefinition> getAttributes(@NotNull Stack<String> classesProcessed, @NotNull Class<?> cls) throws IntrospectionException {
        String className = cls.getCanonicalName();
        if (!cls.isAssignableFrom(AttributeDefinition.class) && classesProcessed.contains(className)) {
            throw new RuntimeException("Cycles detected in Schema");
        }
        Collection<PropertyDescriptor> propertyDescriptors = SchemaUtils.getPropertyDescriptors(cls);
        ArrayList<AttributeDefinition> attributes = new ArrayList<AttributeDefinition>();
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
            if (propertyDescriptor.getName().equals("subAttributes") && cls.isAssignableFrom(AttributeDefinition.class) && classesProcessed.contains(className)) continue;
            AttributeDefinition.Builder attributeBuilder = new AttributeDefinition.Builder();
            Field field = SchemaUtils.findField(cls, propertyDescriptor.getName());
            if (field == null) continue;
            Attribute schemaProperty = null;
            JsonProperty jsonProperty = null;
            if (field.isAnnotationPresent(Attribute.class)) {
                schemaProperty = field.getAnnotation(Attribute.class);
            }
            if (field.isAnnotationPresent(JsonProperty.class)) {
                jsonProperty = field.getAnnotation(JsonProperty.class);
            }
            if (schemaProperty == null) continue;
            SchemaUtils.addName(attributeBuilder, propertyDescriptor, jsonProperty);
            SchemaUtils.addDescription(attributeBuilder, schemaProperty);
            SchemaUtils.addCaseExact(attributeBuilder, schemaProperty);
            SchemaUtils.addRequired(attributeBuilder, schemaProperty);
            SchemaUtils.addReturned(attributeBuilder, schemaProperty);
            SchemaUtils.addUniqueness(attributeBuilder, schemaProperty);
            SchemaUtils.addReferenceTypes(attributeBuilder, schemaProperty);
            SchemaUtils.addMutability(attributeBuilder, schemaProperty);
            SchemaUtils.addMultiValued(attributeBuilder, propertyDescriptor, schemaProperty);
            SchemaUtils.addCanonicalValues(attributeBuilder, schemaProperty);
            Class<?> propertyCls = propertyDescriptor.getPropertyType();
            if (schemaProperty.multiValueClass() != NullType.class) {
                propertyCls = schemaProperty.multiValueClass();
            }
            AttributeDefinition.Type type = SchemaUtils.getAttributeType(propertyCls);
            attributeBuilder.setType(type);
            if (type == AttributeDefinition.Type.COMPLEX) {
                classesProcessed.push(cls.getCanonicalName());
                Collection<AttributeDefinition> subAttributes = SchemaUtils.getAttributes(classesProcessed, propertyCls);
                attributeBuilder.addSubAttributes(subAttributes.toArray(new AttributeDefinition[0]));
                classesProcessed.pop();
            }
            attributes.add(attributeBuilder.build());
        }
        return attributes;
    }

    @NotNull
    private static AttributeDefinition.Builder addName(@NotNull AttributeDefinition.Builder attributeBuilder, @NotNull PropertyDescriptor propertyDescriptor, @Nullable JsonProperty jsonProperty) {
        if (jsonProperty != null && !jsonProperty.value().equals("")) {
            attributeBuilder.setName(jsonProperty.value());
        } else {
            attributeBuilder.setName(propertyDescriptor.getName());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addMultiValued(@NotNull AttributeDefinition.Builder attributeBuilder, @NotNull PropertyDescriptor propertyDescriptor, @NotNull Attribute schemaProperty) {
        Class<?> multiValuedClass = schemaProperty.multiValueClass();
        boolean multiValued = !multiValuedClass.equals(NullType.class);
        boolean collectionOrArray = SchemaUtils.isCollectionOrArray(propertyDescriptor.getPropertyType());
        if (multiValued && !collectionOrArray) {
            throw new RuntimeException("Property named " + propertyDescriptor.getName() + " is annotated with a multiValuedClass, but is not a Collection or an array");
        }
        if (!multiValued && collectionOrArray) {
            throw new RuntimeException("Property named " + propertyDescriptor.getName() + " is not annotated with a multiValuedClass, but is a Collection or an array");
        }
        attributeBuilder.setMultiValued(multiValued);
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addDescription(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.setDescription(schemaProperty.description());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addCaseExact(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.setCaseExact(schemaProperty.isCaseExact());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addRequired(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.setRequired(schemaProperty.isRequired());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addCanonicalValues(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.addCanonicalValues(schemaProperty.canonicalValues());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addReturned(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.setReturned(schemaProperty.returned());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addUniqueness(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.setUniqueness(schemaProperty.uniqueness());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addReferenceTypes(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.addReferenceTypes(schemaProperty.referenceTypes());
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Builder addMutability(@NotNull AttributeDefinition.Builder attributeBuilder, @Nullable Attribute schemaProperty) {
        if (schemaProperty != null) {
            attributeBuilder.setMutability(schemaProperty.mutability());
        } else {
            attributeBuilder.setMutability(AttributeDefinition.Mutability.READ_WRITE);
        }
        return attributeBuilder;
    }

    @NotNull
    private static AttributeDefinition.Type getAttributeType(@NotNull Class<?> cls) {
        if (cls == Integer.class || cls == Integer.TYPE) {
            return AttributeDefinition.Type.INTEGER;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            return AttributeDefinition.Type.BOOLEAN;
        }
        if (cls == Double.class || cls == Double.TYPE || cls == Float.class || cls == Float.TYPE || cls == BigDecimal.class) {
            return AttributeDefinition.Type.DECIMAL;
        }
        if (cls == String.class) {
            return AttributeDefinition.Type.STRING;
        }
        if (cls == URI.class || cls == URL.class) {
            return AttributeDefinition.Type.REFERENCE;
        }
        if (cls == Date.class || cls == Calendar.class) {
            return AttributeDefinition.Type.DATETIME;
        }
        if (cls == byte[].class) {
            return AttributeDefinition.Type.BINARY;
        }
        return AttributeDefinition.Type.COMPLEX;
    }

    @Nullable
    public static SchemaResource getSchema(@NotNull Class<?> cls) throws IntrospectionException {
        Schema schemaAnnotation = cls.getAnnotation(Schema.class);
        if (schemaAnnotation == null) {
            return null;
        }
        return new SchemaResource(schemaAnnotation.id(), schemaAnnotation.name(), schemaAnnotation.description(), SchemaUtils.getAttributes(cls));
    }

    @Nullable
    public static Field findField(@Nullable Class<?> cls, @NotNull String fieldName) {
        for (Class<?> currentClass = cls; currentClass != null; currentClass = currentClass.getSuperclass()) {
            Field[] fields;
            for (Field field : fields = currentClass.getDeclaredFields()) {
                if (!field.getName().equals(fieldName)) continue;
                return field;
            }
        }
        return null;
    }

    private static boolean isCollectionOrArray(@NotNull Class<?> cls) {
        return cls.isArray() && byte[].class != cls || Collection.class.isAssignableFrom(cls);
    }

    @Nullable
    public static String getSchemaIdFromAnnotation(@NotNull Class<?> cls) {
        Schema schema = cls.getAnnotation(Schema.class);
        return SchemaUtils.getSchemaIdFromAnnotation(schema);
    }

    @Nullable
    private static String getSchemaIdFromAnnotation(@Nullable Schema schemaAnnotation) {
        if (schemaAnnotation != null) {
            return schemaAnnotation.id();
        }
        return null;
    }

    @Nullable
    public static String getNameFromSchemaAnnotation(@NotNull Class<?> cls) {
        Schema schema = cls.getAnnotation(Schema.class);
        return SchemaUtils.getNameFromSchemaAnnotation(schema);
    }

    @Nullable
    private static String getNameFromSchemaAnnotation(@Nullable Schema schemaAnnotation) {
        if (schemaAnnotation != null) {
            return schemaAnnotation.name();
        }
        return null;
    }

    @NotNull
    public static String getSchemaUrn(@NotNull Class<?> cls) {
        String schemaId = SchemaUtils.getSchemaIdFromAnnotation(cls);
        if (schemaId == null || schemaId.isEmpty()) {
            schemaId = cls.getCanonicalName();
        }
        return SchemaUtils.forceToBeUrn(schemaId);
    }

    public static boolean isUrn(@NotNull String string) {
        return StaticUtils.toLowerCase(string).startsWith("urn:") && string.length() > 4;
    }

    @NotNull
    public static String forceToBeUrn(@NotNull String string) {
        if (SchemaUtils.isUrn(string)) {
            return string;
        }
        return "urn:" + string;
    }

    static {
        AttributeDefinition.Builder builder = new AttributeDefinition.Builder();
        builder.setType(AttributeDefinition.Type.STRING);
        builder.setName("schemas");
        builder.setRequired(true);
        builder.setCaseExact(true);
        builder.setMultiValued(true);
        builder.setMutability(AttributeDefinition.Mutability.READ_WRITE);
        builder.setReturned(AttributeDefinition.Returned.ALWAYS);
        SCHEMAS_ATTRIBUTE_DEFINITION = builder.build();
        builder = new AttributeDefinition.Builder();
        builder.setType(AttributeDefinition.Type.STRING);
        builder.setName("id");
        builder.setCaseExact(true);
        builder.setMutability(AttributeDefinition.Mutability.READ_ONLY);
        builder.setReturned(AttributeDefinition.Returned.ALWAYS);
        ID_ATTRIBUTE_DEFINITION = builder.build();
        builder = new AttributeDefinition.Builder();
        builder.setType(AttributeDefinition.Type.STRING);
        builder.setName("externalId");
        builder.setCaseExact(true);
        builder.setMutability(AttributeDefinition.Mutability.READ_WRITE);
        EXTERNAL_ID_ATTRIBUTE_DEFINITION = builder.build();
        builder = new AttributeDefinition.Builder();
        builder.setType(AttributeDefinition.Type.COMPLEX);
        builder.setName("meta");
        builder.setMutability(AttributeDefinition.Mutability.READ_ONLY);
        try {
            Collection<AttributeDefinition> subAttributes = SchemaUtils.getAttributes(Meta.class);
            builder.addSubAttributes(subAttributes.toArray(new AttributeDefinition[0]));
        }
        catch (IntrospectionException e) {
            throw new RuntimeException(e);
        }
        META_ATTRIBUTE_DEFINITION = builder.build();
        COMMON_ATTRIBUTE_DEFINITIONS = Collections.unmodifiableCollection(Arrays.asList(SCHEMAS_ATTRIBUTE_DEFINITION, ID_ATTRIBUTE_DEFINITION, EXTERNAL_ID_ATTRIBUTE_DEFINITION, META_ATTRIBUTE_DEFINITION));
    }
}

