/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.scim2.common.utils;

import com.unboundid.scim2.common.annotations.NotNull;
import com.unboundid.scim2.common.annotations.Nullable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;

public final class StaticUtils {
    private StaticUtils() {
    }

    @Nullable
    public static String toLowerCase(@Nullable String s) {
        if (s == null) {
            return null;
        }
        return s.toLowerCase(Locale.ROOT);
    }

    @NotNull
    public static String listToString(@NotNull List<?> list, @Nullable String separator) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            sb.append(list.get(i));
            if (i >= list.size() - 1) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    @NotNull
    public static String collectionToString(@NotNull Collection<?> collection, @Nullable String separator) {
        StringBuilder sb = new StringBuilder();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            sb.append(iter.next());
            if (!iter.hasNext()) continue;
            sb.append(separator);
        }
        return sb.toString();
    }

    @NotNull
    @SafeVarargs
    public static <T> Set<T> arrayToSet(T ... i) {
        LinkedHashSet set = new LinkedHashSet(i.length);
        Collections.addAll(set, i);
        return set;
    }

    @NotNull
    public static String[] splitCommaSeparatedString(@NotNull String str) {
        String[] separatedArray = str.split(",");
        for (int i = 0; i < separatedArray.length; ++i) {
            separatedArray[i] = separatedArray[i].trim();
        }
        return separatedArray;
    }

    public static void getStackTrace(@NotNull Throwable t, @NotNull StringBuilder buffer) {
        buffer.append(t.getClass().getSimpleName());
        buffer.append('(');
        String message = t.getMessage();
        if (message != null) {
            buffer.append("message='");
            buffer.append(message);
            buffer.append("', ");
        }
        buffer.append("trace='");
        StaticUtils.getStackTrace(t.getStackTrace(), buffer);
        buffer.append('\'');
        Throwable cause = t.getCause();
        if (cause != null) {
            buffer.append(", cause=");
            StaticUtils.getStackTrace(cause, buffer);
        }
        buffer.append(", revision=");
        buffer.append("039c7e62645744498f938f3502517dcdd18c2986");
        buffer.append(')');
    }

    public static void getStackTrace(@NotNull StackTraceElement[] elements, @NotNull StringBuilder buffer) {
        for (int i = 0; i < elements.length; ++i) {
            if (i > 0) {
                buffer.append(" / ");
            }
            buffer.append(elements[i].getMethodName());
            buffer.append('(');
            buffer.append(elements[i].getFileName());
            int lineNumber = elements[i].getLineNumber();
            if (lineNumber > 0) {
                buffer.append(':');
                buffer.append(lineNumber);
            }
            buffer.append(')');
        }
    }

    @NotNull
    public static <T> List<T> toList(@NotNull T firstElement, @Nullable T[] elements) {
        Objects.requireNonNull(firstElement);
        ArrayList<T> list = new ArrayList<T>();
        list.add(firstElement);
        if (elements != null) {
            for (T element : elements) {
                if (element == null) continue;
                list.add(element);
            }
        }
        return list;
    }
}

