/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file. If applicable, add the following below this CDDL HEADER,
 * with the fields enclosed by brackets "[]" replaced with your own
 * identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2010-2019 Ping Identity Corporation
 */
package com.unboundid.directory.sdk.broker.internal;



import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;


/**
 * This annotation type may be used to indicate that the marked class represents
 * an API that can be used to create an extension for use in the
 * ${BROKER_PRODUCT_NAME}.
 */
@Documented()
@Retention(RetentionPolicy.RUNTIME)
@Target({ ElementType.TYPE })
@Inherited()
public @interface BrokerExtension
{
  /**
   * A set of notes about the usage of this API in the ${BROKER_BASE_NAME}.
   *
   * @return Notes about the usage of this API in the ${BROKER_BASE_NAME}
   */
  String notes() default "";
}
