/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at
 * docs/licenses/cddl.txt
 * or http://www.opensource.org/licenses/cddl1.php.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at
 * docs/licenses/cddl.txt.  If applicable,
 * add the following below this CDDL HEADER, with the fields enclosed
 * by brackets "[]" replaced with your own identifying information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2018-2019 Ping Identity Corporation
 */

package com.unboundid.directory.sdk.broker.types;

import java.util.Map;

/**
 * Interface providing access to Advice statements returned from a
 * policy evaluation.
 */
public interface AdviceStatement {

  /**
   * Get the name of the Advice instance.
   * @return the Advice name.
   */
  String getName();

  /**
   * Get the code (advice Id) of the Advice instance.  The advice
   * code corresponds to the type of advice returned.
   * @return the Advice code.
   */
  String getCode();

  /**
   * Get the payload returned with this advice instance.
   * @return The payload string, whose interpretation is specific to the Advice
   * type.
   */
  String getPayload();

  /**
   * Determine whether this Advice is obligatory.
   * @return boolean value, true for obligatory advice.
   */
  boolean isObligatory();

  /**
   * Get the value of any Trust Framework Attributes that were returned along
   * with the Advice instance.
   * @return a Map of Attribute name to Attribute value.
   */
  Map<String, String> getAttributes();
}
